<?php
/**
 * Easy Digital Downloads Theme Updater
 *
 * @package Travel Insight Pro
 */

// Includes the files needed for the theme updater
if ( ! class_exists( 'EDD_Theme_Updater_Admin' ) ) {
	include dirname( __FILE__ ) . '/theme-updater-admin.php';
}

$theme = wp_get_theme( get_template() );

// Loads the updater classes
$updater = new EDD_Theme_Updater_Admin(
	// Config settings
	array(
		'remote_api_url' => 'https://themepalace.com', // Site where EDD is hosted
		'item_name'      => $theme->get( 'Name' ), // Name of theme
		'theme_slug'     => $theme->get( 'TextDomain' ), // Theme slug
		'version'        => $theme->get( 'Version' ), // The current version of this theme
		'author'         => $theme->get( 'Author' ), // The author of this theme
		'download_id'    => '', // Optional, used for generating a license renewal link
		'renew_url'      => 'https://themepalace.com/my-account/', // Optional, allows for a custom license renewal link
		'beta'           => false, // Optional, set to true to opt into beta versions
		'item_id'        => '',
	),
	// Strings
	array(
		'theme-license'             => __( 'Theme License', 'travel-insight-pro' ),
		'enter-key'                 => __( 'Enter your theme license key.', 'travel-insight-pro' ),
		'license-key'               => __( 'License Key', 'travel-insight-pro' ),
		'license-action'            => __( 'License Action', 'travel-insight-pro' ),
		'deactivate-license'        => __( 'Deactivate License', 'travel-insight-pro' ),
		'activate-license'          => __( 'Activate License', 'travel-insight-pro' ),
		'status-unknown'            => __( 'License status is unknown.', 'travel-insight-pro' ),
		'renew'                     => __( 'Renew?', 'travel-insight-pro' ),
		'unlimited'                 => __( 'unlimited', 'travel-insight-pro' ),
		'license-key-is-active'     => __( 'License key is active.', 'travel-insight-pro' ),
		/* translators: the license expiration date */
		'expires%s'                 => __( 'Expires %s.', 'travel-insight-pro' ),
		'expires-never'             => __( 'Lifetime License.', 'travel-insight-pro' ),
		/* translators: 1. the number of sites activated 2. the total number of activations allowed. */
		'%1$s/%2$-sites'            => __( 'You have %1$s / %2$s sites activated.', 'travel-insight-pro' ),
		'activation-limit'          => __( 'Your license key has reached its activation limit.', 'travel-insight-pro' ),
		/* translators: the license expiration date */
		'license-key-expired-%s'    => __( 'License key expired %s.', 'travel-insight-pro' ),
		'license-key-expired'       => __( 'License key has expired.', 'travel-insight-pro' ),
		/* translators: the license expiration date */
		'license-expired-on'        => __( 'Your license key expired on %s.', 'travel-insight-pro' ),
		'license-keys-do-not-match' => __( 'License keys do not match.', 'travel-insight-pro' ),
		'license-is-inactive'       => __( 'License is inactive.', 'travel-insight-pro' ),
		'license-key-is-disabled'   => __( 'License key is disabled.', 'travel-insight-pro' ),
		'license-key-invalid'       => __( 'Invalid license.', 'travel-insight-pro' ),
		'site-is-inactive'          => __( 'Site is inactive.', 'travel-insight-pro' ),
		/* translators: the theme name */
		'item-mismatch'             => __( 'This appears to be an invalid license key for %s.', 'travel-insight-pro' ),
		'license-status-unknown'    => __( 'License status is unknown.', 'travel-insight-pro' ),
		'update-notice'             => __( "Updating this theme will lose any customizations you have made. 'Cancel' to stop, 'OK' to update.", 'travel-insight-pro' ),
		'error-generic'             => __( 'An error occurred, please try again.', 'travel-insight-pro' ),
		'key-not-activated'         => __( '%1$s License Key has not been activated, so the theme is inactive. %2$sClick here%3$s to activate the license key and the theme.', 'travel-insight-pro' ),
		'get-license-key'           => __( 'Get API key from %s.', 'travel-insight-pro' ),
		'theme-palace'              => __( 'Theme Palace', 'travel-insight-pro' ),
	)
);
