<?php
/**
 * Itinerary Archive Template
 *
 * This template can be overridden by copying it to yourtheme/wp-travel/archive-itineraries.php.
 *
 * HOWEVER, on occasion wp-travel will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see 	    http://docs.wensolutions.com/document/template-structure/
 * @author      WenSolutions
 * @package     wp-travel/Templates
 * @since       1.0.0
 */

get_header( 'itinerary' ); ?>
	<?php
	$current_theme = wp_get_theme();
	if( 'twentyseventeen' === $current_theme->get( 'TextDomain' ) ) {
		?>
				<div class="wrap">
		<?php
	}
	?>

<div class="wrapper page-section no-padding-bottom <?php echo is_active_sidebar( 'wp-travel-archive-sidebar' ) ? 'secondary-active' : 'secondary-inactive'; ?>">
	<?php do_action( 'wp_travel_before_main_content' ); ?>
		<div id="primary" class="content-area">
		  	<main id="main" class="site-main" role="main">
		  		<div class="blog-text clear">

					<?php if ( have_posts() ) : ?>
						<?php while ( have_posts() ) : the_post(); ?>
							<?php travel_insight_pro_wptravel_get_template_part( 'content', 'archive-itineraries' ); ?>
						<?php endwhile; // end of the loop. ?>
					<?php else : ?>
						<?php travel_insight_pro_wptravel_get_template_part( 'content', 'archive-itineraries-none' ); ?>
					<?php endif; ?>

				</div><!-- .blog-text -->
				<?php  
				/**
				* Hook - travel_insight_pro_action_pagination.
				*
				* @hooked travel_insight_pro_pagination 
				*/
				do_action( 'travel_insight_pro_action_pagination' );

				/**
				* Hook - travel_insight_pro_infinite_loader_spinner_action.
				*
				* @hooked travel_insight_pro_infinite_loader_spinner 
				*/
				do_action( 'travel_insight_pro_infinite_loader_spinner_action' );
				?>
			</main><!-- #main -->
		</div><!-- #primary -->

		<aside id="secondary">
			<?php do_action( 'wp_travel_archive_listing_sidebar' ); ?>
		</aside>
	<?php do_action( 'wp_travel_after_main_content' ); ?>
</div>
<?php
if( 'twentyseventeen' === $current_theme->get( 'TextDomain' ) ) {
	?>
		</div>
	<?php
}
?>
<?php get_footer( 'itinerary' ); ?>
