<?php
/**
 * Theme functions and definitions.
 *
 * @link https://codex.wordpress.org/Functions_File_Explained
 *
 * @package Magazine_Plus
 */

if ( ! function_exists( 'magazine_plus_setup' ) ) :

	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function magazine_plus_setup() {

		// Make theme available for translation.
		load_theme_textdomain( 'magazine-plus-pro', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		// Let WordPress manage the document title.
		add_theme_support( 'title-tag' );

		// Enable support for Post Thumbnails on posts and pages.
		add_theme_support( 'post-thumbnails' );
		add_image_size( 'magazine-plus-thumb', 370, 250 );
		add_image_size( 'magazine-plus-carousel', 400, 400, true );

		// Register menu locations.
		register_nav_menus( array(
			'primary'  => esc_html__( 'Primary Menu', 'magazine-plus-pro' ),
			'top'      => esc_html__( 'Top Menu', 'magazine-plus-pro' ),
			'footer'   => esc_html__( 'Footer Menu', 'magazine-plus-pro' ),
			'social'   => esc_html__( 'Social Menu', 'magazine-plus-pro' ),
			'notfound' => esc_html__( '404 Menu', 'magazine-plus-pro' ),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'comment-form',
			'search-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'magazine_plus_custom_background_args', array(
			'default-color' => 'FFFFFF',
			'default-image' => '',
		) ) );

		// Enable support for selective refresh of widgets in Customizer.
		add_theme_support( 'customize-selective-refresh-widgets' );

		// Enable support for custom logo.
		add_theme_support( 'custom-logo' );

		// Load default block styles.
		add_theme_support( 'wp-block-styles' );

		// Add support for responsive embeds.
		add_theme_support( 'responsive-embeds' );

		// Enable support for footer widgets.
		add_theme_support( 'footer-widgets', 4 );

		// Load Supports.
		require get_template_directory() . '/inc/support.php';

		global $magazine_plus_default_options;
		$magazine_plus_default_options = magazine_plus_get_default_theme_options();

	}
endif;

add_action( 'after_setup_theme', 'magazine_plus_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function magazine_plus_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'magazine_plus_content_width', 640 );
}
add_action( 'after_setup_theme', 'magazine_plus_content_width', 0 );

/**
 * Register widget area.
 */
function magazine_plus_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Primary Sidebar', 'magazine-plus-pro' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here to appear in your Primary Sidebar.', 'magazine-plus-pro' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title"><span>',
		'after_title'   => '</span></h2>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Secondary Sidebar', 'magazine-plus-pro' ),
		'id'            => 'sidebar-2',
		'description'   => esc_html__( 'Add widgets here to appear in your Secondary Sidebar.', 'magazine-plus-pro' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title"><span>',
		'after_title'   => '</span></h2>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Front Page Widget Area', 'magazine-plus-pro' ),
		'id'            => 'sidebar-front-page-widget-area',
		'description'   => esc_html__( 'Add widgets here to appear in Front Page Widget Area.', 'magazine-plus-pro' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title"><span>',
		'after_title'   => '</span></h2>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Front Page Bottom Widget Area', 'magazine-plus-pro' ),
		'id'            => 'sidebar-front-page-bottom-widget-area',
		'description'   => esc_html__( 'Add widgets here to appear in Front Page Bottom Widget Area.', 'magazine-plus-pro' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title"><span>',
		'after_title'   => '</span></h2>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Header Right Widget Area', 'magazine-plus-pro' ),
		'id'            => 'header-right',
		'description'   => esc_html__( 'Add widgets here to appear in Header Right Widget Area.', 'magazine-plus-pro' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title"><span>',
		'after_title'   => '</span></h2>',
	) );
	register_sidebar( array(
		'name'          => sprintf( __( 'Extra Sidebar %d', 'magazine-plus-pro' ), 1 ),
		'id'            => 'extra-sidebar-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title"><span>',
		'after_title'   => '</span></h2>',
	) );
	register_sidebar( array(
		'name'          => sprintf( __( 'Extra Sidebar %d', 'magazine-plus-pro' ), 2 ),
		'id'            => 'extra-sidebar-2',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title"><span>',
		'after_title'   => '</span></h2>',
	) );
	register_sidebar( array(
		'name'          => sprintf( __( 'Extra Sidebar %d', 'magazine-plus-pro' ), 3 ),
		'id'            => 'extra-sidebar-3',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title"><span>',
		'after_title'   => '</span></h2>',
	) );
	register_sidebar( array(
		'name'          => sprintf( __( 'Extra Sidebar %d', 'magazine-plus-pro' ), 4 ),
		'id'            => 'extra-sidebar-4',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title"><span>',
		'after_title'   => '</span></h2>',
	) );

}
add_action( 'widgets_init', 'magazine_plus_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function magazine_plus_scripts() {

	$theme_version = wp_get_theme()->get( 'Version' );

	$min = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

	wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/third-party/font-awesome/css/font-awesome' . $min . '.css', '', '4.7.0' );

	wp_enqueue_style( 'magazine-plus-google-fonts', magazine_plus_fonts_url(), array(), null );

	wp_enqueue_style( 'jquery-slick', get_template_directory_uri() .'/third-party/slick/slick' . $min . '.css', '', '1.6.0' );

	wp_enqueue_style( 'magazine-plus-style', get_stylesheet_uri(), array(), $theme_version );

	$site_design = magazine_plus_get_option( 'site_design' );
	if ( 'moto-news' == $site_design ) {
		wp_enqueue_style( 'moto-news-style', get_template_directory_uri() . '/css/moto-news.css', array(), 	1.0 );
	}

	wp_enqueue_script( 'magazine-plus-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix' . $min . '.js', array(), '20130115', true );

	wp_enqueue_script( 'magazine-plus-navigation', get_template_directory_uri() . '/js/navigation' . $min . '.js', array(), '20200527', true );

	wp_localize_script( 'magazine-plus-navigation', 'MagazinePlusScreenReaderText', array(
		'expand'   => '<span class="screen-reader-text">' . esc_html__( 'expand child menu', 'magazine-plus-pro' ) . '</span>',
		'collapse' => '<span class="screen-reader-text">' . esc_html__( 'collapse child menu', 'magazine-plus-pro' ) . '</span>',
	) );

	wp_enqueue_script( 'jquery-easytabs', get_template_directory_uri() . '/third-party/easytabs/js/jquery.easytabs' . $min . '.js', array( 'jquery' ), '3.2.0', true );

	wp_enqueue_script( 'jquery-cycle2', get_template_directory_uri() . '/third-party/cycle2/js/jquery.cycle2' . $min . '.js', array( 'jquery' ), '2.1.6', true );

	wp_enqueue_script( 'jquery-easy-ticker', get_template_directory_uri() . '/third-party/ticker/jquery.easy-ticker' . $min . '.js', array( 'jquery' ), '2.0', true );

	wp_enqueue_script( 'jquery-slick', get_template_directory_uri() . '/third-party/slick/slick' . $min . '.js', array( 'jquery' ), '1.6.0', true );

	wp_enqueue_script( 'magazine-plus-custom', get_template_directory_uri() . '/js/custom' . $min . '.js', array( 'jquery' ), '1.0.4', true );

	$custom_args = array(
		'go_to_top_status' => ( true === magazine_plus_get_option( 'go_to_top' ) ) ? 1 : 0,
	);
	wp_localize_script( 'magazine-plus-custom', 'magazinePlusCustomOptions', $custom_args );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'magazine_plus_scripts' );

/**
 * Enqueue admin scripts and styles.
 */
function magazine_plus_admin_scripts( $hook ) {

	$min = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

	if ( in_array( $hook, array( 'post.php', 'post-new.php' ) ) ) {
		wp_enqueue_style( 'magazine-plus-metabox', get_template_directory_uri() . '/css/metabox' . $min . '.css', '', '1.0.0' );
		wp_enqueue_script( 'magazine-plus-metabox', get_template_directory_uri() . '/js/metabox' . $min . '.js', array( 'jquery', 'jquery-ui-core', 'jquery-ui-tabs' ), '1.0.0', true );
	}

	if ( 'widgets.php' === $hook ) {
		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_script( 'wp-color-picker' );
		wp_enqueue_media();
		wp_enqueue_style( 'magazine-plus-custom-widgets-style', get_template_directory_uri() . '/css/widgets' . $min . '.css', array(), '1.0.0' );
		wp_enqueue_script( 'magazine-plus-custom-widgets', get_template_directory_uri() . '/js/widgets' . $min . '.js', array( 'jquery' ), '1.0.0', true );
	}

}
add_action( 'admin_enqueue_scripts', 'magazine_plus_admin_scripts' );

/**
 * Load init.
 */
require_once get_template_directory() . '/inc/init.php';

/**
 * Load theme updater functions.
 */
function magazine_plus_theme_updater() {
	if ( is_admin() ) {
		require_once get_template_directory() . '/updater/theme-updater.php';
	}
}

if ( ! function_exists( 'magazine_plus_blocks_support' ) ) :
	/**
	 * Create add default blocks support
	 */
	function magazine_plus_blocks_support() {
		// Add support for Block Styles.
		add_theme_support( 'wp-block-styles' );

		// Add support for full and wide align images.
		add_theme_support( 'align-wide' );

		// Add support for editor styles.
		add_theme_support( 'editor-styles' );

		// Add support for responsive embeds.
		add_theme_support( 'responsive-embeds' );

		// Add custom editor font sizes.
		add_theme_support(
			'editor-font-sizes',
			array(
				array(
					'name'      => esc_html__( 'Small', 'magazine-plus-pro' ),
					'shortName' => esc_html__( 'S', 'magazine-plus-pro' ),
					'size'      => 14,
					'slug'      => 'small',
				),
				array(
					'name'      => esc_html__( 'Normal', 'magazine-plus-pro' ),
					'shortName' => esc_html__( 'M', 'magazine-plus-pro' ),
					'size'      => 18,
					'slug'      => 'normal',
				),
				array(
					'name'      => esc_html__( 'Large', 'magazine-plus-pro' ),
					'shortName' => esc_html__( 'L', 'magazine-plus-pro' ),
					'size'      => 42,
					'slug'      => 'large',
				),
				array(
					'name'      => esc_html__( 'Huge', 'magazine-plus-pro' ),
					'shortName' => esc_html__( 'XL', 'magazine-plus-pro' ),
					'size'      => 54,
					'slug'      => 'huge',
				),
			)
		);

		// Add support for custom color scheme.
		add_theme_support( 'editor-color-palette', array(
			array(
				'name'  => esc_html__( 'White', 'magazine-plus-pro' ),
				'slug'  => 'white',
				'color' => '#ffffff',
			),
			array(
				'name'  => esc_html__( 'Black', 'magazine-plus-pro' ),
				'slug'  => 'black',
				'color' => '#111111',
			),
			array(
				'name'  => esc_html__( 'Gray', 'magazine-plus-pro' ),
				'slug'  => 'gray',
				'color' => '#f4f4f4',
			),
			array(
				'name'  => esc_html__( 'Blue', 'magazine-plus-pro' ),
				'slug'  => 'blue',
				'color' => '#1b8be0',
			),
			array(
				'name'  => esc_html__( 'Orange', 'magazine-plus-pro' ),
				'slug'  => 'orange',
				'color' => '#fa5742',
			),
		) );
	}
	add_action( 'after_setup_theme', 'magazine_plus_blocks_support', 20 );
endif; //magazine_plus_blocks_support

if ( ! function_exists( 'magazine_plus_add_blocks_style' ) ) :
	/**
	 * Add Blocks Style
	 */
	function magazine_plus_add_blocks_style() {
		// Theme block stylesheet.
		wp_enqueue_style( 'magazine-plus-block-style', get_theme_file_uri( '/css/blocks.css' ), array( 'magazine-plus-style' ), date( 'Ymd-Gis', filemtime( get_template_directory() . '/css/blocks.css' ) ) );
	}
	add_action( 'wp_enqueue_scripts', 'magazine_plus_add_blocks_style' );
endif; //magazine_plus_add_blocks_style

if ( ! function_exists( 'magazine_plus_block_editor_styles' ) ) :
	/**
	 * Enqueue editor styles for Blocks
	 */
	function magazine_plus_block_editor_styles() {
		// Block styles.
		wp_enqueue_style( 'magazine-plus-block-editor-style', get_theme_file_uri( '/css/editor-blocks.css' ), null, date( 'Ymd-Gis', filemtime( get_template_directory() . '/css/editor-blocks.css' ) ) );

		// Add custom fonts.
		wp_enqueue_style( 'magazine-plus-fonts', magazine_plus_fonts_url(), array(), null );
	}
	add_action( 'enqueue_block_editor_assets', 'magazine_plus_block_editor_styles' );
endif; //magazine_plus_block_editor_styles

add_action( 'after_setup_theme', 'magazine_plus_theme_updater' );
