<?php
/**
 * Callback functions for active_callback.
 *
 * @package Magazine_Plus
 */

if ( ! function_exists( 'magazine_plus_is_image_in_archive_active' ) ) :

	/**
	 * Check if image in archive is active.
	 *
	 * @since 1.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function magazine_plus_is_image_in_archive_active( $control ) {

		if ( 'disable' !== $control->manager->get_setting( 'theme_options[archive_image]' )->value() ) {
			return true;
		} else {
			return false;
		}

	}

endif;

if ( ! function_exists( 'magazine_plus_is_image_in_single_active' ) ) :

	/**
	 * Check if image in single is active.
	 *
	 * @since 1.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function magazine_plus_is_image_in_single_active( $control ) {

		if ( 'disable' !== $control->manager->get_setting( 'theme_options[single_image]' )->value() ) {
			return true;
		} else {
			return false;
		}

	}

endif;


if ( ! function_exists( 'magazine_plus_is_news_ticker_active' ) ) :

	/**
	 * Check if news ticker is active.
	 *
	 * @since 1.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function magazine_plus_is_news_ticker_active( $control ) {

		if ( $control->manager->get_setting( 'theme_options[show_ticker]' )->value() ) {
			return true;
		} else {
			return false;
		}

	}

endif;

if ( ! function_exists( 'magazine_plus_is_featured_carousel_active' ) ) :

	/**
	 * Check if featured carousel is active.
	 *
	 * @since 1.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function magazine_plus_is_featured_carousel_active( $control ) {

		if ( 'disabled' !== $control->manager->get_setting( 'theme_options[featured_carousel_status]' )->value() ) {
			return true;
		} else {
			return false;
		}

	}

endif;

if ( ! function_exists( 'magazine_plus_is_featured_category_carousel_active' ) ) :

	/**
	 * Check if featured category carousel is active.
	 *
	 * @since 1.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function magazine_plus_is_featured_category_carousel_active( $control ) {

		if ( 'featured-category' === $control->manager->get_setting( 'theme_options[featured_carousel_type]' )->value() && 'disabled' !== $control->manager->get_setting( 'theme_options[featured_carousel_status]' )->value() ) {
			return true;
		} else {
			return false;
		}

	}

endif;

if ( ! function_exists( 'magazine_plus_is_featured_tag_carousel_active' ) ) :

	/**
	 * Check if featured tag carousel is active.
	 *
	 * @since 1.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function magazine_plus_is_featured_tag_carousel_active( $control ) {

		if ( 'featured-tag' === $control->manager->get_setting( 'theme_options[featured_carousel_type]' )->value() && 'disabled' !== $control->manager->get_setting( 'theme_options[featured_carousel_status]' )->value() ) {
			return true;
		} else {
			return false;
		}

	}

endif;

if ( ! function_exists( 'magazine_plus_is_author_bio_active' ) ) :

	/**
	 * Check if author bio is active.
	 *
	 * @since 1.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function magazine_plus_is_author_bio_active( $control ) {

		if ( $control->manager->get_setting( 'theme_options[author_bio_in_single]' )->value() ) {
			return true;
		} else {
			return false;
		}

	}

endif;

if ( ! function_exists( 'magazine_plus_is_author_bio_recent_posts_active' ) ) :

	/**
	 * Check if author bio recent posts is active.
	 *
	 * @since 1.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function magazine_plus_is_author_bio_recent_posts_active( $control ) {

		if ( $control->manager->get_setting( 'theme_options[author_bio_in_single]' )->value() && $control->manager->get_setting( 'theme_options[author_bio_show_recent_posts]' )->value() ) {
			return true;
		} else {
			return false;
		}

	}

endif;

