<?php
/**
 * Default theme options.
 *
 * @package Magazine_Plus
 */

if ( ! function_exists( 'magazine_plus_get_default_theme_options' ) ) :

	/**
	 * Get default theme options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Default theme options.
	 */
	function magazine_plus_get_default_theme_options() {

		$defaults = array();

		// Header.
		$defaults['show_title']                 = true;
		$defaults['show_tagline']               = false;
		$defaults['show_date']                  = true;
		$defaults['show_ticker']                = true;
		$defaults['ticker_title']               = esc_html__( 'Latest News', 'magazine-plus-pro' );
		$defaults['ticker_category']            = 0;
		$defaults['ticker_number']              = 3;
		$defaults['show_social_in_header']      = false;
		$defaults['enable_sticky_primary_menu'] = false;

		// Layout.
		$defaults['site_design']             = 'magazine-plus';
		$defaults['site_layout']             = 'fluid';
		$defaults['global_layout']           = 'three-columns';
		$defaults['archive_layout']          = 'excerpt';
		$defaults['archive_image']           = 'medium';
		$defaults['archive_image_alignment'] = 'left';
		$defaults['single_image']            = 'large';
		$defaults['single_image_alignment']  = 'center';

		// Blog.
		$defaults['excerpt_length'] = 40;
		$defaults['read_more_text'] = esc_html__( 'Read more', 'magazine-plus-pro' );

		// Author Bio.
		$defaults['author_bio_in_single']           = true;
		$defaults['author_bio_show_recent_posts']   = false;
		$defaults['author_bio_recent_posts_number'] = 3;

		// Breadcrumb.
		$defaults['breadcrumb_type'] = 'simple';

		// Pagination.
		$defaults['pagination_type'] = 'numeric';
		
		// Load fonts from CDN
		$defaults['load_font_cdn']        = false;	

		// Content Meta.
		$defaults['show_meta_date']       = true;
		$defaults['show_meta_author']     = true;
		$defaults['show_meta_categories'] = true;
		$defaults['show_meta_tags']       = true;
		$defaults['show_meta_comment']    = true;

		// Footer.
		$defaults['copyright_text']       = esc_html__( 'Copyright &copy; [the-year] [the-site-link]. All rights reserved.', 'magazine-plus-pro' );
		$defaults['powered_by_text']      = esc_html__( 'Magazine Plus Pro by ', 'magazine-plus-pro' ) . '<a target="_blank" rel="designer" href="https://wenthemes.com/">WEN Themes</a>';
		$defaults['reset_footer_content'] = false;
		$defaults['go_to_top']            = true;

		// Font.
		$font_keys = magazine_plus_get_font_family_theme_settings_options();
		if ( ! empty( $font_keys ) ) {
			foreach ( $font_keys as $k => $v ) {
			  $defaults[ $k ]  = $v['default'];
			}
		}
		$defaults['reset_font_settings'] = false;

		// Carousel Options.
		$defaults['featured_carousel_status']           = 'disabled';
		$defaults['featured_carousel_type']             = 'featured-category';
		$defaults['featured_carousel_number']           = 5;
		$defaults['featured_carousel_category']         = 0;
		$defaults['featured_carousel_tag']              = 0;
		$defaults['featured_carousel_enable_autoplay']  = false;
		$defaults['featured_carousel_transition_delay'] = 3;

		// Color.
		$colors = magazine_plus_get_default_colors();
		if ( ! empty( $colors ) ) {
			foreach ( $colors as $key => $val ) {
				$defaults[ $key ] = $val;
			}
		}

		// Pass through filter.
		$defaults = apply_filters( 'magazine_plus_filter_default_theme_options', $defaults );
		return $defaults;
	}

endif;
