<?php
/**
 * Theme Options.
 *
 * @package Magazine_Plus
 */

$default = magazine_plus_get_default_theme_options();

// Add Panel.
$wp_customize->add_panel( 'theme_option_panel',
	array(
	'title'      => __( 'Theme Options', 'magazine-plus-pro' ),
	'priority'   => 100,
	'capability' => 'edit_theme_options',
	)
);

// Header Section.
$wp_customize->add_section( 'section_header',
	array(
	'title'      => __( 'Header Options', 'magazine-plus-pro' ),
	'priority'   => 100,
	'capability' => 'edit_theme_options',
	'panel'      => 'theme_option_panel',
	)
);

// Setting show_title.
$wp_customize->add_setting( 'theme_options[show_title]',
	array(
	'default'           => $default['show_title'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'magazine_plus_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[show_title]',
	array(
	'label'    => __( 'Show Site Title', 'magazine-plus-pro' ),
	'section'  => 'section_header',
	'type'     => 'checkbox',
	'priority' => 100,
	)
);

// Setting show_tagline.
$wp_customize->add_setting( 'theme_options[show_tagline]',
	array(
	'default'           => $default['show_tagline'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'magazine_plus_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[show_tagline]',
	array(
	'label'    => __( 'Show Tagline', 'magazine-plus-pro' ),
	'section'  => 'section_header',
	'type'     => 'checkbox',
	'priority' => 100,
	)
);

// Setting show_date.
$wp_customize->add_setting( 'theme_options[show_date]',
	array(
	'default'           => $default['show_date'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'magazine_plus_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[show_date]',
	array(
	'label'    => __( 'Show Date', 'magazine-plus-pro' ),
	'section'  => 'section_header',
	'type'     => 'checkbox',
	'priority' => 100,
	)
);

// Setting show_ticker.
$wp_customize->add_setting( 'theme_options[show_ticker]',
	array(
	'default'           => $default['show_ticker'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'magazine_plus_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[show_ticker]',
	array(
	'label'    => __( 'Show News Ticker', 'magazine-plus-pro' ),
	'section'  => 'section_header',
	'type'     => 'checkbox',
	'priority' => 100,
	)
);

// Setting ticker_title.
$wp_customize->add_setting( 'theme_options[ticker_title]',
	array(
		'default'           => $default['ticker_title'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control( 'theme_options[ticker_title]',
	array(
		'label'           => __( 'Ticker Title', 'magazine-plus-pro' ),
		'section'         => 'section_header',
		'type'            => 'text',
		'priority'        => 100,
		'active_callback' => 'magazine_plus_is_news_ticker_active',
	)
);

// Setting ticker_category.
$wp_customize->add_setting( 'theme_options[ticker_category]',
	array(
		'default'           => $default['ticker_category'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	new magazine_plus_Dropdown_Taxonomies_Control( $wp_customize, 'theme_options[ticker_category]',
		array(
			'label'           => __( 'Ticker Category', 'magazine-plus-pro' ),
			'section'         => 'section_header',
			'settings'        => 'theme_options[ticker_category]',
			'priority'        => 100,
			'active_callback' => 'magazine_plus_is_news_ticker_active',
		)
	)
);

// Setting ticker_number.
$wp_customize->add_setting( 'theme_options[ticker_number]',
	array(
		'default'           => $default['ticker_number'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'magazine_plus_sanitize_positive_integer',
	)
);
$wp_customize->add_control( 'theme_options[ticker_number]',
	array(
		'label'           => __( 'Number of Posts', 'magazine-plus-pro' ),
		'section'         => 'section_header',
		'type'            => 'number',
		'priority'        => 100,
		'active_callback' => 'magazine_plus_is_news_ticker_active',
		'input_attrs'     => array( 'min' => 1, 'max' => 20, 'style' => 'width: 55px;' ),
	)
);

// Setting show_social_in_header.
$wp_customize->add_setting( 'theme_options[show_social_in_header]',
	array(
	'default'           => $default['show_social_in_header'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'magazine_plus_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[show_social_in_header]',
	array(
	'label'    => __( 'Show Social Icons', 'magazine-plus-pro' ),
	'section'  => 'section_header',
	'type'     => 'checkbox',
	'priority' => 100,
	)
);

// Setting enable_sticky_primary_menu.
$wp_customize->add_setting( 'theme_options[enable_sticky_primary_menu]',
	array(
		'default'           => $default['enable_sticky_primary_menu'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'magazine_plus_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[enable_sticky_primary_menu]',
	array(
		'label'    => __( 'Make Primary Menu Sticky', 'magazine-plus-pro' ),
		'section'  => 'section_header',
		'type'     => 'checkbox',
		'priority' => 100,
	)
);

// Layout Section.
$wp_customize->add_section( 'section_layout',
	array(
	'title'      => __( 'Layout Options', 'magazine-plus-pro' ),
	'priority'   => 100,
	'capability' => 'edit_theme_options',
	'panel'      => 'theme_option_panel',
	)
);

// Setting site_desigh.
$wp_customize->add_setting(
	'theme_options[site_design]',
	array(
		'default'           => $default['site_design'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'magazine_plus_sanitize_select',
	)
);
$wp_customize->add_control(
	'theme_options[site_design]',
	array(
		'label'    => esc_html__( 'Site Design', 'magazine-plus-pro' ),
		'section'  => 'section_layout',
		'type'     => 'select',
		'choices'  => magazine_plus_get_site_design_options(),
		'priority' => 100,
	)
);

// Setting site_layout.
$wp_customize->add_setting( 'theme_options[site_layout]',
	array(
	'default'           => $default['site_layout'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'magazine_plus_sanitize_select',
	)
);
$wp_customize->add_control( 'theme_options[site_layout]',
	array(
	'label'    => __( 'Global Layout', 'magazine-plus-pro' ),
	'section'  => 'section_layout',
	'type'     => 'select',
	'choices'  => magazine_plus_get_site_layout_options(),
	'priority' => 100,
	)
);

// Setting global_layout.
$wp_customize->add_setting( 'theme_options[global_layout]',
	array(
	'default'           => $default['global_layout'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'magazine_plus_sanitize_select',
	)
);
$wp_customize->add_control( 'theme_options[global_layout]',
	array(
	'label'    => __( 'Global Layout', 'magazine-plus-pro' ),
	'section'  => 'section_layout',
	'type'     => 'select',
	'choices'  => magazine_plus_get_global_layout_options(),
	'priority' => 100,
	)
);

// Setting archive_layout.
$wp_customize->add_setting( 'theme_options[archive_layout]',
	array(
	'default'           => $default['archive_layout'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'magazine_plus_sanitize_select',
	)
);
$wp_customize->add_control( 'theme_options[archive_layout]',
	array(
	'label'    => __( 'Archive Layout', 'magazine-plus-pro' ),
	'section'  => 'section_layout',
	'type'     => 'select',
	'choices'  => magazine_plus_get_archive_layout_options(),
	'priority' => 100,
	)
);
// Setting archive_image.
$wp_customize->add_setting( 'theme_options[archive_image]',
	array(
	'default'           => $default['archive_image'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'magazine_plus_sanitize_select',
	)
);
$wp_customize->add_control( 'theme_options[archive_image]',
	array(
	'label'    => __( 'Image in Archive', 'magazine-plus-pro' ),
	'section'  => 'section_layout',
	'type'     => 'select',
	'choices'  => magazine_plus_get_image_sizes_options(),
	'priority' => 100,
	)
);
// Setting archive_image_alignment.
$wp_customize->add_setting( 'theme_options[archive_image_alignment]',
	array(
	'default'           => $default['archive_image_alignment'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'magazine_plus_sanitize_select',
	)
);
$wp_customize->add_control( 'theme_options[archive_image_alignment]',
	array(
	'label'           => __( 'Image Alignment in Archive', 'magazine-plus-pro' ),
	'section'         => 'section_layout',
	'type'            => 'select',
	'choices'         => magazine_plus_get_image_alignment_options(),
	'priority'        => 100,
	'active_callback' => 'magazine_plus_is_image_in_archive_active',
	)
);
// Setting single_image.
$wp_customize->add_setting( 'theme_options[single_image]',
	array(
	'default'           => $default['single_image'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'magazine_plus_sanitize_select',
	)
);
$wp_customize->add_control( 'theme_options[single_image]',
	array(
	'label'    => __( 'Image in Single Post/Page', 'magazine-plus-pro' ),
	'section'  => 'section_layout',
	'type'     => 'select',
	'choices'  => magazine_plus_get_image_sizes_options(),
	'priority' => 100,
	)
);
// Setting single_image_alignment.
$wp_customize->add_setting( 'theme_options[single_image_alignment]',
	array(
	'default'           => $default['single_image_alignment'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'magazine_plus_sanitize_select',
	)
);
$wp_customize->add_control( 'theme_options[single_image_alignment]',
	array(
	'label'           => __( 'Image Alignment in Single Post/Page', 'magazine-plus-pro' ),
	'section'         => 'section_layout',
	'type'            => 'select',
	'choices'         => magazine_plus_get_image_alignment_options(),
	'priority'        => 100,
	'active_callback' => 'magazine_plus_is_image_in_single_active',
	)
);

// Blog Section.
$wp_customize->add_section( 'section_blog',
	array(
	'title'      => __( 'Blog Options', 'magazine-plus-pro' ),
	'priority'   => 100,
	'capability' => 'edit_theme_options',
	'panel'      => 'theme_option_panel',
	)
);

// Setting excerpt_length.
$wp_customize->add_setting( 'theme_options[excerpt_length]',
	array(
	'default'           => $default['excerpt_length'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'magazine_plus_sanitize_positive_integer',
	)
);
$wp_customize->add_control( 'theme_options[excerpt_length]',
	array(
	'label'       => __( 'Excerpt Length', 'magazine-plus-pro' ),
	'description' => __( 'in words', 'magazine-plus-pro' ),
	'section'     => 'section_blog',
	'type'        => 'number',
	'priority'    => 100,
	'input_attrs' => array( 'min' => 1, 'max' => 200, 'style' => 'width: 55px;' ),
	)
);

// Setting read_more_text.
$wp_customize->add_setting( 'theme_options[read_more_text]',
	array(
	'default'           => $default['read_more_text'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control( 'theme_options[read_more_text]',
	array(
	'label'    => __( 'Read More Text', 'magazine-plus-pro' ),
	'section'  => 'section_blog',
	'type'     => 'text',
	'priority' => 100,
	)
);

// Author Bio Section.
$wp_customize->add_section( 'section_author_bio',
	array(
		'title'       => __( 'Author Bio Options', 'magazine-plus-pro' ),
		'description' => __( 'Author Box will be displayed in the single post article.', 'magazine-plus-pro' ),
		'priority'    => 100,
		'capability'  => 'edit_theme_options',
		'panel'       => 'theme_option_panel',
	)
);

// Setting author_bio_in_single.
$wp_customize->add_setting( 'theme_options[author_bio_in_single]',
	array(
		'default'           => $default['author_bio_in_single'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'magazine_plus_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[author_bio_in_single]',
	array(
		'label'    => __( 'Show Author Bio', 'magazine-plus-pro' ),
		'section'  => 'section_author_bio',
		'type'     => 'checkbox',
		'priority' => 100,
	)
);

// Setting author_bio_show_recent_posts.
$wp_customize->add_setting( 'theme_options[author_bio_show_recent_posts]',
	array(
		'default'           => $default['author_bio_show_recent_posts'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'magazine_plus_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[author_bio_show_recent_posts]',
	array(
		'label'    => __( 'Show Recent Posts by Author', 'magazine-plus-pro' ),
		'section'  => 'section_author_bio',
		'type'     => 'checkbox',
		'priority' => 100,
		'active_callback' => 'magazine_plus_is_author_bio_active',
	)
);

// Setting author_bio_recent_posts_number.
$wp_customize->add_setting( 'theme_options[author_bio_recent_posts_number]',
	array(
		'default'           => $default['author_bio_recent_posts_number'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'magazine_plus_sanitize_positive_integer',
	)
);
$wp_customize->add_control( 'theme_options[author_bio_recent_posts_number]',
	array(
		'label'           => __( 'No of Recent Posts', 'magazine-plus-pro' ),
		'section'         => 'section_author_bio',
		'type'            => 'number',
		'priority'        => 100,
		'active_callback' => 'magazine_plus_is_author_bio_recent_posts_active',
		'input_attrs'     => array( 'min' => 1, 'max' => 20, 'style' => 'width: 55px;' ),
	)
);

// Breadcrumb Section.
$wp_customize->add_section( 'section_breadcrumb',
	array(
	'title'      => __( 'Breadcrumb Options', 'magazine-plus-pro' ),
	'priority'   => 100,
	'capability' => 'edit_theme_options',
	'panel'      => 'theme_option_panel',
	)
);

// Setting breadcrumb_type.
$wp_customize->add_setting( 'theme_options[breadcrumb_type]',
	array(
	'default'           => $default['breadcrumb_type'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'magazine_plus_sanitize_select',
	)
);
$wp_customize->add_control( 'theme_options[breadcrumb_type]',
	array(
	'label'    => __( 'Breadcrumb Type', 'magazine-plus-pro' ),
	'section'  => 'section_breadcrumb',
	'type'     => 'select',
	'choices'  => magazine_plus_get_breadcrumb_type_options(),
	'priority' => 100,
	)
);

// Pagination Section.
$wp_customize->add_section( 'section_pagination',
	array(
	'title'      => __( 'Pagination Options', 'magazine-plus-pro' ),
	'priority'   => 100,
	'capability' => 'edit_theme_options',
	'panel'      => 'theme_option_panel',
	)
);

// Setting pagination_type.
$wp_customize->add_setting( 'theme_options[pagination_type]',
	array(
	'default'           => $default['pagination_type'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'magazine_plus_sanitize_select',
	)
);
$wp_customize->add_control( 'theme_options[pagination_type]',
	array(
	'label'       => __( 'Pagination Type', 'magazine-plus-pro' ),
	'description' => sprintf( __( 'Infinite Scroll: Requires %1$sJetPack - Infinite Scroll%2$s plugin', 'magazine-plus-pro' ), '<a href="https://wordpress.org/plugins/jetpack/" target="_blank">','</a>' ),
	'section'     => 'section_pagination',
	'type'        => 'select',
	'choices'     => magazine_plus_get_pagination_type_options(),
	'priority'    => 100,
	)
);

// Content Meta Section.
$wp_customize->add_section( 'section_content_meta',
	array(
	'title'      => __( 'Content Meta Options', 'magazine-plus-pro' ),
	'priority'   => 100,
	'capability' => 'edit_theme_options',
	'panel'      => 'theme_option_panel',
	)
);

// Setting show_meta_date.
$wp_customize->add_setting( 'theme_options[show_meta_date]',
	array(
	'default'           => $default['show_meta_date'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'magazine_plus_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[show_meta_date]',
	array(
		'label'           => __( 'Show Date', 'magazine-plus-pro' ),
		'section'         => 'section_content_meta',
		'type'            => 'checkbox',
		'priority'        => 100,
	)
);

// Setting show_meta_author.
$wp_customize->add_setting( 'theme_options[show_meta_author]',
	array(
	'default'           => $default['show_meta_author'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'magazine_plus_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[show_meta_author]',
	array(
		'label'           => __( 'Show Author', 'magazine-plus-pro' ),
		'section'         => 'section_content_meta',
		'type'            => 'checkbox',
		'priority'        => 100,
	)
);

// Setting show_meta_categories.
$wp_customize->add_setting( 'theme_options[show_meta_categories]',
	array(
	'default'           => $default['show_meta_categories'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'magazine_plus_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[show_meta_categories]',
	array(
		'label'           => __( 'Show Categories', 'magazine-plus-pro' ),
		'section'         => 'section_content_meta',
		'type'            => 'checkbox',
		'priority'        => 100,
	)
);

// Setting show_meta_tags.
$wp_customize->add_setting( 'theme_options[show_meta_tags]',
	array(
	'default'           => $default['show_meta_tags'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'magazine_plus_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[show_meta_tags]',
	array(
		'label'           => __( 'Show Tags', 'magazine-plus-pro' ),
		'section'         => 'section_content_meta',
		'type'            => 'checkbox',
		'priority'        => 100,
	)
);

// Setting show_meta_comment.
$wp_customize->add_setting( 'theme_options[show_meta_comment]',
	array(
	'default'           => $default['show_meta_comment'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'magazine_plus_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[show_meta_comment]',
	array(
		'label'           => __( 'Show Comment', 'magazine-plus-pro' ),
		'section'         => 'section_content_meta',
		'type'            => 'checkbox',
		'priority'        => 100,
	)
);

// Footer Section.
$wp_customize->add_section( 'section_footer',
	array(
	'title'      => __( 'Footer Options', 'magazine-plus-pro' ),
	'priority'   => 100,
	'capability' => 'edit_theme_options',
	'panel'      => 'theme_option_panel',
	)
);

// Setting copyright_text.
$wp_customize->add_setting( 'theme_options[copyright_text]',
	array(
	'default'           => $default['copyright_text'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
	'transport'         => 'postMessage',
	)
);
$wp_customize->add_control( 'theme_options[copyright_text]',
	array(
	'label'    => __( 'Copyright Text', 'magazine-plus-pro' ),
	'section'  => 'section_footer',
	'type'     => 'textarea',
	'priority' => 100,
	)
);

// Setting - powered_by_text.
$wp_customize->add_setting( 'theme_options[powered_by_text]',
	array(
		'default'           => $default['powered_by_text'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'magazine_plus_sanitize_textarea_content',
		'transport'         => 'postMessage',
	)
);
$wp_customize->add_control( 'theme_options[powered_by_text]',
	array(
		'label'    => esc_html__( 'Powered By Text', 'magazine-plus-pro' ),
		'section'  => 'section_footer',
		'type'     => 'textarea',
		'priority' => 100,
	)
);

// Setting reset_footer_content.
$wp_customize->add_setting( 'theme_options[reset_footer_content]',
	array(
		'default'           => $default['reset_footer_content'],
		'capability'        => 'edit_theme_options',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'magazine_plus_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[reset_footer_content]',
	array(
		'label'       => __( 'Reset Footer Content', 'magazine-plus-pro' ),
		'description' => __( 'Refresh the page after save to view full effects.', 'magazine-plus-pro' ),
		'section'     => 'section_footer',
		'type'        => 'checkbox',
		'priority'    => 100,
	)
);

// Setting go_to_top.
$wp_customize->add_setting( 'theme_options[go_to_top]',
	array(
		'default'           => $default['go_to_top'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'magazine_plus_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[go_to_top]',
	array(
		'label'    => __( 'Show Go To Top', 'magazine-plus-pro' ),
		'section'  => 'section_footer',
		'type'     => 'checkbox',
		'priority' => 100,
	)
);
