<?php
/**
 * Helper functions related to customizer and options.
 *
 * @package Magazine_Plus
 */

if ( ! function_exists( 'magazine_plus_get_global_layout_options' ) ) :

	/**
	 * Returns global layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function magazine_plus_get_global_layout_options() {

		$choices = array(
			'left-sidebar'            => esc_html__( 'Primary Sidebar - Content', 'magazine-plus-pro' ),
			'right-sidebar'           => esc_html__( 'Content - Primary Sidebar', 'magazine-plus-pro' ),
			'three-columns'           => esc_html__( 'Three Columns ( Secondary - Content - Primary )', 'magazine-plus-pro' ),
			'three-columns-pcs'       => esc_html__( 'Three Columns ( Primary - Content - Secondary )', 'magazine-plus-pro' ),
			'three-columns-cps'       => esc_html__( 'Three Columns ( Content - Primary - Secondary )', 'magazine-plus-pro' ),
			'three-columns-psc'       => esc_html__( 'Three Columns ( Primary - Secondary - Content )', 'magazine-plus-pro' ),
			'three-columns-pcs-equal' => esc_html__( 'Three Columns ( Equal Primary - Content - Secondary )', 'magazine-plus-pro' ),
			'three-columns-scp-equal' => esc_html__( 'Three Columns ( Equal Secondary - Content - Primary )', 'magazine-plus-pro' ),
			'no-sidebar'              => esc_html__( 'No Sidebar', 'magazine-plus-pro' ),
		);

		$output = apply_filters( 'magazine_plus_filter_layout_options', $choices );
		return $output;

	}

endif;

if ( ! function_exists( 'magazine_plus_get_site_design_options' ) ) :

	/**
	 * Returns site design options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function magazine_plus_get_site_design_options() {

		$choices = array(
			'moto-news' => esc_html__( 'Moto News', 'magazine-plus-pro' ),
			'magazine-plus' => esc_html__( 'Magazine Plus', 'magazine-plus-pro' ),
		);

		$output = apply_filters( 'magazine_plus_filter_site_design_options', $choices );

		if ( ! empty( $output ) ) {
			ksort( $output );
		}

		return $output;

	}

endif;

if ( ! function_exists( 'magazine_plus_get_site_layout_options' ) ) :

	/**
	 * Returns site layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function magazine_plus_get_site_layout_options() {

		$choices = array(
			'fluid' => esc_html__( 'Fluid', 'magazine-plus-pro' ),
			'boxed' => esc_html__( 'Boxed', 'magazine-plus-pro' ),
		);

		$output = apply_filters( 'magazine_plus_filter_site_layout_options', $choices );

		if ( ! empty( $output ) ) {
			ksort( $output );
		}

		return $output;

	}

endif;


if ( ! function_exists( 'magazine_plus_get_archive_layout_options' ) ) :

	/**
	 * Returns archive layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function magazine_plus_get_archive_layout_options() {

		$choices = array(
			'full'    => esc_html__( 'Full Post', 'magazine-plus-pro' ),
			'excerpt' => esc_html__( 'Post Excerpt', 'magazine-plus-pro' ),
		);
		$output = apply_filters( 'magazine_plus_filter_archive_layout_options', $choices );
		if ( ! empty( $output ) ) {
			ksort( $output );
		}
		return $output;

	}

endif;

if ( ! function_exists( 'magazine_plus_get_image_sizes_options' ) ) :

	/**
	 * Returns image sizes options.
	 *
	 * @since 1.0.0
	 *
	 * @param bool  $add_disable True for adding No Image option.
	 * @param array $allowed Allowed image size options.
	 * @return array Image size options.
	 */
	function magazine_plus_get_image_sizes_options( $add_disable = true, $allowed = array(), $show_dimension = true ) {

		global $_wp_additional_image_sizes;
		$get_intermediate_image_sizes = get_intermediate_image_sizes();
		$choices = array();
		if ( true === $add_disable ) {
			$choices['disable'] = esc_html__( 'No Image', 'magazine-plus-pro' );
		}
		$choices['thumbnail'] = esc_html__( 'Thumbnail', 'magazine-plus-pro' );
		$choices['medium']    = esc_html__( 'Medium', 'magazine-plus-pro' );
		$choices['large']     = esc_html__( 'Large', 'magazine-plus-pro' );
		$choices['full']      = esc_html__( 'Full (original)', 'magazine-plus-pro' );

		if ( true === $show_dimension ) {
			foreach ( array( 'thumbnail', 'medium', 'large' ) as $key => $_size ) {
				$choices[ $_size ] = $choices[ $_size ] . ' (' . get_option( $_size . '_size_w' ) . 'x' . get_option( $_size . '_size_h' ) . ')';
			}
		}

		if ( ! empty( $_wp_additional_image_sizes ) && is_array( $_wp_additional_image_sizes ) ) {
			foreach ( $_wp_additional_image_sizes as $key => $size ) {
				$choices[ $key ] = $key;
				if ( true === $show_dimension ){
					$choices[ $key ] .= ' ('. $size['width'] . 'x' . $size['height'] . ')';
				}
			}
		}

		if ( ! empty( $allowed ) ) {
			foreach ( $choices as $key => $value ) {
				if ( ! in_array( $key, $allowed ) ) {
					unset( $choices[ $key ] );
				}
			}
		}

		return $choices;

	}

endif;


if ( ! function_exists( 'magazine_plus_get_image_alignment_options' ) ) :

	/**
	 * Returns image options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function magazine_plus_get_image_alignment_options() {

		$choices = array(
			'none'   => _x( 'None', 'Alignment', 'magazine-plus-pro' ),
			'left'   => _x( 'Left', 'Alignment', 'magazine-plus-pro' ),
			'center' => _x( 'Center', 'Alignment', 'magazine-plus-pro' ),
			'right'  => _x( 'Right', 'Alignment', 'magazine-plus-pro' ),
		);
		return $choices;

	}

endif;

if ( ! function_exists( 'magazine_plus_get_numbers_dropdown_options' ) ) :

	/**
	 * Returns numbers dropdown options.
	 *
	 * @since 1.0.0
	 *
	 * @param int    $min    Min.
	 * @param int    $max    Max.
	 * @param string $prefix Prefix.
	 * @param string $suffix Suffix.
	 *
	 * @return array Options array.
	 */
	function magazine_plus_get_numbers_dropdown_options( $min = 1, $max = 4, $prefix = '', $suffix = '' ) {

		$output = array();

		if ( $min <= $max ) {
			for ( $i = $min; $i <= $max; $i++ ) {
				$string = $prefix . $i . $suffix;
				$output[ $i ] = $string;
			}
		}

		return $output;

	}

endif;

if ( ! function_exists( 'magazine_plus_get_featured_carousel_content_options' ) ) :

	/**
	 * Returns the featured carousel content options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function magazine_plus_get_featured_carousel_content_options() {

		$choices = array(
			'disabled'  => esc_html__( 'Disabled', 'magazine-plus-pro' ),
			'home-page' => esc_html__( 'Static Front Page Only', 'magazine-plus-pro' ),
		);

		$output = apply_filters( 'magazine_plus_filter_featured_carousel_content_options', $choices );

		return $output;

	}

endif;

if ( ! function_exists( 'magazine_plus_get_featured_carousel_type' ) ) :

	/**
	 * Returns the featured carousel type.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function magazine_plus_get_featured_carousel_type() {

		$choices = array(
			'featured-category' => __( 'Featured Category', 'magazine-plus-pro' ),
			'featured-tag'      => __( 'Featured Tag', 'magazine-plus-pro' ),
			'sticky-posts'      => __( 'Sticky Posts', 'magazine-plus-pro' ),
		);

		$output = apply_filters( 'magazine_plus_filter_featured_carousel_type', $choices );

		if ( ! empty( $output ) ) {
			ksort( $output );
		}

		return $output;

	}

endif;

if ( ! function_exists( 'magazine_plus_get_pagination_type_options' ) ) :

	/**
	 * Returns pagination type options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function magazine_plus_get_pagination_type_options() {

		$choices = array(
			'default'               => esc_html__( 'Default (Older / Newer Post)', 'magazine-plus-pro' ),
			'numeric'               => esc_html__( 'Numeric', 'magazine-plus-pro' ),
			'infinite-scroll'       => esc_html__( 'Infinite Scroll - Scroll', 'magazine-plus-pro' ),
			'infinite-scroll-click' => esc_html__( 'Infinite Scroll - Click', 'magazine-plus-pro' ),
		);
		return $choices;

	}

endif;

if ( ! function_exists( 'magazine_plus_get_breadcrumb_type_options' ) ) :

	/**
	 * Returns breadcrumb type options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function magazine_plus_get_breadcrumb_type_options() {

		$choices = array(
			'disabled' => esc_html__( 'Disabled', 'magazine-plus-pro' ),
			'simple'   => esc_html__( 'Simple', 'magazine-plus-pro' ),
		);
		return $choices;

	}

endif;


if( ! function_exists( 'magazine_plus_get_customizer_font_options' ) ) :

	/**
	 * Returns customizer font options.
	 *
	 * @since 1.0.0
	 */
	function magazine_plus_get_customizer_font_options() {

		$web_fonts = magazine_plus_get_web_fonts();
		$os_fonts  = magazine_plus_get_os_fonts();

		$web_fonts = array_merge( $web_fonts, $os_fonts );

		if ( ! empty( $web_fonts ) ) {
			ksort( $web_fonts );
		}

		$choices = array();

		if ( ! empty( $web_fonts ) ) {
			foreach ( $web_fonts as $k => $v ) {
				$choices[$k] = esc_html( $v['label'] );
			}
		}
		return $choices;

	}

endif;

if( ! function_exists( 'magazine_plus_get_web_fonts' ) ) :

	/**
	 * Returns web font options.
	 *
	 * @since 1.0.0
	 */
	function magazine_plus_get_web_fonts() {

		$choices = array(
			'philosopher' => array(
				'name'  => 'Philosopher',
				'label' => "'Philosopher', sans-serif",
				),
			'open-sans' => array(
				'name'  => 'Open Sans',
				'label' => "'Open Sans', sans-serif",
				),
			'pt-sans' => array(
				'name'  => 'PT Sans',
				'label' => "'PT Sans', sans-serif",
				),
			'merriweather-sans' => array(
				'name'  => 'Merriweather Sans',
				'label' => "'Merriweather Sans', sans-serif",
				),
			'roboto' => array(
				'name'  => 'Roboto',
				'label' => "'Roboto', sans-serif",
				),
			'arizonia' => array(
				'name'  => 'Arizonia',
				'label' => "'Arizonia', cursive",
				),
			'raleway' => array(
				'name'  => 'Raleway',
				'label' => "'Raleway', sans-serif",
				),
			'droid-sans' => array(
				'name'  => 'Droid Sans',
				'label' => "'Droid Sans', sans-serif",
				),
			'lato' => array(
				'name'  => 'Lato',
				'label' => "'Lato', sans-serif",
				),
			'dosis' => array(
				'name'  => 'Dosis',
				'label' => "'Dosis', sans-serif",
				),
			'slabo-27px' => array(
				'name'  => 'Slabo 27px',
				'label' => "'Slabo 27px', serif",
				),
			'oswald' => array(
				'name'  => 'Oswald',
				'label' => "'Oswald', sans-serif",
				),
			'pt-sans-narrow' => array(
				'name'  => 'PT Sans Narrow',
				'label' => "'PT Sans Narrow', sans-serif",
				),
			'josefin-slab' => array(
				'name'  => 'Josefin Slab',
				'label' => "'Josefin Slab', serif",
				),
			'alegreya' => array(
				'name'  => 'Alegreya',
				'label' => "'Alegreya', serif",
				),
			'exo' => array(
				'name'  => 'Exo',
				'label' => "'Exo', sans-serif",
				),
			'signika' => array(
				'name'  => 'Signika',
				'label' => "'Signika', sans-serif",
				),
			'lobster' => array(
				'name'  => 'Lobster',
				'label' => "'Lobster', cursive",
				),
			'indie-flower' => array(
				'name'  => 'Indie Flower',
				'label' => "'Indie Flower', cursive",
				),
			'shadows-into-light' => array(
				'name'  => 'Shadows Into Light',
				'label' => "'Shadows Into Light', cursive",
				),
			'kaushan-script' => array(
				'name'  => 'Kaushan Script',
				'label' => "'Kaushan Script', cursive",
				),
			'dancing-script' => array(
				'name'  => 'Dancing Script',
				'label' => "'Dancing Script', cursive",
				),
			'fredericka-the-great' => array(
				'name'  => 'Fredericka the Great',
				'label' => "'Fredericka the Great', cursive",
				),
			'covered-by-your-grace' => array(
				'name'  => 'Covered By Your Grace',
				'label' => "'Covered By Your Grace', cursive",
				),
			'rajdhani' => array(
				'name'  => 'Rajdhani',
				'label' => "'Rajdhani', sans-serif",
				),
			'source-sans-pro' => array(
				'name'  => 'Source Sans Pro',
				'label' => "'Source Sans Pro', sans-serif",
				),
			);
		$choices = apply_filters( 'magazine_plus_filter_web_fonts', $choices );

		if ( ! empty( $choices ) ) {
			ksort( $choices );
		}

		return $choices;

	}

endif;

if( ! function_exists( 'magazine_plus_get_os_fonts' ) ) :

	/**
	 * Returns OS font options.
	 *
	 * @since 1.0.0
	 */
	function magazine_plus_get_os_fonts() {

		$choices = array(
			'arial' => array(
				'name'  => 'Arial',
				'label' => "'Arial', sans-serif",
				),
			'georgia' => array(
				'name'  => 'Georgia',
				'label' => "'Georgia', serif",
				),
			'cambria' => array(
				'name'  => 'Cambria',
				'label' => "'Cambria', Georgia, serif",
				),
			'tahoma' => array(
				'name'  => 'Tahoma',
				'label' => "'Tahoma', Geneva, sans-serif",
				),
			'sans-serif' => array(
				'name'  => 'Sans Serif',
				'label' => "'Sans Serif', Arial",
				),
			'verdana' => array(
				'name'  => 'Verdana',
				'label' => "'Verdana', Geneva, sans-serif",
				),
			);
		$choices = apply_filters( 'magazine_plus_filter_os_fonts', $choices );

		if ( ! empty( $choices ) ) {
			ksort( $choices );
		}
		return $choices;

	}

endif;

if( ! function_exists( 'magazine_plus_get_font_family_from_key' ) ) :

	/**
	 * Return font family from font slug.
	 *
	 * @since 1.0.0
	 *
	 * @param string $key Font slug.
	 * @return string Font name.
	 */
	function magazine_plus_get_font_family_from_key( $key ) {

		$output = '';

		$web_fonts = magazine_plus_get_web_fonts();
		$os_fonts  = magazine_plus_get_os_fonts();

		$fonts = array_merge( $web_fonts, $os_fonts );

		if ( isset( $fonts[ $key ] ) ) {
			$output = $fonts[ $key ]['label'];
		}
		return $output;

	}

endif;

if( ! function_exists( 'magazine_plus_get_font_family_theme_settings_options' ) ) :

	/**
	 * Returns font family theme settings options.
	 *
	 * @since 1.0.0
	 */
	function magazine_plus_get_font_family_theme_settings_options() {

		$choices = array(
			'font_site_title' => array(
				'label'   => __( 'Site Title', 'magazine-plus-pro' ),
				'default' => 'source-sans-pro',
				),
			'font_site_tagline' => array(
				'label'   => __( 'Site Tagline', 'magazine-plus-pro' ),
				'default' => 'source-sans-pro',
				),
			'font_site_default' => array(
				'label'   => __( 'Default', 'magazine-plus-pro' ),
				'default' => 'source-sans-pro',
				),
			'font_content_title' => array(
				'label'   => __( 'Content Title', 'magazine-plus-pro' ),
				'default' => 'source-sans-pro',
				),
			'font_content_body' => array(
				'label'   => __( 'Content Body', 'magazine-plus-pro' ),
				'default' => 'source-sans-pro',
				),
			'font_heading_tags' => array(
				'label'   => __( 'Heading Tags', 'magazine-plus-pro' ),
				'default' => 'source-sans-pro',
				),
			'font_navigation' => array(
				'label'   => __( 'Navigation', 'magazine-plus-pro' ),
				'default' => 'rajdhani',
				),
			);

		return $choices;

	}

endif;

if ( ! function_exists( 'magazine_plus_get_color_panels_options' ) ) :

  /**
   * Returns color panels options.
   *
   * @since 1.0.0
   */
	function magazine_plus_get_color_panels_options() {

		$choices = array(
			'color_panel_main' => array(
				'label' => __( 'Color Options', 'magazine-plus-pro' ),
				),
			);
		return $choices;
	}

endif;

if ( ! function_exists( 'magazine_plus_get_color_sections_options' ) ) :

  /**
   * Returns color sections options.
   *
   * @since 1.0.0
   */
	function magazine_plus_get_color_sections_options() {

		$choices = array(
			'color_section_basic' => array(
				'label' => __( 'Basic Color Options', 'magazine-plus-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_top_header' => array(
				'label' => __( 'Top Header Color Options', 'magazine-plus-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_header' => array(
				'label' => __( 'Header Color Options', 'magazine-plus-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_primary_menu' => array(
				'label' => __( 'Primary Menu Color Options', 'magazine-plus-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_featured_carousel' => array(
				'label' => __( 'Featured Carousel Color Options', 'magazine-plus-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_featured_content' => array(
				'label' => __( 'Featured Content Color Options', 'magazine-plus-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_content' => array(
				'label' => __( 'Content Color Options', 'magazine-plus-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_sidebar' => array(
				'label' => __( 'Sidebar Color Options', 'magazine-plus-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_breadcrumb' => array(
				'label' => __( 'Breadcrumb Color Options', 'magazine-plus-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_goto_top' => array(
				'label' => __( 'Go To Top Color Options', 'magazine-plus-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_pagination' => array(
				'label' => __( 'Pagination Color Options', 'magazine-plus-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_footer_widgets' => array(
				'label' => __( 'Footer Widgets Color Options', 'magazine-plus-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_footer_area' => array(
				'label' => __( 'Footer Area Color Options', 'magazine-plus-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_home_widgets_area' => array(
				'label' => __( 'Home Widget Area Color Options', 'magazine-plus-pro' ),
				'panel' => 'color_panel_main',
				),


			);
		return $choices;
	}

endif;

if( ! function_exists( 'magazine_plus_get_color_theme_settings_options' ) ) :

  /**
   * Returns color theme settings options.
   *
   * @since 1.0.0
   */
  function magazine_plus_get_color_theme_settings_options() {

  	$choices = array(

		// Basic.
  		'color_basic_text' => array(
  			'label'   => __( 'Text Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_basic',
  			),
  		'color_basic_link' => array(
  			'label'   => __( 'Link Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_basic',
  			),
  		'color_basic_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_basic',
  			),
  		'color_basic_heading' => array(
  			'label'   => __( 'Heading Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_basic',
  			),
  		'color_basic_button_text' => array(
  			'label'   => __( 'Button Text Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_basic',
  			),
  		'color_basic_button_background' => array(
  			'label'   => __( 'Button Background Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_basic',
  			),
  		'color_basic_button_text_hover' => array(
  			'label'   => __( 'Button Text Hover Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_basic',
  			),
  		'color_basic_button_background_hover' => array(
  			'label'   => __( 'Button Background Hover Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_basic',
  			),

		// Top Header.
  		'color_top_header_background' => array(
  			'label'   => __( 'Background Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_top_header',
  			),

  		'color_top_header_link' => array(
  			'label'   => __( 'Link Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_top_header',
  		),
  		'color_top_header_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_top_header',
  		),
  		'color_top_header_text' => array(
  			'label'   => __( 'Text Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_top_header',
  		),
  		'color_top_header_date_background' => array(
  			'label'   => __( 'Date Background Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_top_header',
  		),
  		'color_top_header_date_text' => array(
  			'label'   => __( ' Date Text Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_top_header',
  		),


		// Header.
  		'color_header_background' => array(
  			'label'   => __( 'Background Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_header',
  			),
  		'color_header_title' => array(
  			'label'   => __( 'Site Title Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_header',
  			),
  		'color_header_title_hover' => array(
  			'label'   => __( 'Site Title Hover Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_header',
  			),
  		'color_header_tagline' => array(
  			'label'   => __( 'Site Tagline Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_header',
  			),

		// Primary Menu.
  		'color_primary_menu_backgorund' => array(
  			'label'   => __( 'Main Background Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_primary_menu',
  			),
  		'color_primary_menu_link' => array(
  			'label'   => __( 'Link Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_primary_menu',
  			),
  		'color_primary_menu_link_background_hover' => array(
  			'label'   => __( 'Link Background Hover Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_primary_menu',
  			),
  		'color_primary_menu_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_primary_menu',
  			),


		// Content.
  		'color_content_background' => array(
  			'label'   => __( 'Background Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_content',
  			),
  		'color_content_title' => array(
  			'label'   => __( 'Title Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_content',
  			),
  		'color_content_text' => array(
  			'label'   => __( 'Text Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_content',
  			),
  		'color_content_link' => array(
  			'label'   => __( 'Link Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_content',
  			),
  		'color_content_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_content',
  			),
  		'color_content_meta_link' => array(
  			'label'   => __( 'Meta Link Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_content',
  			),
  		'color_content_meta_link_hover' => array(
  			'label'   => __( 'Meta Link Hover Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_content',
  			),
  		'color_content_meta_icon' => array(
  			'label'   => __( 'Meta Icon Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_content',
  			),

		// Featured Carousel.

  		'color_featured_carousel_caption_text' => array(
  			'label'   => __( 'Caption Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_featured_carousel',
  			),
  		'color_featured_carousel_caption_link' => array(
  			'label'   => __( 'Link Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_featured_carousel',
  			),
  		'color_featured_carousel_caption_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_featured_carousel',
  			),
  		'color_featured_carousel_caption_category_text' => array(
  			'label'   => __( 'Category Text Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_featured_carousel',
  			),
  		'color_featured_carousel_caption_category_background' => array(
  			'label'   => __( 'Category Background Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_featured_carousel',
  			),
  		'color_featured_carousel_caption_category_background_alt' => array(
  			'label'   => __( 'Category Alt Background Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_featured_carousel',
  			),


  		'color_featured_carousel_icon' => array(
  			'label'   => __( 'Icon Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_featured_carousel',
  			),
  		'color_featured_carousel_icon_hover' => array(
  			'label'   => __( 'Icon Hover Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_featured_carousel',
  			),



		// Home Page Widgets area.



  		'color_home_widgets_area_title' => array(
  			'label'   => __( 'Title Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_home_widgets_area',
		),
		'color_home_widgets_area_title_background' => array(
  			'label'   => __( 'Title Background Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_home_widgets_area',
		),
		'color_home_widgets_area_title_border' => array(
  			'label'   => __( 'Title border Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_home_widgets_area',
		),
  		'color_home_widgets_area_text' => array(
  			'label'   => __( 'Text Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_home_widgets_area',
		),
  		'color_home_widgets_area_link' => array(
  			'label'   => __( 'Link Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_home_widgets_area',
		),
  		'color_home_widgets_area_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_home_widgets_area',
		),



		// Sidebar.

  		'color_sidebar_title' => array(
  			'label'   => __( 'Title Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_sidebar',
		),
		'color_sidebar_title_background' => array(
  			'label'   => __( 'Title Background Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_sidebar',
		),
		'color_sidebar_title_border' => array(
  			'label'   => __( 'Title border Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_sidebar',
		),
  		'color_sidebar_text' => array(
  			'label'   => __( 'Text Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_sidebar',
		),
  		'color_sidebar_link' => array(
  			'label'   => __( 'Link Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_sidebar',
		),
  		'color_sidebar_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_sidebar',
		),
  		'color_sidebar_list_icon' => array(
  			'label'   => __( 'List Icon Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_sidebar',
		),

		// Footer area.
  		'color_footer_area_background' => array(
  			'label'   => __( 'Background Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_footer_area',
  			),
  		'color_footer_area_text' => array(
  			'label'   => __( 'Text Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_footer_area',
  			),
  		'color_footer_area_link' => array(
  			'label'   => __( 'Link Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_footer_area',
  			),
  		'color_footer_area_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_footer_area',
  			),

		// Go To Top.
  		'color_goto_top_icon' => array(
  			'label'   => __( 'Icon Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_goto_top',
  			),
  		'color_goto_top_icon_hover' => array(
  			'label'   => __( 'Icon Hover Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_goto_top',
  			),
  		'color_goto_top_background' => array(
  			'label'   => __( 'Background Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_goto_top',
  			),
  		'color_goto_top_background_hover' => array(
  			'label'   => __( 'Background Hover Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_goto_top',
  			),

		// Pagination.
  		'color_pagination_link' => array(
  			'label'   => __( 'Link Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_pagination',
  			),
  		'color_pagination_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_pagination',
  			),
  		'color_pagination_link_background' => array(
  			'label'   => __( 'Link Background Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_pagination',
  			),
  		'color_pagination_link_background_hover' => array(
  			'label'   => __( 'Link Background Hover Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_pagination',
  			),



		// Breadcrumb.

  		'color_breadcrumb_link' => array(
  			'label'   => __( 'Link Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_breadcrumb',
  			),
  		'color_breadcrumb_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_breadcrumb',
  			),
  		'color_breadcrumb_text' => array(
  			'label'   => __( 'Text Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_breadcrumb',
  			),


		// Footer widgets.
  		'color_footer_widgets_background' => array(
  			'label'   => __( 'Background Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_footer_widgets',
  			),
  		'color_footer_widgets_title' => array(
  			'label'   => __( 'Title Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_footer_widgets',
  			),
  		'color_footer_widgets_title_border' => array(
  			'label'   => __( 'Title Border Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_footer_widgets',
  			),
  		'color_footer_widgets_text' => array(
  			'label'   => __( 'Text Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_footer_widgets',
  			),
  		'color_footer_widgets_link' => array(
  			'label'   => __( 'Link Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_footer_widgets',
  			),
  		'color_footer_widgets_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'magazine-plus-pro' ),
  			'section' => 'color_section_footer_widgets',
  			),


  		);

    return $choices;

  }

endif;

if( ! function_exists( 'magazine_plus_get_default_colors' ) ) :

  /**
   * Returns default colors.
   *
   * @since 1.0.0
   *
   * @param string $scheme Color scheme.
   * @return array Color values based on scheme.
   */
	function magazine_plus_get_default_colors( $scheme = 'default' ){

		$output = array();

		switch ( $scheme ) {

			case 'default':
			default:
			$output = array(
				// Basic.
				'color_basic_text'                    => '#404040',
				'color_basic_link'                    => '#fa5742',
				'color_basic_link_hover'              => '#fa5742',
				'color_basic_heading'                 => '#242424',
				'color_basic_button_background'       => '#fa5742	',
				'color_basic_button_text'             => '#ffffff',
				'color_basic_button_background_hover' => '#242424',
				'color_basic_button_text_hover'       => '#ffffff',

				// Top Header.
				'color_top_header_background'                     => '#232323',
				'color_top_header_link'                       	  => '#d7d7d7',
				'color_top_header_link_hover'                     => '#ffffff',
				'color_top_header_text'                       	  => '#d7d7d7',
				'color_top_header_date_background'                => '#fa5742',
				'color_top_header_date_text'                      => '#ffffff',

				// Header.
				'color_header_background'                     => '#ffffff',
				'color_header_title'                          => '#232323',
				'color_header_title_hover'                    => '#232323',
				'color_header_tagline'                        => '#666666',

				// Primary Menu.
				'color_primary_menu_backgorund'             => '#232323',
				'color_primary_menu_link'               	=> '#d7d7d7',
				'color_primary_menu_link_hover'          	=> '#ffffff',
				'color_primary_menu_link_background_hover'  => '#fa5742',


				// featured-carousel

				'color_featured_carousel_caption_text'           						=> '#ffffff',
				'color_featured_carousel_caption_link'           					    => '#ffffff',
				'color_featured_carousel_caption_link_hover'      						=> '#ffffff',
				'color_featured_carousel_caption_category_text'                   		=> '#ffffff',
				'color_featured_carousel_caption_category_background'                   => '#ffffff',
				'color_featured_carousel_caption_category_background_alt'               => '#fa5742',
				'color_featured_carousel_icon'                    						=> '#ffffff',
				'color_featured_carousel_icon_hover'              						=> '#fa5742',



				// Content.
				'color_content_background'     			=> '#ffffff',
				'color_content_title'           		=> '#242424',
				'color_content_text'            		=> '#404040',
				'color_content_link'            		=> '#fa5742',
				'color_content_link_hover'      		=> '#fa5742',
				'color_content_meta_link'       		=> '#404040',
				'color_content_meta_link_hover' 		=> '#fa5742',
				'color_content_meta_icon'       		=> '#404040',

				// Sidebar.
				'color_sidebar_title'     			   => '#242424',
				'color_sidebar_title_background'       => '#fa5742',
				'color_sidebar_title_border'           => '#242424',
				'color_sidebar_text'      			   => '#404040',
				'color_sidebar_link'      	 		   => '#242424',
				'color_sidebar_link_hover' 			   => '#fa5742',
				'color_sidebar_list_icon' 			   => '#fa5742',

				// Home Page Widgets area.

				'color_home_widgets_area_title'     			   => '#242424',
				'color_home_widgets_area_title_background'         => '#fa5742',
				'color_home_widgets_area_title_border'             => '#242424',
				'color_home_widgets_area_text'      			   => '#242424',
				'color_home_widgets_area_link'      	 		   => '#fa5742',
				'color_home_widgets_area_link_hover' 			   => '#fa5742',



				// Footer Widgets
				'color_footer_widgets_background'      				=> '#bbbbbb',
				'color_footer_widgets_title'      					=> '#bbbbbb',
				'color_footer_widgets_title_border'      			=> '#bbbbbb',
				'color_footer_widgets_text'      					=> '#bbbbbb',
				'color_footer_widgets_link'      					=> '#bbbbbb',
				'color_footer_widgets_link_hover' 			    	=> '#bbbbbb',

				// Footer area.
				'color_footer_area_background' => '#171717',
				'color_footer_area_text'       => '#bbbbbb',
				'color_footer_area_link'       => '#ffffff',
				'color_footer_area_link_hover' => '#fa5742',

				// Go To Top.
				'color_goto_top_icon'             => '#ffffff',
				'color_goto_top_icon_hover'       => '#ffffff',
				'color_goto_top_background'       => '#242424',
				'color_goto_top_background_hover' => '#fa5742',

				// Pagination.
				'color_pagination_link'                  => '#fa5742',
				'color_pagination_link_hover'            => '#fff',
				'color_pagination_link_background'       => '#ffffff',
				'color_pagination_link_background_hover' => '#fa5742',

				// Breadcrumb.
				'color_breadcrumb_link'       => '#242424',
				'color_breadcrumb_link_hover' => '#fa5742',
				'color_breadcrumb_text'       => '#fa5742',



			);
			break;

		} // End switch.

	return $output;

	}

endif;
