<?php
/**
 * CSS related hooks.
 *
 * This file contains hook functions which are related to CSS.
 *
 * @package Magazine_Plus
 */

if ( ! function_exists( 'magazine_plus_trigger_custom_css_action' ) ) :

	/**
	 * Do action theme custom CSS.
	 *
	 * @since 1.0.0
	 */
	function magazine_plus_trigger_custom_css_action() {

		/**
		 * Hook - magazine_plus_action_theme_custom_css.
		 *
		 * @hooked magazine_plus_add_theme_custom_font_css - 10
		 */
		do_action( 'magazine_plus_action_theme_custom_css' );

	}

endif;

add_action( 'wp_head', 'magazine_plus_trigger_custom_css_action', 99 );

if ( ! function_exists( 'magazine_plus_add_theme_custom_font_css' ) ) :

	/**
	 * Inject theme custom font CSS.
	 *
	 * @since 1.0.0
	 */
	function magazine_plus_add_theme_custom_font_css() {

		$custom_css = '';

		$font_settings = magazine_plus_get_font_family_theme_settings_options();

		$required_fonts = array();

		if ( ! empty( $font_settings ) ) {
			foreach ( $font_settings as $key => $val ) {
				$option_value = magazine_plus_get_option( $key );
				if ( ! empty( $option_value ) && $val['default'] !== $option_value ) {
					$required_fonts[ $key ] = $option_value;
				}
			}
		}

		if ( empty( $required_fonts ) ) {
			// We do not need extra CSS.
			return;
		}

		foreach ( $required_fonts as $key => $font ) {

			$family = magazine_plus_get_font_family_from_key( $font );

			if ( ! empty( $family ) ) {

				switch ( $key ) {
					case 'font_site_default':
						$custom_css .= 'body{font-family:' . $family . '}' . "\n";
					break;

					case 'font_site_title':
						$custom_css .= '.site-title{font-family:' . $family . '}' . "\n";
					break;

					case 'font_site_tagline':
						$custom_css .= '.site-description{font-family:' . $family . '}' . "\n";
					break;

					case 'font_heading_tags':
						$custom_css .= 'h1,h2,h3,h4,h5,h6{font-family:' . $family . '}' . "\n";
					break;

					case 'font_content_title':
						$custom_css .= '.entry-header .entry-title{font-family:' . $family . '}' . "\n";
					break;

					case 'font_content_body':
						$custom_css .= '#content{font-family:' . $family . '}' . "\n";
					break;

					case 'font_navigation':
						$custom_css .= '#site-navigation ul li a{font-family:' . $family . '}' . "\n";
					break;

					default:
					break;
				}
			}
		}

		// Render style.
		if ( ! empty( $custom_css ) ) {
			echo '<style type="text/css">';
			echo wp_strip_all_tags( $custom_css );
			echo '</style>';
		}

	}

endif;

add_action( 'magazine_plus_action_theme_custom_css', 'magazine_plus_add_theme_custom_font_css' );

if ( ! function_exists( 'magazine_plus_add_theme_custom_color_css' ) ) :

	/**
	 * Inject theme custom color CSS.
	 *
	 * @since 1.0.0
	 */
	function magazine_plus_add_theme_custom_color_css() {

		$custom_css = '';

		$color_settings = magazine_plus_get_color_theme_settings_options();

		$default = magazine_plus_get_default_colors();

		$required_colors = array();

		if ( ! empty( $color_settings ) ) {
		  foreach ($color_settings as $key => $val ) {
		    $option_value = magazine_plus_get_option( $key );
		    if ( ! empty( $option_value ) && $default[$key] != $option_value ) {
		      $required_colors[ $key ] = $option_value;
		    }
		  }
		}
		if ( empty( $required_colors ) ) {
		  // We do not need extra CSS.
		  return;
		}

		foreach ( $required_colors as $key => $color ) {

			switch ( $key ) {

				// Basic.
				case 'color_basic_text':
				  $custom_css .= 'body{color:' . $color . '}' . "\n";
				  break;
				case 'color_basic_link':
				  $custom_css .= 'a,a:visited{color:' . $color . '}' . "\n";
				  $custom_css .= '#mobile-trigger i,.meta-nav,.magazine_plus_widget_news_slider .pager-box{background-color:' . $color . '}' . "\n";
		
				  break;
				case 'color_basic_link_hover':
				  $custom_css .= 'a:hover{color:' . $color . '}' . "\n";
				    $custom_css .= '.magazine_plus_widget_news_slider .pager-box.cycle-pager-active{background-color:' . $color . '}' . "\n";
				  
				  break;
				case 'color_basic_heading':
				  $custom_css .= 'h1,h2,h3,h4,h5,h6{color:' . $color . '}' . "\n";
				  break;

				case 'color_basic_button_text':
				$custom_css .= '#infinite-handle span,.search-box > a,a.button,.search-form .search-submit,.nav-links a,a.cta-button-primary,button, input[type="button"], input[type="reset"], input[type="submit"],#infinite-handle span button, #infinite-handle span button,.magazine_plus_widget_news_slider .cycle-prev, .magazine_plus_widget_news_slider .cycle-next{color:' . $color . '}' . "\n";
				$custom_css .= '.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button{color:' . $color . '}' . "\n";
				 break;
				case 'color_basic_button_text_hover':
				  $custom_css .= '.magazine_plus_widget_news_slider .cycle-prev, .magazine_plus_widget_news_slider .cycle-next,#infinite-handle span:hover.search-box > a:hover,a.button:hover,.search-form .search-submit:hover,a.cta-button-primary:hover,.nav-links a:hover,button:hover, input[type="button"]:hover, input[type="reset"]:hover, input[type="submit"]:hover, #infinite-handle span button:hover{color:' . $color . '}' . "\n";
				  $custom_css .= '.woocommerce #respond input#submit.alt:hover,.woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button.woocommerce:hover #respond input#submit.alt.disabled, .woocommerce #respond input#submit.alt.disabled:hover, .woocommerce #respond input#submit.alt:disabled, .woocommerce #respond input#submit.alt:disabled:hover, .woocommerce #respond input#submit.alt[disabled]:disabled, .woocommerce #respond input#submit.alt[disabled]:disabled:hover, .woocommerce a.button.alt.disabled, .woocommerce a.button.alt.disabled:hover, .woocommerce a.button.alt:disabled, .woocommerce a.button.alt:disabled:hover, .woocommerce a.button.alt[disabled]:disabled, .woocommerce a.button.alt[disabled]:disabled:hover, .woocommerce button.button.alt.disabled, .woocommerce button.button.alt.disabled:hover, .woocommerce button.button.alt:disabled, .woocommerce button.button.alt:disabled:hover, .woocommerce button.button.alt[disabled]:disabled, .woocommerce button.button.alt[disabled]:disabled:hover, .woocommerce input.button.alt.disabled, .woocommerce input.button.alt.disabled:hover, .woocommerce input.button.alt:disabled, .woocommerce input.button.alt:disabled:hover, .woocommerce input.button.alt[disabled]:disabled, .woocommerce input.button.alt[disabled]:disabled:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_basic_button_background':
				  $custom_css .= '.magazine_plus_widget_news_slider .cycle-prev, .magazine_plus_widget_news_slider .cycle-next,#infinite-handle span,.search-box > a,a.button,a.links-btn::after,.search-form .search-submit,.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button{background-color:' . $color . '}' . "\n";
				  $custom_css .= 'a.cta-button-primary,button, input[type="button"], input[type="reset"], input[type="submit"],#infinite-handle span button{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_basic_button_background_hover':
				  $custom_css .= '.magazine_plus_widget_news_slider .cycle-prev, .magazine_plus_widget_news_slider .cycle-next,#infinite-handle span:hover,.search-box > a:hover,a.button:hover,a.links-btn:hover::after,.search-form .search-submit:hover,a.cta-button-primary:hover,.nav-links a:hover,button:hover, input[type="button"]:hover, input[type="reset"]:hover, input[type="submit"]:hover,#infinite-handle span button{background-color:' . $color . '}' . "\n";
				  $custom_css .= '.woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button.woocommerce:hover #respond input#submit.alt.disabled, .woocommerce #respond input#submit.alt.disabled:hover, .woocommerce #respond input#submit.alt:disabled, .woocommerce #respond input#submit.alt:disabled:hover, .woocommerce #respond input#submit.alt[disabled]:disabled, .woocommerce #respond input#submit.alt[disabled]:disabled:hover, .woocommerce a.button.alt.disabled, .woocommerce a.button.alt.disabled:hover, .woocommerce a.button.alt:disabled, .woocommerce a.button.alt:disabled:hover, .woocommerce a.button.alt[disabled]:disabled, .woocommerce a.button.alt[disabled]:disabled:hover, .woocommerce button.button.alt.disabled, .woocommerce button.button.alt.disabled:hover, .woocommerce button.button.alt:disabled, .woocommerce button.button.alt:disabled:hover, .woocommerce button.button.alt[disabled]:disabled, .woocommerce button.button.alt[disabled]:disabled:hover, .woocommerce input.button.alt.disabled, .woocommerce input.button.alt.disabled:hover, .woocommerce input.button.alt:disabled, .woocommerce input.button.alt:disabled:hover, .woocommerce input.button.alt[disabled]:disabled, .woocommerce input.button.alt[disabled]:disabled:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover{background-color:' . $color . '}' . "\n";
				  break;

				// Top Header.
				case 'color_top_header_background':
				  $custom_css .= '#tophead,#top-nav ul ul{background-color:' . $color . '}' . "\n";
				  break;

				case 'color_top_header_link':
				  $custom_css .= '#tophead a,#top-nav ul li a,#top-nav ul li a::before,.header-social .magazine_plus_widget_social ul li a::before{color:' . $color . '}' . "\n";
				  break;
				case 'color_top_header_link_hover':
				  $custom_css .= '#tophead a:hover,#top-nav ul li a:hover,#top-nav ul ul li a:hover{color:' . $color . '}' . "\n";
				  break;

				case 'color_top_header_text':
				  $custom_css .= '#tophead , #tophead p,.top-news-title{color:' . $color . '}' . "\n";
				  break;
				case 'color_top_header_date_background':
				  $custom_css .= '#tophead .head-date,#top-nav ul ul li a:hover{background-color:' . $color . '}' . "\n";
				  break;

				case 'color_top_header_date_text':
				  $custom_css .= '#tophead .head-date{color:' . $color . '}' . "\n";
				  break;

				// Header.
				case 'color_header_background':
				  $custom_css .= '#masthead {background-color:' . $color . '}' . "\n";
				  break;
				case 'color_header_title':
				  $custom_css .= '#site-identity .site-title > a{color:' . $color . '}' . "\n";
		        break;
				case 'color_header_title_hover':
				  $custom_css .= '#site-identity .site-title > a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_header_tagline':
				  $custom_css .= '.site-description{color:' . $color . '}' . "\n";
				  break;

		      // Primary Menu.
				case 'color_primary_menu_backgorund':
				  $custom_css .= '#main-nav .main-nav-wrapper,#main-nav .main-nav-wrapper ul ul{background-color:' . $color . '}' . "\n";
				  $custom_css .= '.header-search-box .search-box-wrap{brder-top-color:' . $color . '}' . "\n";

				  $custom_css .= '.header-search-box .search-box-wrap::before{brder-bottom-color:' . $color . '}' . "\n";
				  break;

				case 'color_primary_menu_link':
				  $custom_css .= '#main-nav ul li a,.header-search-box a{color:' . $color . '}' . "\n";
				  break;

				case 'color_primary_menu_link_hover':
				  $custom_css .= '#main-nav ul li a:hover,#main-nav li.current-menu-item > a,
				  #main-nav li.current_page_item > a,#main-nav ul li:hover > a,.header-search-box a:hover{color:' . $color . '}' . "\n";
				  break;

				case 'color_primary_menu_link_background_hover':
				    $custom_css .= '.main-navigation li a:hover, .main-navigation li.current-menu-item a, .main-navigation li.current_page_item a, .main-navigation li:hover > a,#main-nav ul ul,.main-navigation li.home-menu.current-menu-item a::before,.header-search-box a:hover{background-color:' . $color . '}' . "\n";
					break;


				// Featured Carousel
				case 'color_featured_carousel_caption_text':
				  $custom_css .= '#featured-carousel p,#featured-carousel{color:' . $color . '}' . "\n";
				  break;
				case 'color_featured_carousel_caption_link':
				  $custom_css .= '#featured-carousel  .featured-carousel-item-title a,#featured-carousel a a{color:' . $color . '}' . "\n";
				  break;
				case 'color_featured_carousel_caption_link_hover':
				  $custom_css .= '#featured-carousel  .featured-carousel-item-title a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_featured_carousel_caption_category_text':
				  $custom_css .= '#featured-carousel p,#featured-carousel .featured-carousel-item-meta span.date::before,#featured-carousel .featured-carousel-item-meta span{color:' . $color . '}' . "\n";
				  break;
				case 'color_featured_carousel_caption_category_background':
				  $custom_css .= '#featured-carousel .featured-carousel-item:nth-child(2n) span.categories{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_featured_carousel_caption_category_background_alt':
				  $custom_css .= '#featured-carousel .featured-carousel-item:nth-child(2n+1) span.categories{background-color:' . $color . '}' . "\n";
				  break;  
				case 'color_featured_carousel_icon':
				  $custom_css .= '#featured-carousel .slick-prev.slick-arrow, #featured-carousel .slick-next.slick-arrow{color:' . $color . '}' . "\n";
				  break;
				case 'color_featured_carousel_icon_hover':
				  $custom_css .= '#featured-carousel .slick-prev.slick-arrow:hover, #featured-carousel .slick-next.slick-arrow:hover{color:' . $color . '}' . "\n";
				  break;
			


				// Content.
				case 'color_content_background':
				  $custom_css .= '#content{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_content_title':
				  $custom_css .= '#primary .entry-title{color:' . $color . '}' . "\n";
				  break;
				case 'color_content_text':
				  $custom_css .= '#primary {color:' . $color . '}' . "\n";
				  break;
				case 'color_content_link':
				  $custom_css .= '#primary article a{color:' . $color . '}' . "\n";
				  break;
				case 'color_content_link_hover':
				  $custom_css .= '#primary article a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_content_meta_link':
				  $custom_css .= '#primary .entry-meta > span a,#primary .entry-footer > span a{color:' . $color . '}' . "\n";
				  break;
				case 'color_content_meta_link_hover':
				  $custom_css .= '#primary .entry-meta > span a:hover,#primary  .entry-footer > span a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_content_meta_icon':
				  $custom_css .= '#primary .entry-meta > span::before,#primary  .entry-footer > span::before{color:' . $color . '}' . "\n";
				  break;

				// Sidebar.

				case 'color_sidebar_title':
				  $custom_css .= '.sidebar .widget-title span,.sidebar .magazine_plus_widget_tabbed .tabbed-container .etabs li.active a,.sidebar .magazine_plus_widget_tabbed .tabbed-container .etabs li a{color:' . $color . '}' . "\n";
				  break;
				case 'color_sidebar_title_background':
				  $custom_css .= '.sidebar .widget-title span,.sidebar .magazine_plus_widget_tabbed .tabbed-container .etabs li.active a,.sidebar .magazine_plus_widget_tabbed .tabbed-container .etabs li a:hover{background-color:' . $color . '}' . "\n";
				  $custom_css .= '.sidebar .widget-title:after{background-color:' . $color . '}' . "\n";

				  break;
				case 'color_sidebar_title_border':
				  $custom_css .= '.sidebar .widget-title{border-color:' . $color . '}' . "\n";
				  break;  
				case 'color_sidebar_text':
				  $custom_css .= '.sidebar,.sidebar p ,.sidebar span{color:' . $color . '}' . "\n";
				  break;
				case 'color_sidebar_link':
				  $custom_css .= '.sidebar .widget a,.sidebar .widget li{color:' . $color . '}' . "\n";
				  break;
				case 'color_sidebar_link_hover':
				  $custom_css .= '.sidebar .widget a:hover,.sidebar .widget li:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_sidebar_list_icon':
				  $custom_css .= '.sidebar ul li::before{color:' . $color . '}' . "\n";
				  break;

				// Footer area.
				case 'color_footer_area_background':
				  $custom_css .= '#colophon{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_area_text':
				  $custom_css .= '#colophon{color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_area_link':
				  $custom_css .= '#colophon a{color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_area_link_hover':
				  $custom_css .= '#colophon a:hover{color:' . $color . '}' . "\n";
				  break;

				// Go To Top.
			    case 'color_goto_top_icon':
				  $custom_css .= '#btn-scrollup i.fa{color:' . $color . '}' . "\n";
				  break;
				case 'color_goto_top_icon_hover':
				  $custom_css .= '#btn-scrollup i.fa:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_goto_top_background':
				  $custom_css .= '#btn-scrollup{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_goto_top_background_hover':
				  $custom_css .= '#btn-scrollup:hover{background-color:' . $color . '}' . "\n";
				  break;


				// Pagination.
				case 'color_pagination_link':
				  $custom_css .= '.navigation .nav-links a,#infinite-handle span{color:' . $color . '}' . "\n";
				  break;
				case 'color_pagination_link_hover':
				  $custom_css .= '.navigation .nav-links .page-numbers.current,  .navigation .nav-links a:hover,#infinite-handle span:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_pagination_link_background':
				  $custom_css .= '.navigation .nav-links a,#infinite-handle span{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_pagination_link_background_hover':
				  $custom_css .= '.navigation .nav-links .page-numbers.current,  .navigation .nav-links a:hover,#infinite-handle span:hover{background-color:' . $color . '}' . "\n";
				  break;

				// Breadcrumb.

				case 'color_breadcrumb_link':
				  $custom_css .= '#crumbs a,#breadcrumb a{color:' . $color . '}' . "\n";
				  break;
				case 'color_breadcrumb_link_hover':
				  $custom_css .= '#crumbs a:hover,#breadcrumb a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_breadcrumb_text':
				  $custom_css .= '#breadcrumb{color:' . $color . '}' . "\n";
				  break;

				// Footer Widgets.
				case 'color_footer_widgets_background':
				  $custom_css .= '#footer-widgets{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_widgets_title':
				  $custom_css .= '#footer-widgets .widget-title span{color:' . $color . '}' . "\n";
				  break;
				 case 'color_footer_widgets_title_background':
				  $custom_css .= '#footer-widgets .widget-title span,#footer-widgets .widget-title span:after{background-color:' . $color . '}' . "\n";
				  break;
				 case 'color_footer_widgets_title-border':
				  $custom_css .= '#footer-widgets .widget-title{border-color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_widgets_text':
				  $custom_css .= '#footer-widgets ,#footer-widgets p{color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_widgets_link':
				  $custom_css .= '#footer-widgets a{color:' . $color . '}' . "\n";
				break;
				case 'color_footer_widgets_link_hover':
				  $custom_css .= '#footer-widgets a:hover{color:' . $color . '}' . "\n";
				  break;

				// Home Page Widgets.
	

				case 'color_home_widgets_area_title':
				  $custom_css .= '#sidebar-front-page-widget-area .widget-title span,#sidebar-front-page-widget-area .magazine_plus_widget_tabbed .tabbed-container .etabs li.active a,#sidebar-front-page-widget-area .magazine_plus_widget_tabbed .tabbed-container .etabs li a, #sidebar-front-page-bottom-widget-area .widget-title span,#sidebar-front-page-bottom-widget-area .magazine_plus_widget_tabbed .tabbed-container .etabs li.active a,#sidebar-front-page-bottom-widget-area .magazine_plus_widget_tabbed .tabbed-container .etabs li a{color:' . $color . '}' . "\n";
				  break;
				case 'color_home_widgets_area_title_background':
				  $custom_css .= '#sidebar-front-page-widget-area .widget-title span,#sidebar-front-page-widget-area .magazine_plus_widget_tabbed .tabbed-container .etabs li.active a,#sidebar-front-page-widget-area .magazine_plus_widget_tabbed .tabbed-container .etabs li a:hover, #sidebar-front-page-bottom-widget-area .widget-title span,#sidebar-front-page-bottom-widget-area .magazine_plus_widget_tabbed .tabbed-container .etabs li.active a,#sidebar-front-page-bottom-widget-area .magazine_plus_widget_tabbed .tabbed-container .etabs li a:hover{background-color:' . $color . '}' . "\n";
				  $custom_css .= '#sidebar-front-page-widget-area .widget-title:after,#sidebar-front-page-bottom-widget-area .widget-title:after{background-color:' . $color . '}' . "\n";

				  break;
				case 'color_home_widgets_area_title_border':
				  $custom_css .= '#sidebar-front-page-widget-area .widget-title,
				  #sidebar-front-page-bottom-widget-area .widget-title{border-color:' . $color . '}' . "\n";
				  break;  
				case 'color_home_widgets_area_text':
				  $custom_css .= '#sidebar-front-page-widget-area,#sidebar-front-page-widget-area p ,#sidebar-front-page-widget-area span, #sidebar-front-page-bottom-widget-area, #sidebar-front-page-bottom-widget-area p , #sidebar-front-page-bottom-widget-area span{color:' . $color . '}' . "\n";
				  break;
				case 'color_home_widgets_area_link':
				  $custom_css .= '#sidebar-front-page-widget-area .widget a,#sidebar-front-page-widget-area .widget a,
				  #sidebar-front-page-bottom-widget-area .widget a,#sidebar-front-page-widget-area .widget a{color:' . $color . '}' . "\n";
				  break;
				case 'color_home_widgets_area_link_hover':
				  $custom_css .= '#sidebar-front-page-widget-area .widget a:hover,#sidebar-front-page-widget-area .widget a:hover,#sidebar-front-page-widget-area .widget a:hover,#sidebar-front-page-bottom-widget-area .widget a:hover{color:' . $color . '}' . "\n";
				  break;
		



			  default:
			    break;

			}

		}

		// Render style.
		if ( ! empty( $custom_css ) ) {
		  echo '<style type="text/css">';
		  echo $custom_css;
		  echo '</style>';
		}

	}

endif;

add_action( 'magazine_plus_action_theme_custom_css', 'magazine_plus_add_theme_custom_color_css', 25 );
