<?php
/**
 * Theme About Page
 *
 * @package Signify_Blocks_Pro
 * @since 1.0
 */

function signify_blocks_theme_page_admin_style( $hook ) {
	if ( 'appearance_page_signify-blocks-pro-theme' === $hook ) {
		// Register theme stylesheet.
		$theme_version = wp_get_theme()->get( 'Version' );

		$version_string = is_string( $theme_version ) ? $theme_version : false;
		wp_enqueue_style(
			'signify-blocks-theme-admin-style',
			get_theme_file_uri( 'assets/css/about-admin.css' ),
			array(),
			$version_string
		);
	}
}
add_action( 'admin_enqueue_scripts', 'signify_blocks_theme_page_admin_style' );

/**
 * Add theme page
 */
function signify_blocks_menu() {
	add_theme_page( esc_html__( 'Signify Blocks Pro', 'signify-blocks-pro' ), esc_html__( 'Signify Blocks Pro', 'signify-blocks-pro' ), 'edit_theme_options', 'signify-blocks-pro-theme', 'signify_blocks_theme_page_display' );
}
add_action( 'admin_menu', 'signify_blocks_menu' );

/**
 * Display About page
 */
function signify_blocks_theme_page_display() {
	$theme = wp_get_theme();
	
	if ( is_child_theme() ) {
		$theme = wp_get_theme()->parent();
	}
	?>
	
	<div id="welcome-panel" class="welcome-panel">
		<div class="welcome-panel-content">
			<div class="welcome-panel-header">
				<h2><?php echo esc_html( $theme->Name ); ?></h2>
				<p><?php esc_html_e( 'Full Site Editing WordPress Theme', 'signify-blocks-pro' ); ?></p>
			</div>
			
			<div class="welcome-panel-column-container">
				<div class="container-wrap">
					<div class="welcome-panel-column two-columns">
						<!-- <div class="welcome-panel-icon-pages"></div> -->
						<div class="welcome-panel-column-content">
							<h3><?php esc_html_e( 'Getting Started with Signify Blocks Pro!', 'signify-blocks-pro' ); ?></h3>
							<p><?php esc_html_e( 'Awesome! Signify Blocks Pro has been installed and activated successfully. Now, you can start building your dream website with a wide range of highly-customizable block patterns, templates, and template parts available in this astounding theme.', 'signify-blocks-pro' ); ?></p>
							<a target="_blank" href="https://catchthemes.com/themes/signify-blocks-pro/#theme-instructions"><?php esc_html_e( 'Theme documentation', 'signify-blocks-pro' ); ?></a>
						</div>
					</div>
					
					<div class="welcome-panel-column two-columns">
						<div class="welcome-panel-column-content">
							<h3><?php esc_html_e( 'More Features with FSE Pro plugin', 'signify-blocks-pro' ); ?></h3>
							<p><?php esc_html_e( 'To get more beautiful block patterns and templates, we recommend you activate the FSE Pro plugin by Catch Themes. With the plugin installed, get more options, blocks, block patterns, templates and template parts.', 'signify-blocks-pro' ); ?></p>
							<p><?php esc_html_e( 'FSE Pro plugin is bundled with the theme when pro theme is purchased. Install the zip file to get more features.', 'signify-blocks-pro' ); ?></p>
						</div>
					</div>
				</div>
				<div class="sidebar">
					<div class="welcome-panel-column important-links">
					<!-- <div class="welcome-panel-icon-pages"></div> -->
					<div class="welcome-panel-column-content">
						<h3><?php esc_html_e( 'Important Links', 'signify-blocks-pro' ); ?></h3>
						<a target="_blank" href="<?php echo esc_url( $theme->get( 'ThemeURI' ) ); ?>"><?php esc_html_e( 'Theme Info', 'signify-blocks-pro' ); ?></a>
						<a target="_blank" href="https://fse.catchthemes.com/signify-blocks-pro"><?php esc_html_e( 'View Demo', 'signify-blocks-pro' ); ?></a>
						<a  target="_blank" href="<?php echo esc_url( $theme->get( 'ThemeURI' ) . '/#theme-instructions' ); ?>"><?php esc_html_e( 'Theme Instructions', 'signify-blocks-pro' ); ?></a>
						<a  target="_blank" href="<?php echo esc_url( $theme->get( 'ThemeURI' ) . '/#changelog' ); ?>"><?php esc_html_e( 'Change log', 'signify-blocks-pro' ); ?></a>
						<a target="_blank" href="<?php echo esc_url( 'https://themepalace.com/forum/pro-themes/signify-blocks-pro/' ); ?>"><?php esc_html_e( 'Support', 'signify-blocks-pro' ); ?></a>
					</div>
				</div>

				<div class="welcome-panel-column review">
					<!-- <div class="welcome-panel-icon-pages"></div> -->
					<div class="welcome-panel-column-content">
						<h3><?php esc_html_e( 'Leave us a review', 'signify-blocks-pro' ); ?></h3>
						<p><?php esc_html_e( 'Loved Signify Blocks? Feel free to leave your feedback. Your opinion helps us reach more audiences!', 'signify-blocks-pro' ); ?></p>
						<a href="https://wordpress.org/support/theme/signify-blocks/reviews/" class="button button-primary button-hero" style="text-decoration: none;" target="_blank"><?php esc_html_e( 'Review', 'signify-blocks-pro' ); ?></a>
					</div>
				</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
