<?php
/**
 * Blocks
 *
 * @package Signify_Blocks_Pro
 * @since 1.0
 */

 /**
  * Include blocks
  */
require_once get_theme_file_path( '/inc/blocks/src/Slider/Slider.php' );
require_once get_theme_file_path( '/inc/blocks/src/Slides/Slides.php' );
require_once get_theme_file_path( '/inc/blocks/src/HeaderSearch/HeaderSearch.php' );
require_once get_theme_file_path( '/inc/blocks/src/Masonry/Masonry.php' );

/**
 * Add Custom block category for custom blocks.
 *
 * @param array $categories
 * @return void
 */
function signify_blocks_add_block_category( $categories ) {
	$categories[] = array(
		'slug'  => 'signify-blocks-pro',
		'title' => esc_html__( 'Signify Blocks Pro', 'signify-blocks-pro' ),
	);

	return $categories;
}
add_filter(	'block_categories_all', 'signify_blocks_add_block_category', 10, 2 );
