<?php

function signify_blocks_header_search_block_assets() {
	wp_register_script(
		'signify-blocks-pro-header-search-custom-script',
		get_theme_file_uri() . '/assets/js/header-search.js',
		array(),
		filemtime( get_theme_file_path() . '/assets/js/header-search.js' ),
		true
	);

	$script_asset = require get_theme_file_path() . '/inc/blocks/dist/header-search.asset.php';
	
	wp_enqueue_script(
		'signify-blocks-pro-header-search-script',
		get_theme_file_uri() . '/inc/blocks/dist/header-search.js',
		isset( $script_asset['dependencies'] ) ? $script_asset['dependencies'] : array(),
		filemtime( get_theme_file_path() . '/inc/blocks/dist/header-search.js' ),
		true
	);

	wp_register_style(
		'signify-blocks-pro-header-search-style',
		get_theme_file_uri() . '/inc/blocks/dist/style-header-search.css',
		array(),
		filemtime( get_theme_file_path() . '/inc/blocks/dist/style-header-search.css' ),
		'all'
	);

	register_block_type( __DIR__, array(
		'render_callback' => 'signify_blocks_render_header_search'
	) );

}
add_action( 'init', 'signify_blocks_header_search_block_assets' );

function signify_blocks_render_header_search( $attr, $content ) {
	ob_start();
	?>
	<div class="wp-block-signify-blocks-pro-header-search">
		<button class="search-controller">
			<svg class="search svg" width="20" height="20" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32" aria-hidden="true" focusable="false">
				<path d="M27.414,24.586l-5.077-5.077C23.386,17.928,24,16.035,24,14c0-5.514-4.486-10-10-10S4,8.486,4,14  s4.486,10,10,10c2.035,0,3.928-0.614,5.509-1.663l5.077,5.077c0.78,0.781,2.048,0.781,2.828,0  C28.195,26.633,28.195,25.367,27.414,24.586z M7,14c0-3.86,3.14-7,7-7s7,3.14,7,7s-3.14,7-7,7S7,17.86,7,14z"></path>
			</svg>
			
			<svg class="cross svg" width="20" height="20" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg">
				<path fill-rule="evenodd" d="M11.2929,3.29289 C11.6834,2.90237 12.3166,2.90237 12.7071,3.29289 C13.0976,3.68342 13.0976,4.31658 12.7071,4.70711 L9.41421,8 L12.7071,11.2929 C13.0976,11.6834 13.0976,12.3166 12.7071,12.7071 C12.3166,13.0976 11.6834,13.0976 11.2929,12.7071 L8,9.41421 L4.70711,12.7071 C4.31658,13.0976 3.68342,13.0976 3.29289,12.7071 C2.90237,12.3166 2.90237,11.6834 3.29289,11.2929 L6.58579,8 L3.29289,4.70711 C2.90237,4.31658 2.90237,3.68342 3.29289,3.29289 C3.68342,2.90237 4.31658,2.90237 4.70711,3.29289 L8,6.58579 L11.2929,3.29289 Z"/>
			</svg>
		</button>
		
		<?php echo $content; ?>
	</div><!-- .wp-block-signify-blocks-pro-header-search -->
	<?php
	return ob_get_clean();
}
