/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/packages/packages-block-editor/#useBlockProps
 */
import { useBlockProps, useInnerBlocksProps } from "@wordpress/block-editor";

import { useEffect } from "@wordpress/element";

import { select, subscribe } from "@wordpress/data";

/**
 * The edit function describes the structure of your block in the context of the
 * editor. This represents what the editor will render when the block is used.
 *
 * @see https://developer.wordpress.org/block-editor/developers/block-api/block-edit-save/#edit
 *
 * @return {WPElement} Element to render.
 */
export default function Edit(props) {
  const blockProps = useBlockProps();

  const TEMPLATE = [
    [
      "core/group",
      { className: "search-container" },
      [["core/search", { showLabel: false }]],
    ],
  ];

  const innerBlocksProps = useInnerBlocksProps(blockProps, {
    allowedBlocks: ["core/group", "core/search"],
    orientation: "",
    renderAppender: false,
    template: TEMPLATE,
    templateLock: "all",
  });

  header_search_click_event();

  function header_search_click_event() {
    document.querySelectorAll(".search-controller").forEach((value) => {
      value.addEventListener("click", function (e) {
        e.preventDefault();
        e.stopImmediatePropagation();

        const displayTarget = value.nextElementSibling;

        document.querySelectorAll(".social-controller").forEach((item) => {
          item.querySelector(".social").style.display = "block";
          item.querySelector(".cross").style.display = "none";
          const itemTarget = item.nextElementSibling;
          itemTarget.style.display = "none";
        });

        document.querySelectorAll(".search-controller").forEach((item) => {
          if (item !== value) {
            item.querySelector(".search").style.display = "block";
            item.querySelector(".cross").style.display = "none";
            const itemTarget = item.nextElementSibling;
            itemTarget.style.display = "none";
          }
        });

        if (
          !displayTarget.style.display ||
          displayTarget.style.display === "none"
        ) {
          displayTarget.style.display = "block";
          value.querySelector(".search").style.display = "none";
          value.querySelector(".cross").style.display = "block";
        } else {
          displayTarget.style.display = "none";
          value.querySelector(".search").style.display = "block";
          value.querySelector(".cross").style.display = "none";
        }
      });
    });

    document.addEventListener("click", function (e) {
      document.querySelectorAll(".search-controller").forEach((value) => {
        var displayTarget = value.nextElementSibling;

        if (!displayTarget.contains(e.target)) {
          displayTarget.style.display = "none";
          value.querySelector(".search").style.display = "block";
          value.querySelector(".cross").style.display = "none";
        }
      });
    });
  }

  useEffect(() => {
    header_search_click_event();
  }, []);
  return (
    <>
      <div {...blockProps}>
        <button className="search-controller">
          <svg
            className="search svg"
            width="20"
            height="20"
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            aria-hidden="true"
            focusable="false"
          >
            <path d="M27.414,24.586l-5.077-5.077C23.386,17.928,24,16.035,24,14c0-5.514-4.486-10-10-10S4,8.486,4,14  s4.486,10,10,10c2.035,0,3.928-0.614,5.509-1.663l5.077,5.077c0.78,0.781,2.048,0.781,2.828,0  C28.195,26.633,28.195,25.367,27.414,24.586z M7,14c0-3.86,3.14-7,7-7s7,3.14,7,7s-3.14,7-7,7S7,17.86,7,14z"></path>
          </svg>

          <svg
            className="cross svg"
            width="20"
            height="20"
            viewBox="0 0 16 16"
            xmlns="http://www.w3.org/2000/svg"
          >
            <path
              fillRule="evenodd"
              d="M11.2929,3.29289 C11.6834,2.90237 12.3166,2.90237 12.7071,3.29289 C13.0976,3.68342 13.0976,4.31658 12.7071,4.70711 L9.41421,8 L12.7071,11.2929 C13.0976,11.6834 13.0976,12.3166 12.7071,12.7071 C12.3166,13.0976 11.6834,13.0976 11.2929,12.7071 L8,9.41421 L4.70711,12.7071 C4.31658,13.0976 3.68342,13.0976 3.29289,12.7071 C2.90237,12.3166 2.90237,11.6834 3.29289,11.2929 L6.58579,8 L3.29289,4.70711 C2.90237,4.31658 2.90237,3.68342 3.29289,3.29289 C3.68342,2.90237 4.31658,2.90237 4.70711,3.29289 L8,6.58579 L11.2929,3.29289 Z"
            />
          </svg>
        </button>

        {innerBlocksProps.children}
      </div>
    </>
  );
}
