const { render } = wp.element;

import Masonry from "react-masonry-css";

const masonry = document.querySelector(".wp-block-signify-blocks-pro-masonry");

if ( masonry !== null ) {
  const masonryBlocks = document.querySelectorAll(".wp-block-signify-blocks-pro-masonry");

	function MasonryBlock(item) {
	  let images = item.querySelectorAll(".grid-item img");
	  // Convert array to JSX items
	  const items = [...images].map(function (item, index) {
			return <img key ={index} src={item.src} />;
		});

	  let atr = item.getAttribute("data-layout");

	  const newArr = Object.values(atr);

	  const breakpointColumnsObj = {
			default: newArr,
		  700: 2,
		  501: 1,
				};

	  return (
		<Masonry
		breakpointCols  ={breakpointColumnsObj}
		className       ={
				  breakpointColumnsObj.default == 1
				? `layout-one my-masonry-grid`
				: breakpointColumnsObj.default == 2
				? `layout-two my-masonry-grid`
				: breakpointColumnsObj.default == 3
				? `layout-three my-masonry-grid`
				: breakpointColumnsObj.default == 4
				? `layout-four my-masonry-grid`
				: `my-masonry-grid`
		  }
		columnClassName ="my-masonry-grid_column"
		>
		{items}
		</Masonry>
	  );
	}
  // Convert array to JSX items
  const masonryBlock = [...masonryBlocks].map(function (item, index) {
		render(MasonryBlock(item), item);
	});
}
