/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/packages/packages-block-editor/#useBlockProps
 */
import { __ } from "@wordpress/i18n";
 
import {
  useBlockProps,
} from "@wordpress/block-editor";

import "./style.scss";

export default function save({ attributes }) {
  const { imageData, columnLayout, columnGutter, alignment } = attributes;

  const blockProps = useBlockProps.save({
    className: `catch-gallery align${alignment}`,
    "data-layout": columnLayout,
    "column-gutter": columnGutter,
    align: alignment,
    style: {
      "--column-gutter": `${columnGutter}px`,
    },
  });

  return (
    <>
      <div {...blockProps}>
        <div className="grid-item">
        {imageData.map((img,i) => (
          <img key={i} src={img.url} />
        ))}
        </div>
      </div>
    </>
  );
}
