<?php

function signify_blocks_slider_block_assets() {
	wp_register_script(
		'signify-blocks-pro-slider-script', 
		get_theme_file_uri() . '/inc/blocks/dist/slider-front.js', 
		array(), 
		filemtime( get_theme_file_path() . '/inc/blocks/dist/slider-front.js' ),
		true
	);
	
	wp_register_style(
		'signify-blocks-pro-slider-editor-style',
		get_theme_file_uri() . '/inc/blocks/dist/slider.css',
		array(),
		filemtime( get_theme_file_path() . '/inc/blocks/dist/slider.css' ),
		'all'
	);

	$script_asset                   = require get_theme_file_path() . '/inc/blocks/dist/slider.asset.php';
	$script_asset['dependencies'][] = 'signify-blocks-pro-slider-script';
	wp_register_script(
		'signify-blocks-pro-slider-editor-script',
		get_theme_file_uri() . '/inc/blocks/dist/slider.js',
		isset( $script_asset['dependencies'] ) ? $script_asset['dependencies'] : array(),
		filemtime( get_theme_file_path() . '/inc/blocks/dist/slider.js' ),
		true
	);
		
	wp_register_style(
		'signify-blocks-pro-swiper-style', 
		get_theme_file_uri() . '/inc/blocks/dist/slider-front.css',
		array(), 
		filemtime( get_theme_file_path() . '/inc/blocks/dist/slider-front.css' ), 
		'all' 
	);
	
	wp_register_style(
		'signify-blocks-pro-slider-style', 
		get_theme_file_uri() . '/assets/css/slider-style.css',
		array( 'signify-blocks-pro-swiper-style' ), 
		filemtime( get_theme_file_path() . '/assets/css/slider-style.css' ), 
		'all' 
	);

	/**
	 * Register Gutenberg block on server-side.
	 * 
	 * Register the block on server-side to ensure that the block
	 * scripts and styles for both frontend and backend are
	 * enqueued when the editor loads.
	 *
	 * @link https://wordpress.org/gutenberg/handbook/blocks/writing-your-first-block-type#enqueuing-block-scripts
	 * @since 1.16.0
	 */
	register_block_type(
		__DIR__, array(
			'render_callback' => 'signify_blocks_slider_block_save'
		)
	);
}
add_action( 'init', 'signify_blocks_slider_block_assets' );

function signify_blocks_slider_block_save( $attr, $content ) {

	$align = isset( $attr['align'] ) ? $attr['align'] : '';
	
	$alignClass = ( 'full' === $align ) ? ' alignfull' : ( ( 'wide' === $align ) ? ' alignwide' : '' );

	$block_id = isset( $attr['blockId'] ) ? $attr['blockId'] : '';
	
	$slider_id = wp_unique_id( 'slider-' );
	
	$main_wrapper_class = "fse-slider-wrapper {$alignClass} {$attr['axis']}";
	
	
	if ( isset( $attr['controls'] ) && $attr['controls'] ) {
		$main_wrapper_class .= ' navigation-enabled';
	}
	
	if ( isset( $attr['dot'] ) && $attr['dot'] ) {
		$main_wrapper_class .= ' pagination-enabled';

		if ( isset( $attr['dotPosition'] ) ) {
			$main_wrapper_class .= ' ' . $attr['dotPosition'];
		}
	}
	
	$content = str_replace( 'wp-block-signify-blocks-pro-slider', 'wp-block-signify-blocks-pro-slider swiper-wrapper', $content );
	$content = str_replace( 'wp-block-signify-blocks-pro-slides', 'wp-block-signify-blocks-pro-slides swiper-slide', $content );
	ob_start();
	?>
	<div class="<?php echo esc_attr( $main_wrapper_class ); ?>" id="<?php echo esc_attr( $slider_id ); ?>">
		<?php echo $content; ?>
		<?php if ( isset( $attr['controls'] ) && $attr['controls'] ) : ?>
			<div class="navigation-wrap">
				<div class="swiper-button swiper-button-prev"></div>
				<div class="swiper-button swiper-button-next"></div>
			</div>
		<?php endif; ?>
			
			
		<?php if ( isset( $attr['dot'] ) && $attr['dot'] ) : ?>
			<div class="swiper-pagination"></div>
		<?php endif; ?>
	
		<!-- If we need scrollbar -->
		<!-- <div class="swiper-scrollbar"></div> -->
	</div>
	<?php
	return ob_get_clean();
}
