/**
 * Registers a new block provided a unique name and an object defining its behavior.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */
import { registerBlockType } from '@wordpress/blocks';
import { __ } from "@wordpress/i18n";

const icon = wp.element.createElement('svg',
  {
		width: "24",
		height: "24",
		viewBox: "0 0 24 24",
		className: "fse-block-icon"
  },
  wp.element.createElement('path',
	{
		d: "M11.7,0 C13.1911688,0 14.4,1.20883118 14.4,2.7 L14.4,15.3 C14.4,16.7911688 13.1911688,18 11.7,18 L6.3,18 C4.80883117,18 3.6,16.7911688 3.6,15.3 L3.6,2.7 C3.6,1.20883118 4.80883117,0 6.3,0 L11.7,0 Z M11.7,1.8 L6.3,1.8 C5.80294372,1.8 5.4,2.20294373 5.4,2.7 L5.4,15.3 C5.4,15.7970562 5.80294372,16.2 6.3,16.2 L11.7,16.2 C12.1970562,16.2 12.6,15.7970562 12.6,15.3 L12.6,2.7 C12.6,2.20294373 12.1970562,1.8 11.7,1.8 Z M0.9,3.6 C1.39705628,3.6 1.8,4.00294372 1.8,4.5 L1.8,13.5 C1.8,13.9970562 1.39705628,14.4 0.9,14.4 C0.402943725,14.4 0,13.9970562 0,13.5 L0,4.5 C0,4.00294372 0.402943725,3.6 0.9,3.6 Z M17.1,3.6 C17.5970562,3.6 18,4.00294372 18,4.5 L18,13.5 C18,13.9970562 17.5970562,14.4 17.1,14.4 C16.6029438,14.4 16.2,13.9970562 16.2,13.5 L16.2,4.5 C16.2,4.00294372 16.6029438,3.6 17.1,3.6 Z"
	}
  )
);

/**
 * WordPress dependencies
 */
import {
  useBlockProps,
  useInnerBlocksProps,
} from '@wordpress/block-editor';

import edit from './edit';
//import variations from './variations';

/**
 * Lets webpack process CSS, SASS or SCSS files referenced in JavaScript files.
 * All files containing `style` keyword are bundled together. The code used
 * gets applied both to the front of your site and to the editor.
 *
 * @see https://www.npmjs.com/package/@wordpress/scripts#using-css
 */

var attributes = {
	"blockId": {
		"type": "string"
	},
	"slidesPerPage": {
		"type": "number",
		"default": 1
	},
	"controls": {
		"type": "boolean",
		"default": true
	},
	"autoplay": {
		"type": "boolean",
		"default": true
	},
	"autoplayDelay": {
		"type": "number",
		"default": 3000
	},
	"dot": {
		"type": "boolean",
		"default": true
	},
	"dotPosition": {
		"type": "string",
		"default": "horizontal-inside-slider-bottom-center"
	},
	"axis": {
		"type": "string",
		"default": "horizontal"
	},
	"slideBy": {
		"type": "number",
		"default": 1
	},
	"center": {
		"type": "boolean",
		"default": false
	},
	"spaceBetween": {
		"type": "number",
		"default": 0
	}
};

/**
 * Every block starts by registering a new block type definition.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */
registerBlockType('signify-blocks-pro/slider', {
  attributes,
	title: 'Slider',
  icon,
  //variations,
  edit,

	save: (props) => {
	  const { attributes } = props;
	  const { blockId, slidesPerPage, controls, autoplay, dot, axis, slideBy, center, spaceBetween } = attributes;

	  const blockProps = useBlockProps.save({
			className: `signify-blocks-pro-slider`,
			'data-slider': JSON.stringify({
				blockId,
				slidesPerPage,
				controls,
				autoplay,
				spaceBetween,
				dot,
				axis,
				slideBy,
				center
				})
	  });

	const innerBlocksProps = useInnerBlocksProps.save(blockProps);

	return <div {...innerBlocksProps} />;
	},
	deprecated: [
	{
		attributes: {
			"blockId": {
				"type": "string"
			},
			"slidesPerPage": {
				"type": "number",
				"default": 1
			},
			"controls": {
				"type": "boolean",
				"default": true
			},
			"autoplay": {
				"type": "boolean",
				"default": true
			},
			"autoplayDelay": {
				"type": "number",
				"default": 3000
			},
			"dot": {
				"type": "boolean",
				"default": true
			},
			"dotPosition": {
				"type": "string",
				"default": "horizontal-inside-slider-bottom-center"
			},
			"axis": {
				"type": "string",
				"default": "horizontal"
			},
			"slideBy": {
				"type": "number",
				"default": 1
			},
			"center": {
				"type": "boolean",
				"default": false
			}
		},
		save( props ) {
		const { attributes } = props;
		const { blockId, slidesPerPage, controls, autoplay, dot, axis, slideBy, center } = attributes;
	
		const blockProps = useBlockProps.save({
				className: `signify-blocks-pro-slider`,
				'data-slider': JSON.stringify({
			  blockId,
			  slidesPerPage,
			  controls,
			  autoplay,
			  dot,
			  axis,
			  slideBy,
			  center
					})
		});
	
		const innerBlocksProps = useInnerBlocksProps.save(blockProps);
	
		return <div {...innerBlocksProps} />;
		},
	},
],
});
