// import Swiper bundle with all modules installed
import Swiper from "swiper/bundle";

// import styles bundle
import "swiper/css/bundle";

const sliders = document.querySelectorAll(".fse-slider-wrapper");

// Convert array to JSX items
const items = [...sliders].map(function (item, index) {
  var sliderData = {};

  if (item.getElementsByClassName("swiper-wrapper")[0].dataset.slider) {
    var sliderData = JSON.parse(
      item.getElementsByClassName("swiper-wrapper")[0].dataset.slider
    );
  }

  if (item.getElementsByClassName("swiper-wrapper")[0].dataset.tinySlider) {
    var sliderData = JSON.parse(
      item.getElementsByClassName("swiper-wrapper")[0].dataset.tinySlider
    );
  }

  if (!sliderData.spaceBetween) {
    sliderData.spaceBetween = 0;
  }

  const paginationSelector = "#" + item.id + " .swiper-pagination";
  const navNext = "#" + item.id + " .swiper-button-next";
  const navPrev = "#" + item.id + " .swiper-button-prev";

  var sliderOptions = {
    // Optional parameters
    direction: sliderData.axis,
    slidesPerView: 1,
    loop: true,
    spaceBetween: sliderData.spaceBetween,
    //autoHeight: true,

    // If we need pagination
    pagination: {
      el: paginationSelector,
      clickable: true,
    },

    // Navigation arrows
    navigation: {
      nextEl: navNext,
      prevEl: navPrev,
    },
    breakpoints: {
      640: {
        slidesPerView:
          sliderData.slidesPerPage > 1 ? 2 : sliderData.slidesPerPage,
      },
      900: {
        slidesPerView: sliderData.slidesPerPage,
      },
    },
  };
  if (sliderData.autoplay) {
    sliderOptions["autoplay"] = {
      delay: sliderData.autoplayDelay ? sliderData.autoplayDelay : 3000,
    };
  }

  const swiper = new Swiper(item, sliderOptions);
});
