<?php

function signify_blocks_slides_block_assets() {
	$script_asset = require get_theme_file_path() . '/inc/blocks/dist/slides.asset.php';
	wp_register_script(
		'signify-blocks-pro-slides-script',
		get_theme_file_uri() . '/inc/blocks/dist/slides.js',
		isset( $script_asset['dependencies'] ) ? $script_asset['dependencies'] : array(),
		'0.0.1',
		false
	);

	wp_register_style(
		'signify-blocks-pro-slides-editor-style',
		get_theme_file_uri() . '/inc/blocks/dist/slides.css',
		array(),
		'0.0.1',
		'all'
	);

	/**
	 * Register Gutenberg block on server-side.
	 * 
	 * Register the block on server-side to ensure that the block
	 * scripts and styles for both frontend and backend are
	 * enqueued when the editor loads.
	 *
	 * @link https://wordpress.org/gutenberg/handbook/blocks/writing-your-first-block-type#enqueuing-block-scripts
	 * @since 1.16.0
	 */
	register_block_type(
		__DIR__
	);
}

add_action( 'init', 'signify_blocks_slides_block_assets' );
