<?php

/**
 * Title: Contact
 * Slug: signify-blocks/contact
 * Categories: signify-blocks, page
 */
?>

<!-- wp:group {"align":"full","style":{"spacing":{"blockGap":"0px"}},"className":"wp-block-section wp-block-contact has-map","layout":{"inherit":true,"type":"constrained"}} -->
<div class="wp-block-group alignfull wp-block-section wp-block-contact has-map"><!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->
	<div class="wp-block-group alignfull"><!-- wp:image {"align":"full","sizeSlug":"full","linkDestination":"none"} -->
		<figure class="wp-block-image alignfull size-full"><img src="<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/map-contact.jpg' ) ); ?>" alt="" /></figure>
		<!-- /wp:image -->
	</div>
	<!-- /wp:group -->

	<!-- wp:group {"align":"wide","style":{"spacing":{"padding":{"top":"var:preset|spacing|80","right":"var:preset|spacing|80","bottom":"var:preset|spacing|80","left":"var:preset|spacing|80"}}},"className":"wp-block-contact-and-form","layout":{"type":"constrained"}} -->
	<div class="wp-block-group alignwide wp-block-contact-and-form" style="padding-top:var(--wp--preset--spacing--80);padding-right:var(--wp--preset--spacing--80);padding-bottom:var(--wp--preset--spacing--80);padding-left:var(--wp--preset--spacing--80)"><!-- wp:columns {"align":"wide"} -->
		<div class="wp-block-columns alignwide"><!-- wp:column -->
			<div class="wp-block-column"><!-- wp:group {"align":"wide","style":{"spacing":{"blockGap":"14px"}},"className":"alignwide wp-block-group-heading"} -->
				<div class="wp-block-group alignwide wp-block-group-heading"><!-- wp:heading {"textAlign":"left","level":6,"style":{"typography":{"textTransform":"uppercase","fontStyle":"normal","fontWeight":"700","lineHeight":1.8}},"textColor":"primary","fontSize":"extra-small","fontFamily":"open-sans"} -->
					<h6 class="wp-block-heading has-text-align-left has-primary-color has-text-color has-open-sans-font-family has-extra-small-font-size" style="font-style:normal;font-weight:700;line-height:1.8;text-transform:uppercase"><?php esc_html_e('Contact Us', 'signify-blocks-pro'); ?></h6>
					<!-- /wp:heading -->

					<!-- wp:heading {"textAlign":"left","fontSize":"product-heading"} -->
					<h2 class="wp-block-heading has-text-align-left has-product-heading-font-size"><?php esc_html_e('Lets Get In Touch', 'signify-blocks-pro'); ?></h2>
					<!-- /wp:heading -->

					<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"0","bottom":"0","left":"0"}}},"className":"contact-information","layout":{"type":"constrained"}} -->
					<div class="wp-block-group contact-information" style="padding-top:var(--wp--preset--spacing--30);padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"top"}} -->
						<div class="wp-block-group"><!-- wp:image {"sizeSlug":"full","linkDestination":"none"} -->
							<figure class="wp-block-image size-full"><img src="<?php echo esc_url(  get_parent_theme_file_uri( '/assets/images/icon-email.png' ) ); ?>" alt="" /></figure>
							<!-- /wp:image -->

							<!-- wp:group {"style":{"spacing":{"blockGap":"0px"}},"layout":{"type":"constrained"}} -->
							<div class="wp-block-group"><!-- wp:paragraph {"style":{"typography":{"fontSize":"12px","textTransform":"uppercase","fontStyle":"normal","fontWeight":"700","lineHeight":1.8}},"textColor":"foreground"} -->
								<p class="has-foreground-color has-text-color" style="font-size:12px;font-style:normal;font-weight:700;line-height:1.8;text-transform:uppercase"><?php esc_html_e('Email', 'signify-blocks-pro'); ?></p>
								<!-- /wp:paragraph -->

								<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}}},"fontSize":"normal"} -->
								<p class="has-link-color has-normal-font-size"><a href="#"><?php esc_html_e('info@example.com', 'signify-blocks-pro'); ?></a></p>
								<!-- /wp:paragraph -->
							</div>
							<!-- /wp:group -->
						</div>
						<!-- /wp:group -->

						<!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"top"}} -->
						<div class="wp-block-group"><!-- wp:image {"sizeSlug":"full","linkDestination":"none"} -->
							<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/icon-call.png' ) ); ?>" alt="" /></figure>
							<!-- /wp:image -->

							<!-- wp:group {"style":{"spacing":{"blockGap":"0px"}},"layout":{"type":"constrained"}} -->
							<div class="wp-block-group"><!-- wp:paragraph {"style":{"typography":{"fontSize":"12px","textTransform":"uppercase","fontStyle":"normal","fontWeight":"700","lineHeight":1.8}},"textColor":"foreground"} -->
								<p class="has-foreground-color has-text-color" style="font-size:12px;font-style:normal;font-weight:700;line-height:1.8;text-transform:uppercase"><?php esc_html_e('Phone', 'signify-blocks-pro'); ?></p>
								<!-- /wp:paragraph -->

								<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}}},"fontSize":"normal"} -->
								<p class="has-link-color has-normal-font-size"><a href="#"><?php esc_html_e('123-456-789', 'signify-blocks-pro'); ?></a></p>
								<!-- /wp:paragraph -->
							</div>
							<!-- /wp:group -->
						</div>
						<!-- /wp:group -->

						<!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"top"}} -->
						<div class="wp-block-group"><!-- wp:image {"sizeSlug":"full","linkDestination":"none"} -->
							<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/icon-map.png' ) ); ?>" alt="" /></figure>
							<!-- /wp:image -->

							<!-- wp:group {"style":{"spacing":{"blockGap":"0px"}},"layout":{"type":"constrained"}} -->
							<div class="wp-block-group"><!-- wp:paragraph {"style":{"typography":{"fontSize":"12px","textTransform":"uppercase","fontStyle":"normal","fontWeight":"700","lineHeight":1.8}},"textColor":"foreground"} -->
								<p class="has-foreground-color has-text-color" style="font-size:12px;font-style:normal;font-weight:700;line-height:1.8;text-transform:uppercase"><?php esc_html_e('Location', 'signify-blocks-pro'); ?></p>
								<!-- /wp:paragraph -->

								<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}}},"fontSize":"normal"} -->
								<p class="has-link-color has-normal-font-size"><a href="#"><?php esc_html_e('345 1th Street, Office 879 New York', 'signify-blocks-pro'); ?></a></p>
								<!-- /wp:paragraph -->
							</div>
							<!-- /wp:group -->
						</div>
						<!-- /wp:group -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column -->
			<div class="wp-block-column"><!-- wp:group {"className":"contact-form","layout":{"type":"constrained"}} -->
				<div class="wp-block-group contact-form"><!-- wp:contact-form-7/contact-form-selector {"id":22630,"title":"Contact form 1"} -->
					<div class="wp-block-contact-form-7-contact-form-selector">[contact-form-7 id="22630" title="Contact form 1"]</div>
					<!-- /wp:contact-form-7/contact-form-selector -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:column -->
		</div>
		<!-- /wp:columns -->
	</div>
	<!-- /wp:group -->
</div>
<!-- /wp:group -->
