<?php

/**
 * Title: CTA
 * Slug: signify-blocks/cta
 * Categories: signify-blocks, page
 */
?>

<!-- wp:cover {"url":"<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/promotional-headline.jpg' ) ); ?>","dimRatio":40,"align":"full","className":"wp-block-section wp-block-cta"} -->
<div class="wp-block-cover alignfull wp-block-section wp-block-cta"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-40 has-background-dim"></span><img class="wp-block-cover__image-background" alt="" src="<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/promotional-headline.jpg' ) ); ?>" data-object-fit="cover" />
	<div class="wp-block-cover__inner-container"><!-- wp:group {"layout":{"inherit":true,"type":"constrained"}} -->
		<div class="wp-block-group"><!-- wp:group {"style":{"spacing":{"blockGap":"35px"}}} -->
			<div class="wp-block-group"><!-- wp:group {"align":"wide","style":{"spacing":{"blockGap":"14px","padding":{"top":"var:preset|spacing|60","right":"var:preset|spacing|60","bottom":"var:preset|spacing|60","left":"var:preset|spacing|60"}}},"backgroundColor":"secondary","className":"alignwide wp-block-group-heading"} -->
				<div class="wp-block-group alignwide wp-block-group-heading has-secondary-background-color has-background" style="padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--60)"><!-- wp:heading {"textAlign":"center","level":6,"style":{"typography":{"textTransform":"uppercase","fontStyle":"normal","fontWeight":"700","lineHeight":1.8}},"textColor":"primary","fontSize":"extra-small","fontFamily":"open-sans"} -->
					<h6 class="wp-block-heading has-text-align-center has-primary-color has-text-color has-open-sans-font-family has-extra-small-font-size" style="font-style:normal;font-weight:700;line-height:1.8;text-transform:uppercase"><?php esc_html_e('Promotion', 'signify-blocks-pro'); ?></h6>
					<!-- /wp:heading -->

					<!-- wp:heading {"textAlign":"center","textColor":"foreground","fontSize":"product-heading"} -->
					<h2 class="wp-block-heading has-text-align-center has-foreground-color has-text-color  has-product-heading-font-size"><?php esc_html_e('Limited Time Offers', 'signify-blocks-pro'); ?></h2>
					<!-- /wp:heading -->

					<!-- wp:paragraph {"align":"center","textColor":"foreground"} -->
					<p class="has-text-align-center has-foreground-color has-text-color"><?php esc_html_e('From flash sales to seasonal discounts', 'signify-blocks-pro'); ?></p>
					<!-- /wp:paragraph -->

					<!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"28px","right":"28px","bottom":"28px","left":"28px"}}},"textColor":"body-text"} -->
					<p class="has-text-align-center has-body-text-color has-text-color" style="margin-top:28px;margin-right:28px;margin-bottom:28px;margin-left:28px"><?php esc_html_e('Do not miss out on our time-sensitive promotions! Keep a close eye on our website to be updated about limited-time offers.', 'signify-blocks-pro'); ?></p>
					<!-- /wp:paragraph -->

					<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"},"style":{"spacing":{"margin":{"top":"28px"}}}} -->
					<div class="wp-block-buttons" style="margin-top:28px"><!-- wp:button -->
						<div class="wp-block-button"><a class="wp-block-button__link wp-element-button"><?php esc_html_e('Read More', 'signify-blocks-pro'); ?></a></div>
						<!-- /wp:button -->
					</div>
					<!-- /wp:buttons -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:group -->
	</div>
</div>
<!-- /wp:cover -->
