<?php

/**
 * Title: How It Works
 * Slug: signify-blocks/how-it-works
 * Categories: signify-blocks, page
 */
?>

<!-- wp:group {"align":"full","className":"wp-block-section wp-block-how-it-work","layout":{"inherit":true}} -->
<div class="wp-block-group alignfull wp-block-section wp-block-how-it-work">
	<!-- wp:group {"align":"wide","style":{"spacing":{"blockGap":"14px"}},"className":"alignwide wp-block-group-heading"} -->
	<div class="wp-block-group alignwide wp-block-group-heading"><!-- wp:heading {"textAlign":"center","level":6,"style":{"typography":{"textTransform":"uppercase","fontStyle":"normal","fontWeight":"700","lineHeight":1.8}},"textColor":"primary","fontSize":"extra-small","fontFamily":"open-sans"} -->
		<h6 class="wp-block-heading has-text-align-center has-primary-color has-text-color has-open-sans-font-family has-extra-small-font-size" style="font-style:normal;font-weight:700;line-height:1.8;text-transform:uppercase"><?php esc_html_e('What We Do', 'signify-blocks-pro'); ?></h6>
		<!-- /wp:heading -->

		<!-- wp:heading {"textAlign":"center","fontSize":"product-heading"} -->
		<h2 class="wp-block-heading has-text-align-center has-product-heading-font-size"><?php esc_html_e('How It Works', 'signify-blocks-pro'); ?></h2>
		<!-- /wp:heading -->

		<!-- wp:paragraph {"align":"center"} -->
		<p class="has-text-align-center"><?php esc_html_e('You can manage it from front page in site editor.', 'signify-blocks-pro'); ?></p>
		<!-- /wp:paragraph -->
	</div>
	<!-- /wp:group -->
	<!-- wp:columns {"align":"wide"} -->
	<div class="wp-block-columns alignwide">
		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"className":"wp-block-section-content"} -->
			<div class="wp-block-group wp-block-section-content">
				<!-- wp:image {"align":"center","sizeSlug":"full","linkDestination":"none"} -->
				<figure class="wp-block-image aligncenter size-full"><img src="<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/work-icon1.png' ) ); ?>" alt="" /></figure>
				<!-- /wp:image -->
				<!-- wp:heading {"textAlign":"center","fontSize":"content-heading"} -->
				<h2 class="has-text-align-center has-content-heading-font-size"><?php esc_html_e('Places the Order', 'signify-blocks-pro'); ?></h2>
				<!-- /wp:heading -->
				<!-- wp:paragraph {"align":"center"} -->
				<p class="has-text-align-center"><?php esc_html_e('Free podcast solution', 'signify-blocks-pro'); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->
		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"className":"wp-block-section-content"} -->
			<div class="wp-block-group wp-block-section-content">
				<!-- wp:image {"align":"center","sizeSlug":"full","linkDestination":"none"} -->
				<figure class="wp-block-image aligncenter size-full"><img src="<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/work-icon2.png' ) ); ?>" alt="" /></figure>
				<!-- /wp:image -->
				<!-- wp:heading {"textAlign":"center","fontSize":"content-heading"} -->
				<h2 class="has-text-align-center has-content-heading-font-size"><?php esc_html_e('Picking & Packaging', 'signify-blocks-pro'); ?></h2>
				<!-- /wp:heading -->
				<!-- wp:paragraph {"align":"center"} -->
				<p class="has-text-align-center"><?php esc_html_e('New way to explore', 'signify-blocks-pro'); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->
		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"className":"wp-block-section-content"} -->
			<div class="wp-block-group wp-block-section-content">
				<!-- wp:image {"align":"center","sizeSlug":"full","linkDestination":"none"} -->
				<figure class="wp-block-image aligncenter size-full"><img src="<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/work-icon3.png' ) ); ?>" alt="" /></figure>
				<!-- /wp:image -->
				<!-- wp:heading {"textAlign":"center","fontSize":"content-heading"} -->
				<h2 class="has-text-align-center has-content-heading-font-size"><?php esc_html_e('Shipping', 'signify-blocks-pro'); ?></h2>
				<!-- /wp:heading -->
				<!-- wp:paragraph {"align":"center"} -->
				<p class="has-text-align-center"><?php esc_html_e('Get more solution', 'signify-blocks-pro'); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->
		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"className":"wp-block-section-content"} -->
			<div class="wp-block-group wp-block-section-content">
				<!-- wp:image {"align":"center","sizeSlug":"full","linkDestination":"none"} -->
				<figure class="wp-block-image aligncenter size-full"><img src="<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/work-icon4.png' ) ); ?>" alt="" /></figure>
				<!-- /wp:image -->
				<!-- wp:heading {"textAlign":"center","fontSize":"content-heading"} -->
				<h2 class="has-text-align-center has-content-heading-font-size"><?php esc_html_e('Order Delivered', 'signify-blocks-pro'); ?></h2>
				<!-- /wp:heading -->
				<!-- wp:paragraph {"align":"center"} -->
				<p class="has-text-align-center"><?php esc_html_e('Free music solution', 'signify-blocks-pro'); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->
	</div>
	<!-- /wp:columns -->
</div>
<!-- /wp:group -->
