<?php

/**
 * Title: Portfolio
 * Slug: signify-blocks/portfolio
 * Categories: signify-blocks, page
 */
?>

<!-- wp:group {"align":"full","className":"wp-block-section wp-block-portfolio","layout":{"inherit":true}} -->
<div class="wp-block-group alignfull wp-block-section wp-block-portfolio">
	<!-- wp:group {"align":"wide","style":{"spacing":{"blockGap":"14px"}},"className":"alignwide wp-block-group-heading"} -->
	<div class="wp-block-group alignwide wp-block-group-heading"><!-- wp:heading {"textAlign":"center","level":6,"style":{"typography":{"textTransform":"uppercase","fontStyle":"normal","fontWeight":"700","lineHeight":1.8}},"textColor":"primary","fontSize":"extra-small","fontFamily":"open-sans"} -->
		<h6 class="wp-block-heading has-text-align-center has-primary-color has-text-color has-open-sans-font-family has-extra-small-font-size" style="font-style:normal;font-weight:700;line-height:1.8;text-transform:uppercase"><?php esc_html_e('My Gallery', 'signify-blocks-pro'); ?></h6>
		<!-- /wp:heading -->

		<!-- wp:heading {"textAlign":"center","fontSize":"product-heading"} -->
		<h2 class="wp-block-heading has-text-align-center has-product-heading-font-size"><?php esc_html_e('Portfolio', 'signify-blocks-pro'); ?></h2>
		<!-- /wp:heading -->

		<!-- wp:paragraph {"align":"center"} -->
		<p class="has-text-align-center"><?php esc_html_e('You can manage it from front page in site editor.', 'signify-blocks-pro'); ?></p>
		<!-- /wp:paragraph -->
	</div>
	<!-- /wp:group -->
	<!-- wp:group {"align":"wide","className":"wp-block-group-content"} -->
	<div class="wp-block-group alignwide wp-block-group-content">

		<!-- wp:signify-blocks-pro/masonry {"imageData":[{"sizes":{"full":{"url":"<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/portfolios-1.jpg' ) ); ?>","height":900,"width":599,"orientation":"portrait"}},"mime":"image/jpeg","type":"image","subtype":"jpeg","url":"<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/portfolios-1.jpg' ) ); ?>","alt":"","link":"#","caption":"Gallery"},{"sizes":{"full":{"url":"<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/portfolios-2.jpg' ) ); ?>","height":425,"width":599,"orientation":"landscape"}},"mime":"image/jpeg","type":"image","subtype":"jpeg","url":"<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/portfolios-2.jpg' ) ); ?>","alt":"","link":"#","caption":"Gallery"},{"sizes":{"full":{"url":"<?php echo esc_url(  get_parent_theme_file_uri( '/assets/images/portfolios-3.jpg' ) ); ?>","height":900,"width":599,"orientation":"portrait"}},"mime":"image/jpeg","type":"image","subtype":"jpeg","url":"<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/portfolios-3.jpg' ) ); ?>","alt":"","link":"#","caption":"Gallery"},{"sizes":{"full":{"url":"<?php echo esc_url(  get_parent_theme_file_uri( '/assets/images/portfolios-4.jpg' ) ); ?>","height":420,"width":599,"orientation":"landscape"}},"mime":"image/jpeg","type":"image","subtype":"jpeg","url":"<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/portfolios-4.jpg' ) ); ?>","alt":"","link":"#","caption":"Gallery"},{"sizes":{"full":{"url":"<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/portfolios-5.jpg' ) ); ?>","height":900,"width":599,"orientation":"portrait"}},"mime":"image/jpeg","type":"image","subtype":"jpeg","url":"<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/portfolios-5.jpg' ) ); ?>","alt":"","link":"#","caption":"Gallery"},{"sizes":{"full":{"url":"<?php echo esc_url(  get_parent_theme_file_uri( '/assets/images/portfolios-6.jpg' ) ); ?>","height":419,"width":599,"orientation":"landscape"}},"mime":"image/jpeg","type":"image","subtype":"jpeg","url":"<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/portfolios-6.jpg' ) ); ?>","alt":"","link":"#","caption":"Gallery"}],"columnGutter":40,"alignment":"wide"} -->
		<div class="wp-block-signify-blocks-pro-masonry catch-gallery alignwide" data-layout="3" column-gutter="40" align="wide" style="--column-gutter:40px">
			<div class="grid-item">
				<img src="<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/portfolios-1.jpg' ) ); ?>" />
				<img src="<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/portfolios-2.jpg' ) ); ?>" />
				<img src="<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/portfolios-3.jpg' ) ); ?>" />
				<img src="<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/portfolios-4.jpg' ) ); ?>" />
				<img src="<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/portfolios-5.jpg' ) ); ?>" />
				<img src="<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/portfolios-6.jpg' ) ); ?>" />
			</div>
		</div>
		<!-- /wp:signify-blocks-pro/masonry -->
	</div>
	<!-- /wp:group -->
</div>
<!-- /wp:group -->
