<?php

/**
 * Title: Quick Contact Form
 * Slug: signify-blocks/quick-contact-form
 * Categories: signify-blocks, page
 */
?>

<!-- wp:group {"align":"full","className":"wp-block-section","layout":{"inherit":true}} -->
<div class="wp-block-group alignfull wp-block-section">
	<!-- wp:media-text {"mediaLink":"<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/featured-services.jpg' ) ); ?>","mediaType":"image"} -->
	<div class="wp-block-media-text alignwide is-stacked-on-mobile">
		<figure class="wp-block-media-text__media"><img src="<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/featured-services.jpg' ) ); ?>" alt="" /></figure>
		<div class="wp-block-media-text__content">
			<!-- wp:group {"align":"wide","style":{"spacing":{"blockGap":"14px"}},"className":"alignwide wp-block-group-heading"} -->
			<div class="wp-block-group alignwide wp-block-group-heading"><!-- wp:heading {"textAlign":"left","level":6,"style":{"typography":{"textTransform":"uppercase","fontStyle":"normal","fontWeight":"700","lineHeight":1.8}},"textColor":"primary","fontSize":"extra-small","fontFamily":"open-sans"} -->
				<h6 class="wp-block-heading has-text-align-left has-primary-color has-text-color has-open-sans-font-family has-extra-small-font-size" style="font-style:normal;font-weight:700;line-height:1.8;text-transform:uppercase"><?php esc_html_e('Quick Contact', 'signify-blocks-pro'); ?></h6>
				<!-- /wp:heading -->

				<!-- wp:heading {"textAlign":"left","fontSize":"product-heading"} -->
				<h2 class="wp-block-heading has-text-align-left has-product-heading-font-size"><?php esc_html_e('Start your project with us?', 'signify-blocks-pro'); ?></h2>
				<!-- /wp:heading -->

				<!-- wp:paragraph {"align":"left"} -->
				<p class="has-text-align-left"><?php esc_html_e('An online quick contact form is a quick and easy way to collect information from website visitors.', 'signify-blocks-pro'); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:group -->
			<!-- wp:contact-form-7/contact-form-selector {"id":22630,"title":"Contact form 1"} -->
			<div class="wp-block-contact-form-7-contact-form-selector">[contact-form-7 id="22630" title="Contact form 1"]</div>
			<!-- /wp:contact-form-7/contact-form-selector -->
		</div>
	</div>
	<!-- /wp:media-text -->
</div>
<!-- /wp:group -->
