<?php

/**
 * Title: Quick Contact
 * Slug: signify-blocks/quick-contact
 * Categories: signify-blocks, page
 */
?>

<!-- wp:cover {"url":"<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/promotional-headline.jpg' ) ); ?>","dimRatio":0,"align":"full","className":"wp-block-section wp-block-quick-contact"} -->
<div class="wp-block-cover alignfull wp-block-section wp-block-quick-contact">
	<span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim"></span>
	<img class="wp-block-cover__image-background" alt="" src="<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/promotional-headline.jpg' ) ); ?>" data-object-fit="cover" />
	<div class="wp-block-cover__inner-container">
		<!-- wp:group {"layout":{"inherit":true}} -->
		<div class="wp-block-group">
			<!-- wp:group {"align":"wide"} -->
			<div class="wp-block-group alignwide">
				<!-- wp:columns {"align":"wide"} -->
				<div class="wp-block-columns alignwide">
					<!-- wp:column {"width":"70%"} -->
					<div class="wp-block-column" style="flex-basis: 70%;">
						<!-- wp:group {"align":"wide","style":{"spacing":{"blockGap":"14px"}},"className":"alignwide wp-block-group-heading"} -->
						<div class="wp-block-group alignwide wp-block-group-heading"><!-- wp:heading {"textAlign":"left","level":6,"style":{"typography":{"textTransform":"uppercase","fontStyle":"normal","fontWeight":"700","lineHeight":1.8}},"textColor":"primary","fontSize":"extra-small","fontFamily":"open-sans"} -->
							<h6 class="wp-block-heading has-text-align-left has-primary-color has-text-color has-open-sans-font-family has-extra-small-font-size" style="font-style:normal;font-weight:700;line-height:1.8;text-transform:uppercase"><?php esc_html_e('Quick Contact', 'signify-blocks-pro'); ?></h6>
							<!-- /wp:heading -->

							<!-- wp:heading {"textAlign":"left","fontSize":"product-heading"} -->
							<h2 class="wp-block-heading has-text-align-left has-product-heading-font-size"><?php esc_html_e('We like to start your project with us', 'signify-blocks-pro'); ?></h2>
							<!-- /wp:heading -->

							<!-- wp:paragraph {"align":"left"} -->
							<p class="has-text-align-left"><?php esc_html_e('You can manage it from front page in site editor.', 'signify-blocks-pro'); ?></p>
							<!-- /wp:paragraph -->
						</div>
						<!-- /wp:group -->
					</div>
					<!-- /wp:column -->
					<!-- wp:column {"width":"30%"} -->
					<div class="wp-block-column" style="flex-basis: 30%;">
						<!-- wp:group -->
						<div class="wp-block-group">
							<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"right"}} -->
							<div class="wp-block-buttons">
								<!-- wp:button -->
								<div class="wp-block-button">
									<a class="wp-block-button__link"><?php esc_html_e('Get Started', 'signify-blocks-pro'); ?></a>
								</div>
								<!-- /wp:button -->
							</div>
							<!-- /wp:buttons -->
						</div>
						<!-- /wp:group -->
					</div>
					<!-- /wp:column -->
				</div>
				<!-- /wp:columns -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:group -->
	</div>
</div>
<!-- /wp:cover -->
