<?php

/**
 * Title: Services Default
 * Slug: signify-blocks/services-default
 * Categories: signify-blocks, page
 */
?>

<!-- wp:group {"align":"full","className":"wp-block-section wp-block-services-default","layout":{"inherit":true,"type":"constrained"}} -->
<div class="wp-block-group alignfull wp-block-section wp-block-services-default"><!-- wp:group {"align":"wide","style":{"spacing":{"blockGap":"14px"}},"className":"alignwide wp-block-group-heading"} -->
	<div class="wp-block-group alignwide wp-block-group-heading"><!-- wp:heading {"textAlign":"center","level":6,"style":{"typography":{"textTransform":"uppercase","fontStyle":"normal","fontWeight":"700","lineHeight":1.8}},"textColor":"primary","fontSize":"extra-small","fontFamily":"open-sans"} -->
		<h6 class="wp-block-heading has-text-align-center has-primary-color has-text-color has-open-sans-font-family has-extra-small-font-size" style="font-style:normal;font-weight:700;line-height:1.8;text-transform:uppercase"><?php esc_html_e('What We Do', 'signify-blocks-pro'); ?></h6>
		<!-- /wp:heading -->

		<!-- wp:heading {"textAlign":"center","fontSize":"product-heading"} -->
		<h2 class="wp-block-heading has-text-align-center has-product-heading-font-size"><?php esc_html_e('Amazing Services', 'signify-blocks-pro'); ?></h2>
		<!-- /wp:heading -->

		<!-- wp:paragraph {"align":"center"} -->
		<p class="has-text-align-center"><?php esc_html_e('You can manage it from front page in site editor.', 'signify-blocks-pro'); ?></p>
		<!-- /wp:paragraph -->
	</div>
	<!-- /wp:group -->

	<!-- wp:group {"align":"wide","className":"wp-block-group-content"} -->
	<div class="wp-block-group alignwide wp-block-group-content"><!-- wp:columns {"align":"wide"} -->
		<div class="wp-block-columns alignwide"><!-- wp:column -->
			<div class="wp-block-column"><!-- wp:group {"className":"wp-block-post-group"} -->
				<div class="wp-block-group wp-block-post-group"><!-- wp:image {"align":"center","sizeSlug":"full","linkDestination":"none"} -->
					<figure class="wp-block-image aligncenter size-full"><img src="<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/service-icon-1.png' ) ); ?>" alt="" /></figure>
					<!-- /wp:image -->

					<!-- wp:group {"className":"wp-block-entry-content"} -->
					<div class="wp-block-group wp-block-entry-content"><!-- wp:heading {"textAlign":"center","style":{"typography":{"fontStyle":"normal","fontWeight":"700"}},"fontSize":"content-heading"} -->
						<h2 class="wp-block-heading has-text-align-center has-content-heading-font-size" style="font-style:normal;font-weight:700"><?php esc_html_e('Haute Couture', 'signify-blocks-pro'); ?></h2>
						<!-- /wp:heading -->

						<!-- wp:paragraph {"align":"center"} -->
						<p class="has-text-align-center"><?php esc_html_e('We use high-quality garments and accessories that are crafted with exceptional skill and attention to detail.', 'signify-blocks-pro'); ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
						<div class="wp-block-buttons"><!-- wp:button {"className":"is-style-outline"} -->
							<div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button"><?php esc_html_e('read More', 'signify-blocks-pro'); ?></a></div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column -->
			<div class="wp-block-column"><!-- wp:group {"className":"wp-block-post-group"} -->
				<div class="wp-block-group wp-block-post-group"><!-- wp:image {"align":"center","sizeSlug":"full","linkDestination":"none"} -->
					<figure class="wp-block-image aligncenter size-full"><img src="<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/service-icon-2.png' ) ); ?>" alt="" /></figure>
					<!-- /wp:image -->

					<!-- wp:group {"className":"wp-block-entry-content"} -->
					<div class="wp-block-group wp-block-entry-content"><!-- wp:heading {"textAlign":"center","style":{"typography":{"fontStyle":"normal","fontWeight":"700"}},"fontSize":"content-heading"} -->
						<h2 class="wp-block-heading has-text-align-center has-content-heading-font-size" style="font-style:normal;font-weight:700"><?php esc_html_e('Online', 'signify-blocks-pro'); ?></h2>
						<!-- /wp:heading -->

						<!-- wp:paragraph {"align":"center"} -->
						<p class="has-text-align-center"><?php esc_html_e('We bring our solutions and expertise directly to you. So, explore our range of online services.', 'signify-blocks-pro'); ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
						<div class="wp-block-buttons"><!-- wp:button {"className":"is-style-outline"} -->
							<div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button"><?php esc_html_e('Read More', 'signify-blocks-pro'); ?></a></div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column -->
			<div class="wp-block-column"><!-- wp:group {"className":"wp-block-post-group"} -->
				<div class="wp-block-group wp-block-post-group"><!-- wp:image {"align":"center","sizeSlug":"full","linkDestination":"none"} -->
					<figure class="wp-block-image aligncenter size-full"><img src="<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/service-icon-3.png' ) ); ?>" alt="" /></figure>
					<!-- /wp:image -->

					<!-- wp:group {"className":"wp-block-entry-content"} -->
					<div class="wp-block-group wp-block-entry-content"><!-- wp:heading {"textAlign":"center","style":{"typography":{"fontStyle":"normal","fontWeight":"700"}},"fontSize":"content-heading"} -->
						<h2 class="wp-block-heading has-text-align-center has-content-heading-font-size" style="font-style:normal;font-weight:700"><?php esc_html_e('Fast Delivery', 'signify-blocks-pro'); ?></h2>
						<!-- /wp:heading -->

						<!-- wp:paragraph {"align":"center"} -->
						<p class="has-text-align-center"><?php esc_html_e('We prioritize efficiency and speed to ensure that your needs are met promptly and timely. We value your satisfaction.', 'signify-blocks-pro'); ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
						<div class="wp-block-buttons"><!-- wp:button {"className":"is-style-outline"} -->
							<div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button"><?php esc_html_e('Read More', 'signify-blocks-pro'); ?></a></div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:column -->
		</div>
		<!-- /wp:columns -->
	</div>
	<!-- /wp:group -->
</div>
<!-- /wp:group -->
