<?php

/**
 * Title: Subscribe
 * Slug: signify-blocks/subscribe
 * Categories: signify-blocks, page
 */
?>

<!-- wp:cover {"url":"<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/header-media-bg.jpg' ) ); ?>","dimRatio":20,"align":"full","className":"wp-block-section wp-block-subscribe"} -->
<div class="wp-block-cover alignfull wp-block-section wp-block-subscribe">
	<span aria-hidden="true" class="wp-block-cover__background has-background-dim-20 has-background-dim"></span>
	<img class="wp-block-cover__image-background" alt="" src="<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/header-media-bg.jpg' ) ); ?>" data-object-fit="cover" />
	<div class="wp-block-cover__inner-container">
		<!-- wp:group {"layout":{"inherit":true}} -->
		<div class="wp-block-group">
			<!-- wp:group {"align":"wide","className":"wp-block-subscribe"} -->
			<div class="wp-block-group alignwide wp-block-subscribe">
				<!-- wp:columns {"align":"wide"} -->
				<div class="wp-block-columns alignwide">
					<!-- wp:column -->
					<div class="wp-block-column">
						<!-- wp:group {"align":"wide","style":{"spacing":{"blockGap":"14px"}},"className":"alignwide wp-block-group-heading"} -->
						<div class="wp-block-group alignwide wp-block-group-heading"><!-- wp:heading {"textAlign":"left","level":6,"style":{"typography":{"textTransform":"uppercase","fontStyle":"normal","fontWeight":"700","lineHeight":1.8}},"textColor":"primary","fontSize":"extra-small","fontFamily":"open-sans"} -->
							<h6 class="wp-block-heading has-text-align-left has-primary-color has-text-color has-open-sans-font-family has-extra-small-font-size" style="font-style:normal;font-weight:700;line-height:1.8;text-transform:uppercase"><?php esc_html_e('Subscribe Now', 'signify-blocks-pro'); ?></h6>
							<!-- /wp:heading -->

							<!-- wp:heading {"textAlign":"left","fontSize":"product-heading"} -->
							<h2 class="wp-block-heading has-text-align-left has-product-heading-font-size"><?php esc_html_e('Support the show on patreon.', 'signify-blocks-pro'); ?></h2>
							<!-- /wp:heading -->

							<!-- wp:paragraph {"align":"left"} -->
							<p class="has-text-align-left"><?php esc_html_e('You can manage it from front page in site editor.', 'signify-blocks-pro'); ?></p>
							<!-- /wp:paragraph -->
						</div>
						<!-- /wp:group -->
					</div>
					<!-- /wp:column -->
					<!-- wp:column -->
					<div class="wp-block-column">
						<!-- wp:group -->
						<div class="wp-block-group">
							<!-- wp:tnp/minimal {"padding":0} -->
							<div style="padding: 0;" class="wp-block-tnp-minimal">
								<p></p>
								<div>[newsletter_form type="minimal"]</div>
							</div>
							<!-- /wp:tnp/minimal -->
						</div>
						<!-- /wp:group -->
					</div>
					<!-- /wp:column -->
				</div>
				<!-- /wp:columns -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:group -->
	</div>
</div>
<!-- /wp:cover -->
