<?php

/**
 * Title: Team
 * Slug: signify-blocks/team
 * Categories: signify-blocks, page
 */
?>

<!-- wp:group {"align":"full","className":"wp-block-section wp-block-team","layout":{"inherit":true,"type":"constrained"}} -->
<div class="wp-block-group alignfull wp-block-section wp-block-team">
	<!-- wp:group {"align":"wide","style":{"spacing":{"blockGap":"14px"}},"className":"alignwide wp-block-group-heading"} -->
	<div class="wp-block-group alignwide wp-block-group-heading"><!-- wp:heading {"textAlign":"center","level":6,"style":{"typography":{"textTransform":"uppercase","fontStyle":"normal","fontWeight":"700","lineHeight":1.8}},"textColor":"primary","fontSize":"extra-small","fontFamily":"open-sans"} -->
		<h6 class="wp-block-heading has-text-align-center has-primary-color has-text-color has-open-sans-font-family has-extra-small-font-size" style="font-style:normal;font-weight:700;line-height:1.8;text-transform:uppercase"><?php esc_html_e('Our Team', 'signify-blocks-pro'); ?></h6>
		<!-- /wp:heading -->

		<!-- wp:heading {"textAlign":"center","fontSize":"product-heading"} -->
		<h2 class="wp-block-heading has-text-align-center has-product-heading-font-size"><?php esc_html_e('Awesome Members', 'signify-blocks-pro'); ?></h2>
		<!-- /wp:heading -->

		<!-- wp:paragraph {"align":"center"} -->
		<p class="has-text-align-center"><?php esc_html_e('You can manage it from front page in site editor.', 'signify-blocks-pro'); ?></p>
		<!-- /wp:paragraph -->
	</div>
	<!-- /wp:group -->

	<!-- wp:group {"align":"full","className":"wp-block-group-content"} -->
	<div class="wp-block-group alignfull wp-block-group-content">
		<!-- wp:columns {"align":"full","className":"is-style-have-gap-0"} -->
		<div class="wp-block-columns alignfull is-style-have-gap-0">
			<!-- wp:column -->
			<div class="wp-block-column">
				<!-- wp:group {"style":{"spacing":{"blockGap":"0px"}},"className":"wp-block-post-group"} -->
				<div class="wp-block-group wp-block-post-group">
					<!-- wp:image {"sizeSlug":"full","linkDestination":"none","className":"size-full"} -->
					<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/team-1.jpg' ) ); ?>" alt="" /></figure>
					<!-- /wp:image -->

					<!-- wp:group {"style":{"spacing":{"blockGap":"2px"}},"className":"wp-block-entry-content"} -->
					<div class="wp-block-group wp-block-entry-content">
						<!-- wp:heading {"style":{"typography":{"fontStyle":"normal","fontWeight":"500"}},"textColor":"color-light","fontSize":"normal"} -->
						<h2 class="has-color-light-color has-text-color has-normal-font-size" style="font-style: normal; font-weight: 500;"><?php esc_html_e('Hugo Jackman', 'signify-blocks-pro'); ?></h2>
						<!-- /wp:heading -->

						<!-- wp:paragraph {"textColor":"primary","fontSize":"medium"} -->
						<p class="has-primary-color has-text-color has-medium-font-size"><?php esc_html_e('Founder / CEO', 'signify-blocks-pro'); ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:buttons -->
						<div class="wp-block-buttons">
							<!-- wp:button {"className":"is-style-outline"} -->
							<div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button"><?php esc_html_e('Read More ?', 'signify-blocks-pro'); ?></a></div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column -->
			<div class="wp-block-column">
				<!-- wp:group {"style":{"spacing":{"blockGap":"0px"}},"className":"wp-block-post-group"} -->
				<div class="wp-block-group wp-block-post-group">
					<!-- wp:image {"sizeSlug":"full","linkDestination":"none","className":"size-full"} -->
					<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/team-2.jpg' ) ); ?>" alt="" /></figure>
					<!-- /wp:image -->

					<!-- wp:group {"style":{"spacing":{"blockGap":"2px"}},"className":"wp-block-entry-content"} -->
					<div class="wp-block-group wp-block-entry-content">
						<!-- wp:heading {"style":{"typography":{"fontStyle":"normal","fontWeight":"500"}},"textColor":"color-light","fontSize":"normal"} -->
						<h2 class="has-color-light-color has-text-color has-normal-font-size" style="font-style: normal; font-weight: 500;"><?php esc_html_e('John Smith', 'signify-blocks-pro'); ?></h2>
						<!-- /wp:heading -->

						<!-- wp:paragraph {"textColor":"primary","fontSize":"medium"} -->
						<p class="has-primary-color has-text-color has-medium-font-size"><?php esc_html_e('Creative Designer', 'signify-blocks-pro'); ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:buttons -->
						<div class="wp-block-buttons">
							<!-- wp:button {"className":"is-style-outline"} -->
							<div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button"><?php esc_html_e('Read More ?', 'signify-blocks-pro'); ?></a></div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column -->
			<div class="wp-block-column">
				<!-- wp:group {"style":{"spacing":{"blockGap":"0px"}},"className":"wp-block-post-group"} -->
				<div class="wp-block-group wp-block-post-group">
					<!-- wp:image {"sizeSlug":"full","linkDestination":"none","className":"size-full"} -->
					<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/team-3.jpg' ) ); ?>" alt="" /></figure>
					<!-- /wp:image -->

					<!-- wp:group {"style":{"spacing":{"blockGap":"2px"}},"className":"wp-block-entry-content"} -->
					<div class="wp-block-group wp-block-entry-content">
						<!-- wp:heading {"style":{"typography":{"fontStyle":"normal","fontWeight":"500"}},"textColor":"color-light","fontSize":"normal"} -->
						<h2 class="has-color-light-color has-text-color has-normal-font-size" style="font-style: normal; font-weight: 500;"><?php esc_html_e('Jack Watson', 'signify-blocks-pro'); ?></h2>
						<!-- /wp:heading -->

						<!-- wp:paragraph {"textColor":"primary","fontSize":"medium"} -->
						<p class="has-primary-color has-text-color has-medium-font-size"><?php esc_html_e('Developer', 'signify-blocks-pro'); ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:buttons -->
						<div class="wp-block-buttons">
							<!-- wp:button {"className":"is-style-outline"} -->
							<div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button"><?php esc_html_e('Read More ?', 'signify-blocks-pro'); ?></a></div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column -->
			<div class="wp-block-column">
				<!-- wp:group {"style":{"spacing":{"blockGap":"0px"}},"className":"wp-block-post-group"} -->
				<div class="wp-block-group wp-block-post-group">
					<!-- wp:image {"sizeSlug":"full","linkDestination":"none","className":"size-full"} -->
					<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/team-4.jpg' ) ); ?>" alt="" /></figure>
					<!-- /wp:image -->

					<!-- wp:group {"style":{"spacing":{"blockGap":"2px"}},"className":"wp-block-entry-content"} -->
					<div class="wp-block-group wp-block-entry-content">
						<!-- wp:heading {"style":{"typography":{"fontStyle":"normal","fontWeight":"500"}},"textColor":"color-light","fontSize":"normal"} -->
						<h2 class="has-color-light-color has-text-color has-normal-font-size" style="font-style: normal; font-weight: 500;"><?php esc_html_e('Cindy Coleman', 'signify-blocks-pro'); ?></h2>
						<!-- /wp:heading -->

						<!-- wp:paragraph {"textColor":"primary","fontSize":"medium"} -->
						<p class="has-primary-color has-text-color has-medium-font-size"><?php esc_html_e('Marketing Manager', 'signify-blocks-pro'); ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:buttons -->
						<div class="wp-block-buttons">
							<!-- wp:button {"className":"is-style-outline"} -->
							<div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button"><?php esc_html_e('Read More ?', 'signify-blocks-pro'); ?></a></div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:column -->
		</div>
		<!-- /wp:columns -->
	</div>
	<!-- /wp:group -->
</div>
<!-- /wp:group -->
