<?php

/**
 * Title: Testimonials
 * Slug: signify-blocks/testimonials
 * Categories: signify-blocks, page
 */
?>

<!-- wp:group {"align":"full","className":"wp-block-section wp-block-clients-testimonial","layout":{"inherit":true,"type":"constrained"}} -->
<div class="wp-block-group alignfull wp-block-section wp-block-clients-testimonial"><!-- wp:group {"align":"wide"} -->
	<div class="wp-block-group alignwide"><!-- wp:group {"align":"wide","style":{"spacing":{"blockGap":"14px"}},"className":"alignwide wp-block-group-heading"} -->
		<div class="wp-block-group alignwide wp-block-group-heading"><!-- wp:heading {"textAlign":"center","level":6,"style":{"typography":{"textTransform":"uppercase","fontStyle":"normal","fontWeight":"700","lineHeight":1.8}},"textColor":"primary","fontSize":"extra-small","fontFamily":"open-sans"} -->
			<h6 class="wp-block-heading has-text-align-center has-primary-color has-text-color has-open-sans-font-family has-extra-small-font-size" style="font-style:normal;font-weight:700;line-height:1.8;text-transform:uppercase"><?php esc_html_e('Client Testimonials', 'signify-blocks-pro'); ?></h6>
			<!-- /wp:heading -->

			<!-- wp:heading {"textAlign":"center","fontSize":"product-heading"} -->
			<h2 class="wp-block-heading has-text-align-center has-product-heading-font-size"><?php esc_html_e('What People Says', 'signify-blocks-pro'); ?></h2>
			<!-- /wp:heading -->
		</div>
		<!-- /wp:group -->

		<!-- wp:group {"className":"wp-block-group-content-container","layout":{"type":"constrained"}} -->
		<div class="wp-block-group wp-block-group-content-container"><!-- wp:signify-blocks-pro/slider {"controls":false,"dot":false,"dotPosition":"horizontal-outside-slider-bottom-center"} -->
			<div class="wp-block-signify-blocks-pro-slider signify-blocks-pro-slider" data-slider="{&quot;slidesPerPage&quot;:1,&quot;controls&quot;:false,&quot;autoplay&quot;:true,&quot;spaceBetween&quot;:0,&quot;dot&quot;:false,&quot;axis&quot;:&quot;horizontal&quot;,&quot;slideBy&quot;:1,&quot;center&quot;:false}"><!-- wp:signify-blocks-pro/slides -->
				<div class="wp-block-signify-blocks-pro-slides"><!-- wp:group {"style":{"spacing":{"padding":{"top":"50px"}}},"className":"wp-block-group-content","layout":{"type":"constrained","contentSize":"620px"}} -->
					<div class="wp-block-group wp-block-group-content" style="padding-top:50px"><!-- wp:paragraph {"align":"center"} -->
						<p class="has-text-align-center"><?php esc_html_e('The University offers a fantastic academic environment, seminars, interdisciplinary initiatives, as well as a remarkable library and sport facility. For these reasons, I would heartily recommend the university to other students.', 'signify-blocks-pro'); ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:group {"style":{"spacing":{"blockGap":"20px"}},"layout":{"type":"constrained"}} -->
						<div class="wp-block-group"><!-- wp:group {"style":{"spacing":{"blockGap":"2px"}},"layout":{"type":"constrained"}} -->
							<div class="wp-block-group"><!-- wp:heading {"textAlign":"center","style":{"typography":{"textTransform":"capitalize"}},"textColor":"foreground","fontSize":"content-heading","fontFamily":"open-sans"} -->
								<h2 class="wp-block-heading has-text-align-center has-foreground-color has-text-color has-open-sans-font-family has-content-heading-font-size" style="text-transform:capitalize"><?php esc_html_e('Joe Gardner', 'signify-blocks-pro'); ?></h2>
								<!-- /wp:heading -->

								<!-- wp:paragraph {"align":"center","style":{"typography":{"textTransform":"capitalize"}},"textColor":"foreground","fontSize":"extra-small"} -->
								<p class="has-text-align-center has-foreground-color has-text-color has-extra-small-font-size" style="text-transform:capitalize"><?php esc_html_e('Manager, XYZ Company', 'signify-blocks-pro'); ?></p>
								<!-- /wp:paragraph -->
							</div>
							<!-- /wp:group -->

							<!-- wp:image {"align":"center","width":75,"height":75,"sizeSlug":"full","linkDestination":"none","className":"is-style-rounded"} -->
							<figure class="wp-block-image aligncenter size-full is-resized is-style-rounded"><img src="<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/testimonials-1.jpg' ) ); ?>" alt="" width="75" height="75" /></figure>
							<!-- /wp:image -->
						</div>
						<!-- /wp:group -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:signify-blocks-pro/slides -->

				<!-- wp:signify-blocks-pro/slides -->
				<div class="wp-block-signify-blocks-pro-slides"><!-- wp:group {"style":{"spacing":{"padding":{"top":"50px"}}},"className":"wp-block-group-content","layout":{"type":"constrained","contentSize":"620px"}} -->
					<div class="wp-block-group wp-block-group-content" style="padding-top:50px"><!-- wp:paragraph {"align":"center"} -->
						<p class="has-text-align-center"><?php esc_html_e('Wonderful dining experience. The food and service was great, not to mention the atmosphere felt like we were at a big family dinner. The food and service was great.', 'signify-blocks-pro'); ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:group {"style":{"spacing":{"blockGap":"20px"}},"layout":{"type":"constrained"}} -->
						<div class="wp-block-group"><!-- wp:group {"style":{"spacing":{"blockGap":"2px"}},"layout":{"type":"constrained"}} -->
							<div class="wp-block-group"><!-- wp:heading {"textAlign":"center","style":{"typography":{"textTransform":"capitalize"}},"textColor":"foreground","fontSize":"content-heading","fontFamily":"open-sans"} -->
								<h2 class="wp-block-heading has-text-align-center has-foreground-color has-text-color has-open-sans-font-family has-content-heading-font-size" style="text-transform:capitalize"><?php esc_html_e('Alica Keys', 'signify-blocks-pro'); ?></h2>
								<!-- /wp:heading -->

								<!-- wp:paragraph {"align":"center","style":{"typography":{"textTransform":"capitalize"}},"textColor":"foreground","fontSize":"extra-small"} -->
								<p class="has-text-align-center has-foreground-color has-text-color has-extra-small-font-size" style="text-transform:capitalize"><?php esc_html_e('Design, ABC Company', 'signify-blocks-pro'); ?></p>
								<!-- /wp:paragraph -->
							</div>
							<!-- /wp:group -->

							<!-- wp:image {"align":"center","width":75,"height":75,"sizeSlug":"full","linkDestination":"none","className":"is-style-rounded"} -->
							<figure class="wp-block-image aligncenter size-full is-resized is-style-rounded"><img src="<?php echo esc_url( get_parent_theme_file_uri( '/assets/images/testimonials-2.jpg' ) ); ?>" alt="" width="75" height="75" /></figure>
							<!-- /wp:image -->
						</div>
						<!-- /wp:group -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:signify-blocks-pro/slides -->
			</div>
			<!-- /wp:signify-blocks-pro/slider -->
		</div>
		<!-- /wp:group -->
	</div>
	<!-- /wp:group -->
</div>
<!-- /wp:group -->
