<?php
/**
 * Template Name: About Us Template                                            
 * The template for displaying about us page.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Travel Insight Pro 1.0
 */

get_header(); 
$options = travel_insight_pro_get_theme_options();
?>
<div class="wrapper page-section no-padding-bottom">
	<main id="main" class="site-main" role="main">
		
		<?php while ( have_posts() ) : the_post(); ?>

			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
				<div class="about">
					<?php if ( ! empty( $options['about_us_template_quote'] ) ) : ?>
						<header class="entry-header">
							<h2 class="entry-title"><?php echo esc_html( $options['about_us_template_quote'] ); ?></h2>
						</header><!-- .entry-header -->
					<?php endif; ?>
					<div class="entry-content">
						<?php the_content(); ?>
					</div><!-- .entry-content -->
				</div><!--.about-->
			</article><!--#post-1-->

		<?php 
		endwhile; // End of the loop. 

		/**
		 * travel_insight_pro_about_us_template_content_action hook
		 *
		 * @hooked travel_insight_pro_add_about_us_template_slider -  10
		 */
		do_action( 'travel_insight_pro_about_us_template_content_action' );
		?>


	</main><!-- #main -->
</div>
<?php
get_footer();