<?php
/**
 * Template Name: Contact Us Template                                            
 * The template for displaying about us page.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Travel Insight Pro 1.0
 */

get_header(); 
$options = travel_insight_pro_get_theme_options();
?>
<section id="connect" class="page-section">
	<div class="wrapper">
		<div class="text-center">
			<?php  
			while ( have_posts() ) : the_post();
				the_content();
			endwhile;
			?>
		</div>

		<div class="entry-content col-3">
			<?php 
			if ( is_active_sidebar( 'travel-insight-pro-contact-sidebar' ) )
				dynamic_sidebar( 'travel-insight-pro-contact-sidebar' );
			?>
		</div><!-- .entry-content -->
	</div><!-- .wrapper -->
</section><!-- #connect -->

<section id="location-details" class="col-2">
    <div class="wrapper">
        <?php
        /**
         * travel_insight_pro_contact_map_action hook
         *
         * @hooked travel_insight_pro_contact_map -  10
         *
         */
        do_action( 'travel_insight_pro_contact_map_action' ); 

        /**
         * travel_insight_pro_contact_form_action hook
         *
         * @hooked travel_insight_pro_contact_form -  10
         *
         */
        do_action( 'travel_insight_pro_contact_form_action' ); 
        ?>
    </div><!-- .wrapper -->
</section><!-- #location-details -->
<?php
get_footer();