<?php
/**
 * Template Name: Gallery Template                                            
 * The template for displaying about us page.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Travel Insight Pro 1.0
 */

get_header(); 
$options = travel_insight_pro_get_theme_options();
$categories_id = get_post_meta( $post->ID, 'travel-insight-pro-gallery-template', true ); 
$categories_id = ! empty( $categories_id ) ? $categories_id : array();
?>

<section id="portfolio">
	<nav class="portfolio-filter">
		<div class="wrapper">
			<ul>
				<li class="active"><a href="#" data-filter="*"><?php esc_html_e( 'All', 'travel-insight-pro' ); ?></a></li>
				<?php foreach ( $categories_id as $key => $category_id ) {
                    $category_object = get_category( $category_id );
                    echo '<li><a href="#" data-filter=".'. esc_attr( $category_object->slug ) .'">'. esc_html( $category_object->name ) .'</a></li>';
                } ?>
			</ul>
		</div><!-- .wrapper -->
	</nav><!-- .portfolio-filter -->

	<?php  
    $gallery_args = array(
        'post_type'      => 'post',
        'category__in'   => $categories_id,
        'posts_per_page' => 12,
    );
    $i = 1;
    $posts = get_posts( $gallery_args );
    ?>

	<div id="gallery-wrapper">
		<div class="wrapper">
			<div class="portfolio gallery-popup">
				<?php foreach ( $posts as $post ) :
					$post_id = $post->ID;
					if ( ! has_post_thumbnail( $post_id ) ) { 
						$i = $i-1; 
					}
					if ( $i == 11 ) { 
						$i = 1;
					}
                    if ( has_post_thumbnail( $post_id ) ) :
                        if ( in_array( $i, array( 2, 7, 10 ) ) ) :
                            $img_array = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'post-thumbnail' );
                        else :
                            $img_array = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'travel-insight-pro-portrait' );
                        endif;
	                    $img_array_lg = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'full' );

	                    $post_title = get_the_title( $post_id );
	                    $post_url = get_the_permalink( $post_id ); 
	                    $post_categories = get_the_category( $post_id );

	                    $post_category_list = '';
	                    foreach ( $post_categories as $post_category ) {
	                        $post_category_list .= $post_category->slug . ' ';
	                    }
						?>
						<div class="portfolio-item item-w1 <?php echo esc_attr( $post_category_list ); ?>">
							<div class="featured-image">
								<a href="<?php echo esc_url( $img_array_lg[0] ); ?>" class="popup">
									<img src="<?php echo esc_url( $img_array[0] ); ?>" alt="<?php echo esc_attr( $post_title ); ?>">
								</a>
								<div class="portfolio-hover-effect">
									<p><a href="<?php echo esc_url( $post_url ); ?>"><?php echo esc_html( $post_title ); ?></a></p>
								</div><!-- .portfolio-hover-effect -->
							</div><!-- .featured-image -->
						</div><!-- .portfolio-item -->
					<?php endif; $i++;
				endforeach; ?>
			</div><!-- .portfolio -->
		</div><!-- .wrapper -->
	</div><!-- #gallery -->
</section><!-- #portfolio -->
<?php
get_footer();