<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

$options = travel_insight_pro_get_theme_options();
$footer_bg = ! empty( $options['footer_background'] ) ? $options['footer_background'] : get_template_directory_uri() . '/assets/uploads/bg-footer.png';

/**
 * travel_insight_pro_content_end_action hook
 *
 * @hooked travel_insight_pro_content_end -  10
 *
 */
do_action( 'travel_insight_pro_content_end_action' );
?>
<footer id="colophon" class="site-footer page-section no-padding-bottom" style="background-image:url('<?php echo esc_url( $footer_bg ); ?> ')">
	<?php  
	/**
	 * travel_insight_pro_footer hook
	 *
	 * @hooked travel_insight_pro_footer_widget -  10
	 * @hooked travel_insight_pro_footer_site_info -  20
	 *
	 */
	do_action( 'travel_insight_pro_footer' ); 
	?>
</footer><!-- #colophon -->
	
<?php
/**
 * travel_insight_pro_page_end_action hook
 *
 * @hooked travel_insight_pro_page_end -  10
 *
 */
do_action( 'travel_insight_pro_page_end_action' ); 
?>

<?php wp_footer(); ?>

</body>
</html>
