<?php
/**
 * Customizer active callbacks
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

if ( ! function_exists( 'travel_insight_pro_is_pagination_enable' ) ) :
	/**
	 * Check if pagination is enabled.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_is_pagination_enable( $control ) {
		return $control->manager->get_setting( 'travel_insight_pro_theme_options[pagination_enable]' )->value();
	}
endif;

if ( ! function_exists( 'travel_insight_pro_is_footer_logo_enable' ) ) :
	/**
	 * Check if footer logo is enabled.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_is_footer_logo_enable( $control ) {
		return $control->manager->get_setting( 'travel_insight_pro_theme_options[footer_logo_enable]' )->value();
	}
endif;

if ( ! function_exists( 'travel_insight_pro_is_slider_enable' ) ) :
	/**
	 * Check if slider is enabled.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_is_slider_enable( $control ) {
		return $control->manager->get_setting( 'travel_insight_pro_theme_options[slider_enable]' )->value();
	}
endif;

if ( ! function_exists( 'travel_insight_pro_is_slider_wp_travel_enable' ) ) :
	/**
	 * Check if slider is enabled.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_is_slider_wp_travel_enable( $control ) {
		return ( $control->manager->get_setting( 'travel_insight_pro_theme_options[slider_wp_travel_filter_enable]' )->value() && class_exists( 'WP_Travel' ) );
	}
endif;

if ( ! function_exists( 'travel_insight_pro_slider_count' ) ) :
	/**
	 * Check if slider content is not demo or post.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_slider_count( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[slider_content_type]' )->value();
		if ( travel_insight_pro_is_slider_enable( $control ) && 'demo' != $content_type && 'post' != $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_slider_content_post' ) ) :
	/**
	 * Check if slider content is post.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_slider_content_post( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[slider_content_type]' )->value();
		if ( travel_insight_pro_is_slider_enable( $control ) && 'post' === $content_type )
			return true;
		else
			return false;
	}
endif;


if ( ! function_exists( 'travel_insight_pro_slider_content_category' ) ) :
	/**
	 * Check if slider content is category.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_slider_content_category( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[slider_content_type]' )->value();
		if ( travel_insight_pro_is_slider_enable( $control ) && 'category' === $content_type )
			return true;
		else
			return false;
	}
endif;

/**
 * Check if slider content type is product.
 *
 * @since Travel Insight Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function travel_insight_pro_is_slider_section_content_product( $control ) {
	$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[slider_content_type]' )->value();
	return ( travel_insight_pro_is_slider_enable( $control ) && 'product' == $content_type );
}

/**
 * Check if slider content type is product category.
 *
 * @since Travel Insight Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function travel_insight_pro_is_slider_section_content_product_category( $control ) {
	$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[slider_content_type]' )->value();
	return ( travel_insight_pro_is_slider_enable( $control ) && 'product-category' == $content_type );
}


if ( ! function_exists( 'travel_insight_pro_slider_content_page' ) ) :
	/**
	 * Check if slider content is page.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_slider_content_page( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[slider_content_type]' )->value();
		if ( travel_insight_pro_is_slider_enable( $control ) && 'page' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_slider_content_custom' ) ) :
	/**
	 * Check if slider content is custom.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_slider_content_custom( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[slider_content_type]' )->value();
		if ( travel_insight_pro_is_slider_enable( $control ) && 'custom' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_slider_layout_normal_custom' ) ) :
	/**
	 * Check if slider content is custom and slider layout is normal.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_slider_layout_normal_custom( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[slider_content_type]' )->value();
		$slider_layout = $control->manager->get_setting( 'travel_insight_pro_theme_options[slider_layout]' )->value();
		if ( travel_insight_pro_is_slider_enable( $control ) && 'normal-slider' == $slider_layout && 'custom' == $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_slider_layout_sticky' ) ) :
	/**
	 * Check if slider layout is sticky slider.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_slider_layout_sticky( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[slider_layout]' )->value();
		if ( travel_insight_pro_is_slider_enable( $control ) && 'sticky-slider' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_is_popular_destination_enable' ) ) :
	/**
	 * Check if popular destination is enabled.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_is_popular_destination_enable( $control ) {
		return $control->manager->get_setting( 'travel_insight_pro_theme_options[popular_destination_enable]' )->value();
	}
endif;

if ( ! function_exists( 'travel_insight_pro_popular_destination_show_count' ) ) :
	/**
	 * Check if popular destination show count.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_popular_destination_show_count( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[popular_destination_content_type]' )->value();
		if ( travel_insight_pro_is_popular_destination_enable( $control ) && 'demo' !== $content_type && 'post' !== $content_type && 'package' !== $content_type && 'destination' !== $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_popular_destination_content_category' ) ) :
	/**
	 * Check if popular destination content is category.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_popular_destination_content_category( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[popular_destination_content_type]' )->value();
		if ( travel_insight_pro_is_popular_destination_enable( $control ) && 'category' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_popular_destination_content_post' ) ) :
	/**
	 * Check if popular destination content is post.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_popular_destination_content_post( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[popular_destination_content_type]' )->value();
		if ( travel_insight_pro_is_popular_destination_enable( $control ) && 'post' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_popular_destination_content_trip' ) ) :
	/**
	 * Check if popular destination content is trip.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_popular_destination_content_trip( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[popular_destination_content_type]' )->value();
		if ( travel_insight_pro_is_popular_destination_enable( $control ) && 'trips' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_popular_destination_content_page' ) ) :
	/**
	 * Check if popular destination content is page.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_popular_destination_content_page( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[popular_destination_content_type]' )->value();
		if ( travel_insight_pro_is_popular_destination_enable( $control ) && 'page' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_popular_destination_content_destination' ) ) :
	/**
	 * Check if popular destination content is destination.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_popular_destination_content_destination( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[popular_destination_content_type]' )->value();
		if ( travel_insight_pro_is_popular_destination_enable( $control ) && 'destination' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_popular_destination_content_package' ) ) :
	/**
	 * Check if popular destination content is package.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_popular_destination_content_package( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[popular_destination_content_type]' )->value();
		if ( travel_insight_pro_is_popular_destination_enable( $control ) && 'package' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_popular_destination_content_package_category' ) ) :
	/**
	 * Check if popular destination content is package category.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_popular_destination_content_package_category( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[popular_destination_content_type]' )->value();
		if ( travel_insight_pro_is_popular_destination_enable( $control ) && 'package-category' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_popular_destination_content_trip_types' ) ) :
	/**
	 * Check if popular destination content is trip types.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_popular_destination_content_trip_types( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[popular_destination_content_type]' )->value();
		if ( travel_insight_pro_is_popular_destination_enable( $control ) && 'trip-types' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_is_about_us_enable' ) ) :
	/**
	 * Check if about us is enabled.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_is_about_us_enable( $control ) {
		return $control->manager->get_setting( 'travel_insight_pro_theme_options[about_us_enable]' )->value();
	}
endif;

if ( ! function_exists( 'travel_insight_pro_about_us_content_custom' ) ) :
	/**
	 * Check if about us content is custom.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_about_us_content_custom( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[about_us_content_type]' )->value();
		if ( travel_insight_pro_is_about_us_enable( $control ) && 'custom' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_about_us_content_post' ) ) :
	/**
	 * Check if about us content is post.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_about_us_content_post( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[about_us_content_type]' )->value();
		if ( travel_insight_pro_is_about_us_enable( $control ) && 'post' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_about_us_content_page' ) ) :
	/**
	 * Check if about us content is page.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_about_us_content_page( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[about_us_content_type]' )->value();
		if ( travel_insight_pro_is_about_us_enable( $control ) && 'page' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_about_us_content_not_demo' ) ) :
	/**
	 * Check if about us content is page.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_about_us_content_not_demo( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[about_us_content_type]' )->value();
		if ( travel_insight_pro_is_about_us_enable( $control ) && 'demo' !== $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_is_articles_enable' ) ) :
	/**
	 * Check if articles is enabled.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_is_articles_enable( $control ) {
		return $control->manager->get_setting( 'travel_insight_pro_theme_options[articles_enable]' )->value();
	}
endif;

if ( ! function_exists( 'travel_insight_pro_articles_content_category' ) ) :
	/**
	 * Check if articles content category.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_articles_content_category( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[articles_content_type]' )->value();
		if ( travel_insight_pro_is_articles_enable( $control ) && 'category' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_is_gallery_enable' ) ) :
	/**
	 * Check if gallery is enabled.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_is_gallery_enable( $control ) {
		return $control->manager->get_setting( 'travel_insight_pro_theme_options[gallery_enable]' )->value();
	}
endif;

if ( ! function_exists( 'travel_insight_pro_gallery_content_category' ) ) :
	/**
	 * Check if gallery content category.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_gallery_content_category( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[gallery_content_type]' )->value();
		if ( travel_insight_pro_is_gallery_enable( $control ) && 'category' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_is_tours_enable' ) ) :
	/**
	 * Check if tours is enabled.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_is_tours_enable( $control ) {
		return $control->manager->get_setting( 'travel_insight_pro_theme_options[tours_enable]' )->value();
	}
endif;

if ( ! function_exists( 'travel_insight_pro_tours_content_custom' ) ) :
	/**
	 * Check if tours content custom.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_tours_content_custom( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[tours_content_type]' )->value();
		if ( travel_insight_pro_is_tours_enable( $control ) && 'custom' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_tours_custom_icon' ) ) :
	/**
	 * Check if tours content custom icon.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_tours_custom_icon( $control ) {
		$content_type 	= $control->manager->get_setting( 'travel_insight_pro_theme_options[tours_content_type]' )->value();
		$icon_type 		= $control->manager->get_setting( 'travel_insight_pro_theme_options[tours_custom_icon_image]' )->value();
		if ( travel_insight_pro_is_tours_enable( $control ) && 'custom' === $content_type && 'icon' === $icon_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_tours_custom_image' ) ) :
	/**
	 * Check if tours content custom image.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_tours_custom_image( $control ) {
		$content_type 	= $control->manager->get_setting( 'travel_insight_pro_theme_options[tours_content_type]' )->value();
		$icon_type 		= $control->manager->get_setting( 'travel_insight_pro_theme_options[tours_custom_icon_image]' )->value();
		if ( travel_insight_pro_is_tours_enable( $control ) && 'custom' === $content_type && 'image' === $icon_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_tours_content_category' ) ) :
	/**
	 * Check if tours content category.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_tours_content_category( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[tours_content_type]' )->value();
		if ( travel_insight_pro_is_tours_enable( $control ) && 'category' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_tours_content_package_category' ) ) :
	/**
	 * Check if tours content package category.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_tours_content_package_category( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[tours_content_type]' )->value();
		if ( travel_insight_pro_is_tours_enable( $control ) && 'package-category' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_tours_content_destination' ) ) :
	/**
	 * Check if tours content destination.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_tours_content_destination( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[tours_content_type]' )->value();
		if ( travel_insight_pro_is_tours_enable( $control ) && 'destination' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_tours_content_activity' ) ) :
	/**
	 * Check if tours content activity.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_tours_content_activity( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[tours_content_type]' )->value();
		if ( travel_insight_pro_is_tours_enable( $control ) && 'activity' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_tours_content_trip_types' ) ) :
	/**
	 * Check if tours content trip_types.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_tours_content_trip_types( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[tours_content_type]' )->value();
		if ( travel_insight_pro_is_tours_enable( $control ) && 'trip-types' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_is_guide_enable' ) ) :
	/**
	 * Check if guide is enabled.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_is_guide_enable( $control ) {
		return $control->manager->get_setting( 'travel_insight_pro_theme_options[guide_enable]' )->value();
	}
endif;

if ( ! function_exists( 'travel_insight_pro_guide_content_post' ) ) :
	/**
	 * Check if guide content post.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_guide_content_post( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[guide_content_type]' )->value();
		if ( travel_insight_pro_is_guide_enable( $control ) && 'post' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_guide_content_category' ) ) :
	/**
	 * Check if guide content category.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_guide_content_category( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[guide_content_type]' )->value();
		if ( travel_insight_pro_is_guide_enable( $control ) && 'category' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_guide_content_page' ) ) :
	/**
	 * Check if guide content page.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_guide_content_page( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[guide_content_type]' )->value();
		if ( travel_insight_pro_is_guide_enable( $control ) && 'page' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_guide_content_custom' ) ) :
	/**
	 * Check if guide content custom.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_guide_content_custom( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[guide_content_type]' )->value();
		if ( travel_insight_pro_is_guide_enable( $control ) && 'custom' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_guide_count' ) ) :
	/**
	 * Check if guide content is not demo and post.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_guide_count( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[guide_content_type]' )->value();
		if ( travel_insight_pro_is_guide_enable( $control ) && ! in_array( $content_type, array( 'demo', 'post' ) ) )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_is_call_to_action_enable' ) ) :
	/**
	 * Check if call_to_action is enabled.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_is_call_to_action_enable( $control ) {
		return $control->manager->get_setting( 'travel_insight_pro_theme_options[call_to_action_enable]' )->value();
	}
endif;

if ( ! function_exists( 'travel_insight_pro_call_to_action_content_custom' ) ) :
	/**
	 * Check if call_to_action content custom.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_call_to_action_content_custom( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[call_to_action_content_type]' )->value();
		if ( travel_insight_pro_is_call_to_action_enable( $control ) && 'custom' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_call_to_action_content_post' ) ) :
	/**
	 * Check if call_to_action content post.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_call_to_action_content_post( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[call_to_action_content_type]' )->value();
		if ( travel_insight_pro_is_call_to_action_enable( $control ) && 'post' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_call_to_action_content_page' ) ) :
	/**
	 * Check if call_to_action content page.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_call_to_action_content_page( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[call_to_action_content_type]' )->value();
		if ( travel_insight_pro_is_call_to_action_enable( $control ) && 'page' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_is_counter_enable' ) ) :
	/**
	 * Check if counter is enabled.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_is_counter_enable( $control ) {
		return $control->manager->get_setting( 'travel_insight_pro_theme_options[counter_enable]' )->value();
	}
endif;

if ( ! function_exists( 'travel_insight_pro_counter_content_custom' ) ) :
	/**
	 * Check if counter content custom.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_counter_content_custom( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[counter_content_type]' )->value();
		if ( travel_insight_pro_is_counter_enable( $control ) && 'custom' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_is_packages_enable' ) ) :
	/**
	 * Check if packages is enabled.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_is_packages_enable( $control ) {
		return $control->manager->get_setting( 'travel_insight_pro_theme_options[packages_enable]' )->value();
	}
endif;

if ( ! function_exists( 'travel_insight_pro_packages_content_category' ) ) :
	/**
	 * Check if packages content category.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_packages_content_category
	( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[packages_content_type]' )->value();
		if ( travel_insight_pro_is_packages_enable( $control ) && 'category' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_packages_content_trip_id' ) ) :
	/**
	 * Check if packages content trip_id.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_packages_content_trip_id
	( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[packages_content_type]' )->value();
		if ( travel_insight_pro_is_packages_enable( $control ) && 'category' !== $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_packages_content_trip_types' ) ) :
	/**
	 * Check if packages content trip_types.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_packages_content_trip_types( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[packages_content_type]' )->value();
		if ( travel_insight_pro_is_packages_enable( $control ) && 'trip-types' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_packages_content_destination' ) ) :
	/**
	 * Check if packages content destination.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_packages_content_destination( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[packages_content_type]' )->value();
		if ( travel_insight_pro_is_packages_enable( $control ) && 'destination' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_packages_content_activity' ) ) :
	/**
	 * Check if packages content activity.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_packages_content_activity( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[packages_content_type]' )->value();
		if ( travel_insight_pro_is_packages_enable( $control ) && 'activity' === $content_type )
			return true;
		else
			return false;
	}
endif;

/*
 * Custom Template
 */

if ( ! function_exists( 'travel_insight_pro_is_about_us_template_slider_enable' ) ) :
	/**
	 * Check if about us template slider is enabled.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_is_about_us_template_slider_enable( $control ) {
		return $control->manager->get_setting( 'travel_insight_pro_theme_options[about_us_template_slider_enable]' )->value();
	}
endif;

if ( ! function_exists( 'travel_insight_pro_about_us_template_slider_count' ) ) :
	/**
	 * Check if about us template slider content not post.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_about_us_template_slider_count( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[about_us_template_slider_type]' )->value();
		if ( travel_insight_pro_is_about_us_template_slider_enable( $control ) && 'post' !== $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_about_us_template_slider_custom' ) ) :
	/**
	 * Check if about us template slider content custom.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_about_us_template_slider_custom( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[about_us_template_slider_type]' )->value();
		if ( travel_insight_pro_is_about_us_template_slider_enable( $control ) && 'custom' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_about_us_template_slider_page' ) ) :
	/**
	 * Check if about us template slider content page.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_about_us_template_slider_page( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[about_us_template_slider_type]' )->value();
		if ( travel_insight_pro_is_about_us_template_slider_enable( $control ) && 'page' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_about_us_template_slider_post' ) ) :
	/**
	 * Check if about us template slider content post.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_about_us_template_slider_post( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[about_us_template_slider_type]' )->value();
		if ( travel_insight_pro_is_about_us_template_slider_enable( $control ) && 'post' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_is_about_us_template_service_enable' ) ) :
	/**
	 * Check if about us template service is enabled.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_is_about_us_template_service_enable( $control ) {
		return $control->manager->get_setting( 'travel_insight_pro_theme_options[about_us_template_service_enable]' )->value();
	}
endif;

if ( ! function_exists( 'travel_insight_pro_about_us_template_service_post' ) ) :
	/**
	 * Check if about us template service content post.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_about_us_template_service_post( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[about_us_template_service_type]' )->value();
		if ( travel_insight_pro_is_about_us_template_service_enable( $control ) && 'post' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_about_us_template_service_page' ) ) :
	/**
	 * Check if about us template service content page.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_about_us_template_service_page( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[about_us_template_service_type]' )->value();
		if ( travel_insight_pro_is_about_us_template_service_enable( $control ) && 'page' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_about_us_template_service_custom' ) ) :
	/**
	 * Check if about us template service content custom.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_about_us_template_service_custom( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[about_us_template_service_type]' )->value();
		if ( travel_insight_pro_is_about_us_template_service_enable( $control ) && 'custom' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_is_contact_map_enable' ) ) :
	/**
	 * Check if contact us template map is enabled.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_is_contact_map_enable( $control ) {
		return $control->manager->get_setting( 'travel_insight_pro_theme_options[map_content_type]' )->value();
	}
endif;

if ( ! function_exists( 'travel_insight_pro_contact_map_content_shortcode' ) ) :
	/**
	 * Check if about us template service content shortcode.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_contact_map_content_shortcode( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[map_content_type]' )->value();
		if ( travel_insight_pro_is_contact_map_enable( $control ) && 'shortcode' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_contact_map_content_embed' ) ) :
	/**
	 * Check if about us template service content embed.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_contact_map_content_embed( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[map_content_type]' )->value();
		if ( travel_insight_pro_is_contact_map_enable( $control ) && 'embed' === $content_type )
			return true;
		else
			return false;
	}
endif;


/**
 * Check if team section is enabled.
 *
 * @since Travel Insight Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function travel_insight_pro_is_team_section_enable( $control ) {
	return ( $control->manager->get_setting( 'travel_insight_pro_theme_options[team_section_enable]' )->value() );
}

/**
 * Check if team section content type is category.
 *
 * @since Travel Insight Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function travel_insight_pro_is_team_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[team_content_type]' )->value();
	return travel_insight_pro_is_team_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if team section content type is page.
 *
 * @since Travel Insight Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function travel_insight_pro_is_team_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[team_content_type]' )->value();
	return travel_insight_pro_is_team_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if team section content type is post.
 *
 * @since Travel Insight Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function travel_insight_pro_is_team_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[team_content_type]' )->value();
	return travel_insight_pro_is_team_section_enable( $control ) && ( 'post' == $content_type );
}


/**
 * Check if subscription section is enabled.
 *
 * @since Musicsong Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function travel_insight_pro_is_subscription_section_enable( $control ) {
	return ( $control->manager->get_setting( 'travel_insight_pro_theme_options[subscription_section_enable]' )->value() ) && class_exists( 'Jetpack' );
}


if ( ! function_exists( 'travel_insight_pro_is_video_enable' ) ) :
	/**
	 * Check if video is enabled.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_is_video_enable( $control ) {
		return $control->manager->get_setting( 'travel_insight_pro_theme_options[video_enable]' )->value();
	}
endif;

if ( ! function_exists( 'travel_insight_pro_video_content_custom' ) ) :
	/**
	 * Check if video content custom.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_video_content_custom( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[video_content_type]' )->value();
		if ( travel_insight_pro_is_video_enable( $control ) && 'custom' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_video_content_post' ) ) :
	/**
	 * Check if video content post.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_video_content_post( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[video_content_type]' )->value();
		if ( travel_insight_pro_is_video_enable( $control ) && 'post' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_video_content_page' ) ) :
	/**
	 * Check if video content page.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_video_content_page( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[video_content_type]' )->value();
		if ( travel_insight_pro_is_video_enable( $control ) && 'page' === $content_type )
			return true;
		else
			return false;
	}
endif;


if ( ! function_exists( 'travel_insight_pro_is_latest_post_enable' ) ) :
	/**
	 * Check if latest_post is enabled.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_is_latest_post_enable( $control ) {
		return $control->manager->get_setting( 'travel_insight_pro_theme_options[latest_post_enable]' )->value();
	}
endif;


if ( ! function_exists( 'travel_insight_pro_latest_post_content_post' ) ) :
	/**
	 * Check if latest_post content is post.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_latest_post_content_post( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[latest_post_content_type]' )->value();
		if ( travel_insight_pro_is_latest_post_enable( $control ) && 'post' === $content_type )
			return true;
		else
			return false;
	}
endif;


if ( ! function_exists( 'travel_insight_pro_latest_post_content_category' ) ) :
	/**
	 * Check if latest_post content is category.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_latest_post_content_category( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[latest_post_content_type]' )->value();
		if ( travel_insight_pro_is_latest_post_enable( $control ) && 'category' === $content_type )
			return true;
		else
			return false;
	}
endif;


if ( ! function_exists( 'travel_insight_pro_latest_post_content_page' ) ) :
	/**
	 * Check if latest_post content is page.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_latest_post_content_page( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[latest_post_content_type]' )->value();
		if ( travel_insight_pro_is_latest_post_enable( $control ) && 'page' === $content_type )
			return true;
		else
			return false;
	}
endif;


if ( ! function_exists( 'travel_insight_pro_is_two_column_enable' ) ) :
	/**
	 * Check if two_column is enabled.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_is_two_column_enable( $control ) {
		return $control->manager->get_setting( 'travel_insight_pro_theme_options[two_column_enable]' )->value();
	}
endif;


if ( ! function_exists( 'travel_insight_pro_two_column_content_post' ) ) :
	/**
	 * Check if two_column content is post.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_two_column_content_post( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[two_column_content_type]' )->value();
		if ( travel_insight_pro_is_two_column_enable( $control ) && 'post' === $content_type )
			return true;
		else
			return false;
	}
endif;


if ( ! function_exists( 'travel_insight_pro_two_column_content_category' ) ) :
	/**
	 * Check if two_column content is category.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_two_column_content_category( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[two_column_content_type]' )->value();
		if ( travel_insight_pro_is_two_column_enable( $control ) && 'category' === $content_type )
			return true;
		else
			return false;
	}
endif;


if ( ! function_exists( 'travel_insight_pro_two_column_content_page' ) ) :
	/**
	 * Check if two_column content is page.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_two_column_content_page( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[two_column_content_type]' )->value();
		if ( travel_insight_pro_is_two_column_enable( $control ) && 'page' === $content_type )
			return true;
		else
			return false;
	}
endif;



if ( ! function_exists( 'travel_insight_pro_is_featured_enable' ) ) :
	/**
	 * Check if featured is enabled.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_is_featured_enable( $control ) {
		return $control->manager->get_setting( 'travel_insight_pro_theme_options[featured_enable]' )->value();
	}
endif;


if ( ! function_exists( 'travel_insight_pro_featured_content_post' ) ) :
	/**
	 * Check if featured content is post.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_featured_content_post( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[featured_content_type]' )->value();
		if ( travel_insight_pro_is_featured_enable( $control ) && 'post' === $content_type )
			return true;
		else
			return false;
	}
endif;


if ( ! function_exists( 'travel_insight_pro_featured_content_category' ) ) :
	/**
	 * Check if featured content is category.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_featured_content_category( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[featured_content_type]' )->value();
		if ( travel_insight_pro_is_featured_enable( $control ) && 'category' === $content_type )
			return true;
		else
			return false;
	}
endif;


if ( ! function_exists( 'travel_insight_pro_featured_content_page' ) ) :
	/**
	 * Check if featured content is page.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_featured_content_page( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[featured_content_type]' )->value();
		if ( travel_insight_pro_is_featured_enable( $control ) && 'page' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_featured_content_post' ) ) :
	/**
	 * Check if featured content is page.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_featured_content_post( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[featured_content_type]' )->value();
		if ( travel_insight_pro_is_featured_enable( $control ) && 'page' === $content_type )
			return true;
		else
			return false;
	}
endif;

/*medical reason*/

if ( ! function_exists( 'travel_insight_pro_is_medical_reasons_enable' ) ) :
	/**
	 * Check if medical reason is enabled.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_is_medical_reasons_enable( $control ) {
		return $control->manager->get_setting( 'travel_insight_pro_theme_options[medical_reasons_enable]' )->value();
	}
endif;

if ( ! function_exists( 'travel_insight_pro_medical_reasons_content_custom' ) ) :
	/**
	 * Check if medical reason content is custom.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_medical_reasons_content_custom( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[medical_reasons_content_type]' )->value();
		if ( travel_insight_pro_is_medical_reasons_enable( $control ) && 'custom' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_medical_reasons_content_post' ) ) :
	/**
	 * Check if medical reason content is post.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_medical_reasons_content_post( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[medical_reasons_content_type]' )->value();
		if ( travel_insight_pro_is_medical_reasons_enable( $control ) && 'post' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_medical_reasons_content_page' ) ) :
	/**
	 * Check if medical reason content is page.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_medical_reasons_content_page( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[medical_reasons_content_type]' )->value();
		if ( travel_insight_pro_is_medical_reasons_enable( $control ) && 'page' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'travel_insight_pro_medical_reasons_content_not_demo' ) ) :
	/**
	 * Check if medical reason content is page.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_postize_Control $control WP_postize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_medical_reasons_content_not_demo( $control ) {
		$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[medical_reasons_content_type]' )->value();
		if ( travel_insight_pro_is_medical_reasons_enable( $control ) && 'demo' !== $content_type )
			return true;
		else
			return false;
	}
endif;

/*end medical reason*/

if ( ! function_exists( 'travel_insight_pro_is_masonry_section_enable' ) ) :
	/**
	 * Check if masonry is enabled.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_is_masonry_section_enable( $control ) {
		return $control->manager->get_setting( 'travel_insight_pro_theme_options[masonry_section_enable]' )->value();
	}
endif;

/*recent product section*/

if ( ! function_exists( 'travel_insight_pro_is_recent_product_enable' ) ) :
	/**
	 * Check if recent_product is enabled.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_is_recent_product_enable( $control ) {
		return $control->manager->get_setting( 'travel_insight_pro_theme_options[recent_product_enable]' )->value();
	}
endif;

/**
 * Check if recent_product content type is product.
 *
 * @since Travel Insight Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function travel_insight_pro_is_recent_product_section_content_product( $control ) {
	$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[recent_product_content_type]' )->value();
	return ( travel_insight_pro_is_recent_product_enable( $control ) && 'product' == $content_type );
}

/**
 * Check if recent_product content type is product category.
 *
 * @since Travel Insight Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function travel_insight_pro_is_recent_product_section_content_product_category( $control ) {
	$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[recent_product_content_type]' )->value();
	return ( travel_insight_pro_is_recent_product_enable( $control ) && 'product-category' == $content_type );
}

/*end recent product section*/


/*service section*/

/**
 * Check if service section is enabled.
 *
 * @since Travel Insight Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function travel_insight_pro_is_service_enable( $control ) {
	return ( $control->manager->get_setting( 'travel_insight_pro_theme_options[service_enable]' )->value() );
}

/**
 * Check if service section content type is page.
 *
 * @since Travel Insight Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function travel_insight_pro_service_content_page( $control ) {
	$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[service_content_type]' )->value();
	return travel_insight_pro_is_service_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if service section content type is post.
 *
 * @since Travel Insight Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function travel_insight_pro_service_content_post( $control ) {
	$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[service_content_type]' )->value();
	return travel_insight_pro_is_service_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if service section content type is category.
 *
 * @since Travel Insight Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function travel_insight_pro_service_content_category( $control ) {
	$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[service_content_type]' )->value();
	return travel_insight_pro_is_service_enable( $control ) && ( 'category' == $content_type );
}


/*end service section*/

/*latest product section*/

if ( ! function_exists( 'travel_insight_pro_is_latest_product_enable' ) ) :
	/**
	 * Check if latest_product is enabled.
	 *
	 * @since Travel Insight Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function travel_insight_pro_is_latest_product_enable( $control ) {
		return $control->manager->get_setting( 'travel_insight_pro_theme_options[latest_product_enable]' )->value();
	}
endif;

/**
 * Check if latest_product content type is product.
 *
 * @since Travel Insight Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function travel_insight_pro_is_latest_product_section_content_product( $control ) {
	$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[latest_product_content_type]' )->value();
	return ( travel_insight_pro_is_latest_product_enable( $control ) && 'product' == $content_type );
}

/**
 * Check if latest_product content type is product category.
 *
 * @since Travel Insight Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function travel_insight_pro_is_latest_product_section_content_product_category( $control ) {
	$content_type = $control->manager->get_setting( 'travel_insight_pro_theme_options[latest_product_content_type]' )->value();
	return ( travel_insight_pro_is_latest_product_enable( $control ) && 'product-category' == $content_type );
}

/*end latest product section*/
