<?php
/**
 * Theme Palace Theme Customizer.
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function travel_insight_pro_customize_register( $wp_customize ) {
	$options = travel_insight_pro_get_theme_options();

	// Load custom control functions.
	require get_template_directory() . '/inc/customizer/custom-controls.php';

	// Load customize active callback functions.
	require get_template_directory() . '/inc/customizer/active-callback.php';

	// Load validation callback functions.
	require get_template_directory() . '/inc/customizer/validation.php';

	// Load partial callback functions.
	require get_template_directory() . '/inc/customizer/partial.php';

	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	
	
	/**
	 * Theme Version.
	 */
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[theme_version]', array(
		'default'           => $options['theme_version'],
		'sanitize_callback' => 'travel_insight_pro_sanitize_select',
	) );
	$wp_customize->add_control( 'travel_insight_pro_theme_options[theme_version]', array(
		'type'    => 'radio',
		'label'    => esc_html__( 'Theme Version', 'travel-insight-pro' ),
		'choices'  => array(
			'lite-version'   => esc_html__( 'Lite Version', 'travel-insight-pro' ),
            'dark-version'     => esc_html__( 'Dark Version', 'travel-insight-pro' ),
		),
		'section'  => 'colors',
	) );

	// Add panel for sections options
	$wp_customize->add_panel( 'travel_insight_pro_sections_panel' , array(
	    'title'      => esc_html__( 'Homepage Section','travel-insight-pro' ),
	    'description'=> esc_html__( 'Homepage Section Options.', 'travel-insight-pro' ),
	    'priority'   => 150,
	) );

	
	// Homepage-layout
	require get_template_directory() . '/inc/customizer/sections/homepage-layout.php';

	
	if ( $options['home_layout'] == 'fourth-design' || $options['home_layout'] == 'fifth-design' || $options['home_layout'] == 'sixth-design' ) {
		// Top bar
		require get_template_directory() . '/inc/customizer/sections/top-bar.php';
	}

	// slider
	require get_template_directory() . '/inc/customizer/sections/slider.php';

	if ( $options['home_layout'] == 'default-design' ) {
		// popular destination
		require get_template_directory() . '/inc/customizer/sections/popular-destination.php';
	
		// about us
		require get_template_directory() . '/inc/customizer/sections/about-us.php';
		
		// articles
		require get_template_directory() . '/inc/customizer/sections/articles.php';

	}
	
	if ( $options['home_layout'] == 'second-design' ) {
		// about us
		require get_template_directory() . '/inc/customizer/sections/about-us.php';
	
		// guide
		require get_template_directory() . '/inc/customizer/sections/guide.php';

		// video us
		require get_template_directory() . '/inc/customizer/sections/video.php';
		
		// call to action
		require get_template_directory() . '/inc/customizer/sections/call-to-action.php';

		// counter
		require get_template_directory() . '/inc/customizer/sections/counter.php';
	
		// team
		require get_template_directory() . '/inc/customizer/sections/team.php';

		// subscription
		require get_template_directory() . '/inc/customizer/sections/subscription.php';
	
		// latest post
		require get_template_directory() . '/inc/customizer/sections/latest-post.php';
	}

	if ( $options['home_layout'] == 'default-design' ) {

		// gallery
		require get_template_directory() . '/inc/customizer/sections/gallery.php';

		// tours
		require get_template_directory() . '/inc/customizer/sections/tours.php';

		// guide
		require get_template_directory() . '/inc/customizer/sections/guide.php';
		
		// call to action
		require get_template_directory() . '/inc/customizer/sections/call-to-action.php';

		require get_template_directory() . '/inc/customizer/sections/counter.php';

		// packages
		if ( class_exists( 'WP_Travel' ) ) :
			require get_template_directory() . '/inc/customizer/sections/packages.php';
		endif;


	}

	if ( $options['home_layout'] == 'third-design' ) {

		// about us
		require get_template_directory() . '/inc/customizer/sections/about-us.php';

		// guide
		require get_template_directory() . '/inc/customizer/sections/guide.php';

		// call to action
		require get_template_directory() . '/inc/customizer/sections/call-to-action.php';

		// team
		require get_template_directory() . '/inc/customizer/sections/team.php';

		// medical-reasons
		require get_template_directory() . '/inc/customizer/sections/medical-reasons.php';

		// latest post
		require get_template_directory() . '/inc/customizer/sections/latest-post.php';

		// tours
		require get_template_directory() . '/inc/customizer/sections/tours.php';
	
		
	}

	if ( $options['home_layout'] == 'fourth-design' ) {
	
		// Featured
		require get_template_directory() . '/inc/customizer/sections/featured.php';
	
		// Video
		require get_template_directory() . '/inc/customizer/sections/video.php';

		require get_template_directory() . '/inc/customizer/sections/two_column.php';

		require get_template_directory() . '/inc/customizer/sections/latest-post.php';
	}

	if ( $options['home_layout'] == 'fifth-design' ) {

		// Featured
		require get_template_directory() . '/inc/customizer/sections/featured.php';

		//two column
		require get_template_directory() . '/inc/customizer/sections/two_column.php';

		// Video
		require get_template_directory() . '/inc/customizer/sections/video.php';

		//latest post
		require get_template_directory() . '/inc/customizer/sections/latest-post.php';
	}

	if ( $options['home_layout'] == 'sixth-design' ) {

		// masonry
		require get_template_directory() . '/inc/customizer/sections/masonry.php';

		// recent-products
		require get_template_directory() . '/inc/customizer/sections/recent-products.php';
		
		// service
		require get_template_directory() . '/inc/customizer/sections/service.php';

		// latest-products
		require get_template_directory() . '/inc/customizer/sections/latest-product.php';

		//latest post
		require get_template_directory() . '/inc/customizer/sections/latest-post.php';
	}

	if ( $options['home_layout'] == 'seven-design' || $options['home_layout'] == 'eight-design' ) {
		// about us
		require get_template_directory() . '/inc/customizer/sections/about-us.php';
	
		// service
		require get_template_directory() . '/inc/customizer/sections/service.php';

		if ( $options['home_layout'] == 'seven-design' ):

		// video us
		require get_template_directory() . '/inc/customizer/sections/video.php';

		endif;

		if ( $options['home_layout'] == 'eight-design' ):

		// call to action
		require get_template_directory() . '/inc/customizer/sections/call-to-action.php';

		endif;

		// Featured
		require get_template_directory() . '/inc/customizer/sections/featured.php';

		// counter
		require get_template_directory() . '/inc/customizer/sections/counter.php';
	
		// team
		require get_template_directory() . '/inc/customizer/sections/team.php';

		// subscription
		require get_template_directory() . '/inc/customizer/sections/subscription.php';
	
		// latest post
		require get_template_directory() . '/inc/customizer/sections/latest-post.php';
	}

	

	// Add panel for common theme options
	$wp_customize->add_panel( 'travel_insight_pro_theme_options_panel' , array(
	    'title'      => esc_html__( 'Theme Options','travel-insight-pro' ),
	    'description'=> esc_html__( 'Travel Insight Theme Options.', 'travel-insight-pro' ),
	    'priority'   => 150,
	) );

	require get_template_directory() . '/inc/customizer/theme-options/sortable.php';

	// header
	require get_template_directory() . '/inc/customizer/theme-options/header.php';

	// color
	require get_template_directory() . '/inc/customizer/theme-options/theme-color.php';

	// loader
	require get_template_directory() . '/inc/customizer/theme-options/loader.php';

	// typography
	require get_template_directory() . '/inc/customizer/theme-options/typography.php';

	// load layout
	require get_template_directory() . '/inc/customizer/theme-options/layout.php';

	// load static homepage option
	require get_template_directory() . '/inc/customizer/theme-options/homepage-static.php';

	// load excerpt option
	require get_template_directory() . '/inc/customizer/theme-options/excerpt.php';

	// load breadcrumb option
	require get_template_directory() . '/inc/customizer/theme-options/breadcrumb.php';

	// load pagination option
	require get_template_directory() . '/inc/customizer/theme-options/pagination.php';

	// load single page option
	require get_template_directory() . '/inc/customizer/theme-options/single.php';

	// load blog page option
	require get_template_directory() . '/inc/customizer/theme-options/blog.php';

	// load footer option
	require get_template_directory() . '/inc/customizer/theme-options/footer.php';

	// load 404 option
	require get_template_directory() . '/inc/customizer/theme-options/404.php';

	// load reset option
	require get_template_directory() . '/inc/customizer/theme-options/reset.php';
	
	if ( class_exists( 'TP_Travel_Package' ) ) {
		// destination option
		require get_template_directory() . '/inc/customizer/theme-options/destination.php';

		// package option
		require get_template_directory() . '/inc/customizer/theme-options/package.php';
	}

	/*
	 * Custom Template
	 */
	
	// about us template option
	require get_template_directory() . '/inc/customizer/custom-template/about-template.php';

	// contact us template option
	require get_template_directory() . '/inc/customizer/custom-template/contact-template.php';

}
add_action( 'customize_register', 'travel_insight_pro_customize_register' );

/*
 * Load customizer sanitization functions.
 */
require get_template_directory() . '/inc/customizer/sanitize.php';

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function travel_insight_pro_customize_preview_js() {
	$min = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';
	wp_enqueue_script( 'travel_insight_pro_customizer', get_template_directory_uri() . '/assets/js/customizer' . $min . '.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'travel_insight_pro_customize_preview_js' );

/**
 * Load dynamic logic for the customizer controls area.
 */
function travel_insight_pro_customize_control_js() {

	$options = travel_insight_pro_get_theme_options();
	$min = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';
	
	// fontawesome
	wp_enqueue_style( 'font-awesome-css', get_template_directory_uri() . '/assets/css/font-awesome' . $min . '.css' );

	// simple icon picker
	wp_enqueue_style( 'simple-iconpicker-css', get_template_directory_uri() . '/assets/css/simple-iconpicker' . $min . '.css' );
	wp_enqueue_script( 'jquery-simple-iconpicker', get_template_directory_uri() . '/assets/js/simple-iconpicker' . $min . '.js', array( 'jquery' ), '', true );

	
}
add_action( 'customize_controls_enqueue_scripts', 'travel_insight_pro_customize_control_js' );


if ( !function_exists( 'travel_insight_pro_reset_options' ) ) :
	/**
	 * Reset all options
	 *
	 * @since Travel Insight Pro 1.0
	 *
	 * @param bool $checked Whether the reset is checked.
	 * @return bool Whether the reset is checked.
	 */
	function travel_insight_pro_reset_options() {
		$options = travel_insight_pro_get_theme_options();
		if ( true === $options['reset_options'] ) {
			// Reset custom theme options.
			set_theme_mod( 'travel_insight_pro_theme_options', array() );
			// Reset custom header and backgrounds.
			remove_theme_mod( 'header_image' );
            remove_theme_mod( 'header_image_data' );
            remove_theme_mod( 'background_image' );
            remove_theme_mod( 'background_color' );
            remove_theme_mod( 'header_textcolor' );
	    }
	  	else {
		    return false;
	  	}
	}
endif;
add_action( 'customize_save_after', 'travel_insight_pro_reset_options' );

if ( !function_exists( 'travel_insight_pro_customize_scripts' ) ) :
	/**
	 * Custom scripts and styles on customize.php
	 *
	 * @since Travel Insight Pro 1.0
	 */
	function travel_insight_pro_customize_scripts() {
		$min = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

		wp_enqueue_style( 'travel_insight_pro_custom_customizer_style', get_template_directory_uri() . '/assets/css/customize-control' . $min . '.css' );

		wp_enqueue_script( 'travel_insight_pro_custom_customizer', get_template_directory_uri() . '/assets/js/custom-customizer.js', array( 'jquery', 'customize-controls', 'iris', 'underscore', 'wp-util' ), '', true );

		$travel_insight_pro_data = array(
			'reset_message' => esc_html__( 'Refresh the customizer page after saving to view reset effects', 'travel-insight-pro' )
		);

		// Send list of color variables as object to custom customizer js
		wp_localize_script( 'travel_insight_pro_custom_customizer', 'travel_insight_pro_data', $travel_insight_pro_data );
	}
endif;
add_action( 'customize_controls_enqueue_scripts', 'travel_insight_pro_customize_scripts');

