<?php
/**
 * Customizer default options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 * @return array An array of default values
 */

function travel_insight_pro_get_default_theme_options() {
	$theme_data = wp_get_theme();
	$travel_insight_pro_default_options = array(

		// Theme Options
		'theme_version'				    => 'lite-version',
		'home_layout'					=> 'default-design',
		'theme_typography' 				=> 'default',
		'theme_body_typography' 		=> 'default',
		'loader_enable'         		=> false,
		'site_layout'         			=> 'wide',
		'sidebar_position'         		=> 'right-sidebar',
		'long_excerpt_length'           => 25,
		'author_box_enable'          	=> true,
		'single_pagination_enable'      => true,
		'single_date_enable'      		=> true,
		'single_category_enable'      	=> true,
		'breadcrumb_enable'         	=> true,
		'pagination_enable'         	=> true,
		'pagination_type'         		=> 'default',
		'copyright_text'           		=> sprintf( _x( 'Copyright &copy; %1$s %2$s. All Rights Reserved', '1: Year, 2: Site Title with home URL', 'travel-insight-pro' ), '[the-year]', '[site-link]' ) . ' &#124; ' . esc_html( $theme_data->get( 'Name') ) . '&nbsp;' . __( 'by', 'travel-insight-pro' ). '&nbsp;<a target="_blank" href="'. esc_url( $theme_data->get( 'AuthorURI' ) ) .'">'. esc_html( ucwords( $theme_data->get( 'Author' ) ) ) .'</a>',
		'scroll_top_visible'        	=> true,
		'footer_logo_enable'        	=> true,
		'reset_options'      			=> false,
		'enable_frontpage_content' 		=> true,
		'footer_background' 			=> get_template_directory_uri() . '/assets/uploads/bg-footer.png',
		'site_title_enable'				=> true,
		'site_description_enable'		=> true,
		'site_logo_enable'				=> true,
		'header_social_enable'			=> true,
		'sticky_menu_enable'			=> false,
		'menu_label_enable'				=> true,
		'blog_img_enable'				=> true,
		'blog_date_enable'				=> true,
		'blog_category_enable'			=> true,
		'blog_views_enable'				=> true,
		'theme_color'					=> 'blue',
		'content_width'					=> 'content-width',
		'sortable'						=>  'Featured Slider,Popular Destination,About,Articles,Gallery,Tours,Guide,Call to Action,Counter,Packages',

		// Slider Section
		'slider_enable'					=> true,
		'slider_caption_enable'			=> true,
		'slider_search_enable'			=> true,
		'slider_effect'					=> 'fade',
		'slider_transition_duration'	=> '1000',
		'enable_slider_controls'		=> true,
		'enable_slider_dragable'		=> true,
		'slider_autoplay'				=> true,
		'slider_pause_on_hover'			=> true,
		'slider_wp_travel_filter_enable'=> false,
		'slider_layout'					=> 'normal-slider',
		'slider_content_type'			=> 'demo',
		'no_of_slider'					=> 3,
		'slider_social_menu_enable'		=> false,

		// Popular Destination
		'popular_destination_enable'		=> true,
		'popular_destination_title'			=> esc_html__( 'Popular Destination', 'travel-insight-pro' ),
		'popular_destination_sub_title' 	=> esc_html__( 'Display the most popular places in beautiful ways', 'travel-insight-pro' ),
		'popular_destination_content_type' 	=> 'demo',
		'no_of_popular_destination' 		=> 5,
		'package_archive_title'				=> esc_html__( 'Find your next travel place', 'travel-insight-pro' ),
		'package_archive_sub_title' 		=> esc_html__( 'Display the most popular places in beautiful ways', 'travel-insight-pro' ),
		'package_search_title'				=> esc_html__( 'Find your next travel place', 'travel-insight-pro' ),
		'package_search_sub_title' 			=> esc_html__( 'Display the most popular places in beautiful ways', 'travel-insight-pro' ),

		// About Us
		'about_us_enable'				=> true,
		'about_us_content_type'			=> 'demo',
		'about_us_alignment'			=> 'align-left',
		'about_us_btn_label'			=> esc_html__( 'Read More', 'travel-insight-pro' ),
		'about_us_btn_link'				=> '#',
		'about_us_content_image'		=> get_template_directory_uri() . '/assets/uploads/about.jpg',
		'about_us_title'				=> esc_html__( 'Know about us', 'travel-insight-pro' ),
		'about_us_sub_title'			=> esc_html__( 'We do good for website to look stunning', 'travel-insight-pro' ),
		'about_us_description'			=> sprintf( '%1$s <br> %2$s', esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam in mi ut ipsum accumsan varius. Vivamus semper augue pulvinar dolor efficitur, quis auctor lorem egestas. In fermentum suscipit lectus nec tincidunt. Donec commodo arcu arcu, quis egestas libero volutpat pharetra.', 'travel-insight-pro' ), esc_html__( 'Duis nulla lectus, consequat eu ullamcorper in, vestibulum eu ante. Vivamus placerat, felis in hendrerit convallis, mauris turpis suscipit sem, eu molestie tortor erat a sem. Maecenas a ante maximus, elementum elit aliquet, tristique magna.', 'travel-insight-pro' ) ),

		// Articles
		'articles_enable'				=> true,
		'articles_content_type'			=> 'demo',
		'articles_background'			=> get_template_directory_uri() . '/assets/uploads/background-02.jpg',
		'no_of_articles_category'		=> 3,
		'no_of_articles'				=> 2,

		// Gallery
		'gallery_enable'				=> true,
		'gallery_content_type'			=> 'demo',
		'gallery_title'					=> esc_html__( 'Stunning Gallery', 'travel-insight-pro' ),
		'gallery_sub_title'				=> esc_html__( 'Show your amazing photo showcase here in Dynamic photo stream', 'travel-insight-pro' ),

		// Tours
		'tours_enable'					=> true,
		'tours_title'					=> esc_html__( 'Tour', 'travel-insight-pro' ),
		'tours_sub_title'				=> esc_html__( 'Find Tour By', 'travel-insight-pro' ),
		'tours_content_type'			=> 'demo',
		'no_of_tours'					=> 6,
		'tours_label'					=> esc_html__( 'Tour Title', 'travel-insight-pro' ),
		'tours_link'					=> '#',
		'tours_icon'					=> 'cloud',
		'tours_custom_icon_image'		=> 'icon',

		// Guide
		'guide_enable'						=> true,
		'guide_content_type'				=> 'demo',
		'no_of_guide'						=> 6,
		'guide_title'						=> esc_html__( 'Survival Guide', 'travel-insight-pro' ),
		'guide_sub_title'					=> esc_html__( 'You need following things to prepare before going for an adventure', 'travel-insight-pro' ),
		'guide_custom_icon'					=> 'drop',
		'guide_content_custom_title'		=> esc_html__( 'Guide Title', 'travel-insight-pro' ),
		'guide_content_custom_description' 	=> esc_html__( 'Proin turpis lorem, faucibus eu augue sed, pharetra porttitor...', 'travel-insight-pro' ),
		'guide_content_custom_link' 		=> '#',

		// Call To Action
		'call_to_action_enable'			=> true,
		'call_to_action_content_type'	=> 'demo',
		'call_to_action_title'			=> esc_html__( 'You are invited to relax', 'travel-insight-pro' ),
		'call_to_action_sub_title'		=> esc_html__( 'You need following things to prepare before going for an adventure', 'travel-insight-pro' ),
		'call_to_action_description'	=> esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam in mi ut ipsum accumsan varius. Vivamus semper augue pulvinar dolor efficitur, quis auctor lorem egestas.', 'travel-insight-pro' ),
		'call_to_action_btn_label'		=> esc_html__( 'Learn More', 'travel-insight-pro' ),
		'call_to_action_btn_link'		=> '#',
		'call_to_action_background'		=> get_template_directory_uri() . '/assets/uploads/parallax-01.jpg',

		// Counter
		'counter_enable'				=> true,
		'counter_content_type'			=> 'demo',
		'counter_title'					=> esc_html__( 'Counter Title', 'travel-insight-pro' ),
		'counter_value'					=> esc_html__( '505', 'travel-insight-pro' ),

		// Packages
		'packages_enable'				=> true,
		'packages_title'				=> esc_html__( 'Find your perfect tour', 'travel-insight-pro' ),
		'packages_sub_title'			=> esc_html__( 'Travel with best packages for an adventure', 'travel-insight-pro' ),
		'packages_content_type'			=> 'category',
		'no_of_packages'				=> 4,
		
		// Custom Template
		// About us Template
		'about_us_template_quote'			=> esc_html__( 'Write here something about.', 'travel-insight-pro' ),
		'about_us_template_slider_enable'	=> true,
		'about_us_template_slider_type'		=> 'custom',
		'no_of_about_us_template_slider'	=> 4,
		'about_us_template_service_enable'	=> true,
		'about_us_template_service_type'	=> 'custom',
		
		// Contact Us Template
		'contact_map_enable'			=> true,
		'map_content_type'				=> 'shortcode',
		
		// team
		'team_section_enable'		=> true,
		'team_title'				=> esc_html__( 'Our Team Members.', 'travel-insight-pro' ),
		'team_sub_title'			=> esc_html__( 'Business consulting excepteur sint occaecat cupidatat consulting non proident, sunt in culpa qui officia deserunt laborum Market.', 'travel-insight-pro' ),
		'team_count'				=> 4,
		'team_column_layout'		=> 'col-4',
		'team_content_type'			=> 'category',
		
		// subscription
		'subscription_section_enable'	=> true,
		'subscription_title'			=> esc_html__( 'Our Team Members.', 'travel-insight-pro' ),
		'subscription_subtitle'			=> esc_html__( 'Business consulting excepteur sint occaecat cupidatat consulting non proident, sunt in culpa qui officia deserunt laborum Market.', 'travel-insight-pro' ),
		'subscription_description'		=> esc_html__( 'Business consulting excepteur sint occaecat cupidatat consulting non proident, sunt in culpa qui officia deserunt laborum Market.', 'travel-insight-pro' ),
		'subscription_background' 		=> get_template_directory_uri() . '/assets/uploads/background-03.jpg',
		
		// Destination Single
		'destination_content_background' 	=> get_template_directory_uri() . '/assets/uploads/background-03.jpg',
		'related_destination_title'			=> esc_html__( 'Great Tour Around World', 'travel-insight-pro' ),
		'related_destination_sub_title'		=> esc_html__( 'Display the most beautiful places in beautiful ways', 'travel-insight-pro' ),
		
		// Video Single
		'video_enable'			=> true,
		'video_content_type'	=> 'demo',
		'video_title'			=> esc_html__( 'Discover the World of Business', 'travel-insight-pro' ),
		'video_description'		=> esc_html__( 'Business consulting excepteur sint occaecat cupidatat consulting non proident, sunt in culpa qui officia deserunt laborum Market.', 'travel-insight-pro' ),
		'video_background' 		=> get_template_directory_uri() . '/assets/uploads/business-video.jpg',
		
		// Blog Single
		'latest_post_enable'				=> true,
		'latest_post_content_type'			=> 'category',
		'latest_post_title'					=> esc_html__( 'Read Latest Updates', 'travel-insight-pro' ),
		'latest_post_sub_title'				=> esc_html__( 'Business consulting excepteur sint occaecat cupidatat consulting non proident, sunt in culpa qui officia deserunt laborum Market.', 'travel-insight-pro' ),
		'no_of_latest_post'					=> 3,
		'latest_post_read_more_btn_label'	=> esc_html__( 'Read Full Post', 'travel-insight-pro' ),
		
		// Two Column Single
		'two_column_enable'			=> true,
		'two_column_content_type'	=> 'category',
		'two_column_title'			=> esc_html__( '2 COLUMN NEWS', 'travel-insight-pro' ),
		'no_of_two_column'			=> 4,
		'two_column_button'			=> esc_html__( 'Read More', 'travel-insight-pro' ),
		
		// Featured Single
		'featured_enable'			=> true,
		'featured_content_type'		=> 'category',
		'featured_column_layout'	=> 'col-4',
		'featured_title'			=> esc_html__( 'Featured', 'travel-insight-pro' ),
		'featured_description'		=> esc_html__( 'Almost two years ago I sat down in front of a computer screen, in an open office space, waiting. I was nervous, eager to start and terrified', 'travel-insight-pro' ),
		'no_of_featured'			=> 4,
		'featured_button'			=> esc_html__( 'Explore More', 'travel-insight-pro' ),

		//medical reason
		'medical_reasons_enable'			=> true,
		'medical_reasons_title'			=> esc_html__( 'WE MAKE A DIFFERENCE IN YOUR LIVES', 'travel-insight-pro' ),
		'medical_reasons_description'			=> esc_html__( 'Lorem ipsum dolor sit amet consectetur adipiscing elit Nulla vehicula malesuada nisi eu rutrum. Maecenas purus diam lobortis at velit eget ultricies posuere augue Nullam nec lectus a augue dictum euismod ut sed ex Integer pretium arcu neque vitae', 'travel-insight-pro' ),
		'medical_reasons_content_type'		=> 'post',

		//masonry
		'masonry_section_enable'			=> false,

		//recent product
		'recent_product_enable'				=> true,
		'recent_product_content_type'		=> 'product-category',
		'no_of_recent_product'				=> 4,
		'recent_product_title'				=> esc_html__( 'Popular Products', 'travel-insight-pro' ),
		'recent_product_subtitle'			=> esc_html__( 'Latest spring collection for fashionable person like you.', 'travel-insight-pro' ),

		//service
		'service_enable'			=> true,
		'service_content_type'		=> 'category',
		'no_of_service'				=> 3,
		'service_title'				=> esc_html__( 'OUR SERVICES', 'travel-insight-pro' ),
		'service_description'		=> esc_html__( 'DISCOVER OUR MOST POPULAR COURSES FOR SELF-LEARNING TO FIND', 'travel-insight-pro' ),
		'service_btn_title'			=> esc_html__( 'SEE MORE', 'travel-insight-pro' ),


		//latest product
		'latest_product_enable'			=> true,
		'latest_product_content_type'	=> 'product-category',
		'no_of_latest_product'			=> 4,
		'latest_product_title'			=> esc_html__( 'NEW ARRIVALS', 'travel-insight-pro' ),
		'latest_product_subtitle'		=> esc_html__( 'All Styles in This Spring', 'travel-insight-pro' ),
		
		

	);

	$output = apply_filters( 'travel_insight_pro_default_theme_options', $travel_insight_pro_default_options );
	// Sort array in ascending order, according to the key:
	if ( ! empty( $output ) ) {
		ksort( $output );
	}

	return $output;
}