<?php
/**
 * Counter Section options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

$wp_customize->add_section( 'travel_insight_pro_counter', array(
	'title'             => esc_html__( 'Counter','travel-insight-pro' ),
	'description'       => esc_html__( 'Counter Options.', 'travel-insight-pro' ),
	'panel'             => 'travel_insight_pro_sections_panel',
) );

// Counter Section enable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[counter_enable]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
	'default'          	=> $options['counter_enable'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[counter_enable]', array(
	'label'            	=> esc_html__( 'Enable Counter Section', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_counter',
	'type'             	=> 'checkbox',
) );

// Add counter content type setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[counter_content_type]', array(
	'default'           => $options['counter_content_type'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_select'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[counter_content_type]', array(
	'label'           	=> esc_html__( 'Content Type', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_counter',
	'type'            	=> 'select',
	'active_callback' 	=> 'travel_insight_pro_is_counter_enable',
	'choices'         	=> travel_insight_pro_counter_content_type(),
) );

for ( $i = 1; $i <= 4; $i++ ) {

	// counter hr setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[counter_custom_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Travel_Insight_Pro_Customize_Horizontal_Line( $wp_customize, 'travel_insight_pro_theme_options[counter_custom_hr_'. $i .']',
		array(
			'section'         => 'travel_insight_pro_counter',
			'active_callback' => 'travel_insight_pro_counter_content_custom',
			'type'			  => 'hr'
	) ) );

	// Add counter value setting and control.
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[counter_value_' . $i . ']', array(
		'default'           => $options['counter_value'],
		'sanitize_callback' => 'travel_insight_pro_sanitize_number_range',
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[counter_value_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Value %d', 'travel-insight-pro' ), $i ),
		'description'       => esc_html__( 'Note: Min 1. Please input the valid number and save.', 'travel-insight-pro' ),
		'section'         	=> 'travel_insight_pro_counter',
		'type'            	=> 'number',
		'active_callback' 	=> 'travel_insight_pro_counter_content_custom',
		'input_attrs'     	=> array(
			'min' 	=> 1,
			'style' => 'width:100px'
		)
	) );

	// Counter title setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[counter_title_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'          	=> $options['counter_title'],
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[counter_title_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Title %d', 'travel-insight-pro' ), $i ),
		'section'        	=> 'travel_insight_pro_counter',
		'active_callback' 	=> 'travel_insight_pro_counter_content_custom',
		'type'				=> 'text'
	) );
}