<?php
/**
 * Featured Section options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

$wp_customize->add_section( 'travel_insight_pro_featured', array(
	'title'             => esc_html__( 'Featured','travel-insight-pro' ),
	'description'       => esc_html__( 'Featured Options.', 'travel-insight-pro' ),
	'panel'             => 'travel_insight_pro_sections_panel',
) );

// Featured Section enable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[featured_enable]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
	'default'          	=> $options['featured_enable'],

) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[featured_enable]', array(
	'label'            	=> esc_html__( 'Enable Featured Section', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_featured',
	'type'             	=> 'checkbox',
) );

// featured title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[featured_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['featured_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[featured_title]', array(
	'label'           	=> esc_html__( 'Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_featured',
	'active_callback' 	=> 'travel_insight_pro_is_featured_enable',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[featured_title]', array(
		'selector'            => '#featured-posts .section-header h2',
		'settings'            => 'travel_insight_pro_theme_options[featured_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_featured_title_partial',
    ) );
}

if ( $options['home_layout'] == 'seven-design' || $options['home_layout'] == 'eight-design' ):

	// Call to action description setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[featured_description]', array(
	'sanitize_callback' => 'wp_kses_post',
	'default'          	=> $options['featured_description'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[featured_description]', array(
	'label'           	=> esc_html__( 'Description', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_featured',
	'active_callback' 	=> 'travel_insight_pro_is_featured_enable',
	'type'				=> 'textarea'
) );

endif;

// Add Featured content type setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[featured_content_type]', array(
	'default'           => $options['featured_content_type'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_select'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[featured_content_type]', array(
	'label'           	=> esc_html__( 'Content Type', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_featured',
	'type'            	=> 'select',
	'active_callback' 	=> 'travel_insight_pro_is_featured_enable',
	'choices'         	=> array(
        'category'  => esc_html__( 'Category', 'travel-insight-pro' ),
        'page'      => esc_html__( 'Page', 'travel-insight-pro' ),
        'post'      => esc_html__( 'Post', 'travel-insight-pro' ),
    ),
) );

// Add featured number setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[no_of_featured]', array(
	'default'           => $options['no_of_featured'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_number_range',
	'validate_callback' => 'travel_insight_pro_validate_featured_count',
	'transport'			=> 'refresh',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[no_of_featured]', array(
	'label'           	=> esc_html__( 'Number of Articles', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Note: Min 3 & Max 12. Please input the valid number and save. Then referesh the page to see the change.', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_featured',
	'type'            	=> 'number',
	'active_callback' 	=> 'travel_insight_pro_is_featured_enable',
	'input_attrs'     	=> array(
		'max' 	=> 12,
		'min' 	=> 3,
		'style' => 'width:100px'
	)
) );

if ( $options['home_layout'] == 'fourth-design' || $options['home_layout'] == 'eight-design' ):

// team content type control and setting
$wp_customize->add_setting( 'travel_insight_pro_theme_options[featured_column_layout]', array(
	'default'          	=> $options['featured_column_layout'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_select',

) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[featured_column_layout]', array(
	'label'             => esc_html__( 'Column Layout', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_featured',
	'type'				=> 'select',
	'active_callback' 	=> 'travel_insight_pro_is_featured_enable',
	'choices'			=> array( 
		'col-3' 		=> esc_html__( '3 Column', 'travel-insight-pro' ),
		'col-4' 		=> esc_html__( '4 Column', 'travel-insight-pro' ),
	),
) );
endif;

// Slider Section category setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[featured_content_category]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_single_category'
) );

$wp_customize->add_control( new Travel_Insight_Pro_Dropdown_Taxonomies_Control( $wp_customize, 'travel_insight_pro_theme_options[featured_content_category]', array(
	'label'           => esc_html__( 'Select Category', 'travel-insight-pro' ),
	'description'     => esc_html__( 'Latest posts from selected category will be shown.', 'travel-insight-pro' ),
	'section'         => 'travel_insight_pro_featured',
	'type'			  => 'dropdown-category',
	'active_callback' => 'travel_insight_pro_featured_content_category',
) ) );

// Slider Section content type post setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[featured_content_post]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_post_ids',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[featured_content_post]', array(
	'active_callback'	=> 'travel_insight_pro_featured_content_post',
	'label'             => esc_html__( 'Input Post Ids', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Simply hover post title on dashboard to see the Post ID. Max no. of posts allowed is 10. ie: 11, 24, 34', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_featured',
	'type'				=> 'text',
) );

for ( $i = 1; $i <= $options['no_of_featured']; $i++ ) {
    // Show page drop-down setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[featured_content_page_'.$i.']', array(
		'sanitize_callback' => 'travel_insight_pro_sanitize_page'
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[featured_content_page_'.$i.']', array(
		'label'           	=> sprintf( esc_html__( 'Select Page %d', 'travel-insight-pro' ), $i ),
		'section'        	=> 'travel_insight_pro_featured',
		'active_callback' 	=> 'travel_insight_pro_featured_content_page',
		'type'				=> 'dropdown-pages'
	) );
}

if ( $options['home_layout'] == 'eight-design' ):

	// Call to action button setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[featured_button]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['featured_button'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[featured_button]', array(
	'label'           	=> esc_html__( 'Button', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_featured',
	'active_callback' 	=> 'travel_insight_pro_is_featured_enable',
	'type'				=> 'text'
) );

endif;

