<?php
/**
 * Latest Post Section options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

$wp_customize->add_section( 'travel_insight_pro_latest_post', array(
	'title'             => esc_html__( 'Latest Post','travel-insight-pro' ),
	'description'       => esc_html__( 'Latest Post Options.', 'travel-insight-pro' ),
	'panel'             => 'travel_insight_pro_sections_panel',
) );

// Latest Post Section enable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[latest_post_enable]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
	'default'          	=> $options['latest_post_enable'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[latest_post_enable]', array(
	'label'            	=> esc_html__( 'Enable Latest Post Section', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_latest_post',
	'type'             	=> 'checkbox',
) );

// Add Latest Post content type setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[latest_post_content_type]', array(
	'default'           => $options['latest_post_content_type'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_select'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[latest_post_content_type]', array(
	'label'           	=> esc_html__( 'Content Type', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_latest_post',
	'type'            	=> 'select',
	'active_callback' 	=> 'travel_insight_pro_is_latest_post_enable',
	'choices'         	=> array(
        'category'  => esc_html__( 'Category', 'travel-insight-pro' ),
        'page'      => esc_html__( 'Page', 'travel-insight-pro' ),
        'post'      => esc_html__( 'Post', 'travel-insight-pro' ),
    ),
) );


// Call to action title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[latest_post_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['latest_post_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[latest_post_title]', array(
	'label'           	=> esc_html__( 'Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_latest_post',
	'active_callback' 	=> 'travel_insight_pro_is_latest_post_enable',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[latest_post_title]', array(
		'selector'            => '#business-latest-posts .business-section-header h2',
		'settings'            => 'travel_insight_pro_theme_options[latest_post_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_latest_post_title_partial',
    ) );
}

if ( $options['home_layout'] !== 'fifth-design' || $options['home_layout'] !== 'sixth-design' ):

// Call to action title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[latest_post_sub_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['latest_post_sub_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[latest_post_sub_title]', array(
	'label'           	=> esc_html__( 'Sub Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_latest_post',
	'active_callback' 	=> 'travel_insight_pro_is_latest_post_enable',
	'type'				=> 'textarea'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[latest_post_sub_title]', array(
		'selector'            => '#business-latest-posts .business-section-header p',
		'settings'            => 'travel_insight_pro_theme_options[latest_post_sub_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_latest_post_sub_title_partial',
    ) );
}

endif;

// Add latest_post number setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[no_of_latest_post]', array(
	'default'           => $options['no_of_latest_post'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_number_range',
	'validate_callback' => 'travel_insight_pro_validate_latest_post_count',
	'transport'			=> 'refresh',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[no_of_latest_post]', array(
	'label'           	=> esc_html__( 'Number of Articles', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Note: Min 3 & Max 9. Please input the valid number and save. Then referesh the page to see the change.', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_latest_post',
	'type'            	=> 'number',
	'active_callback' 	=> 'travel_insight_pro_is_latest_post_enable',
	'input_attrs'     	=> array(
		'max' 	=> 9,
		'min' 	=> 3,
		'style' => 'width:100px'
	)
) );

// Slider Section category setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[latest_post_content_category]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_single_category'
) );

$wp_customize->add_control( new Travel_Insight_Pro_Dropdown_Taxonomies_Control( $wp_customize, 'travel_insight_pro_theme_options[latest_post_content_category]', array(
	'label'           => esc_html__( 'Select Category', 'travel-insight-pro' ),
	'description'     => esc_html__( 'Latest posts from selected category will be shown.', 'travel-insight-pro' ),
	'section'         => 'travel_insight_pro_latest_post',
	'type'			  => 'dropdown-category',
	'active_callback' => 'travel_insight_pro_latest_post_content_category',
) ) );

// Slider Section content type post setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[latest_post_content_post]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_post_ids',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[latest_post_content_post]', array(
	'active_callback'	=> 'travel_insight_pro_latest_post_content_post',
	'label'             => esc_html__( 'Input Post Ids', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Simply hover post title on dashboard to see the Post ID. Max no. of posts allowed is 10. ie: 11, 24, 34', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_latest_post',
	'type'				=> 'text',
) );

for ( $i = 1; $i <= $options['no_of_latest_post']; $i++ ) {
    // Show page drop-down setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[latest_post_content_page_'.$i.']', array(
		'sanitize_callback' => 'travel_insight_pro_sanitize_page'
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[latest_post_content_page_'.$i.']', array(
		'label'           	=> sprintf( esc_html__( 'Select Page %d', 'travel-insight-pro' ), $i ),
		'section'        	=> 'travel_insight_pro_latest_post',
		'active_callback' 	=> 'travel_insight_pro_latest_post_content_page',
		'type'				=> 'dropdown-pages'
	) );
}

if ( $options['home_layout'] !== 'fifth-design' || $options['home_layout'] !== 'sixth-design' ):
// Call to action btn label setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[latest_post_read_more_btn_label]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['latest_post_read_more_btn_label'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[latest_post_read_more_btn_label]', array(
	'label'           	=> esc_html__( 'Button Label', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_latest_post',
	'active_callback' 	=> 'travel_insight_pro_is_latest_post_enable',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[latest_post_read_more_btn_label]', array(
		'selector'            => '#business-latest-posts .business-section-content article .entry-meta .more-link  a',
		'settings'            => 'travel_insight_pro_theme_options[latest_post_read_more_btn_label]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_latest_post_read_more_btn_label_partial',
    ) );
}
endif;
