<?php
/**
 * masonry Section options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0.0
 */

$wp_customize->add_section( 'travel_insight_pro_masonry', array(
	'title'             => esc_html__( 'Masonry','travel-insight-pro' ),
	'description'       => esc_html__( 'Note: To activate this section you need to install WooCommerce Plugin.', 'travel-insight-pro' ),
	'panel'             => 'travel_insight_pro_sections_panel',
) );

// Masonry Section enable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[masonry_section_enable]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
	'default'          	=> $options['masonry_section_enable'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[masonry_section_enable]', array(
	'label'            	=> esc_html__( 'Enable Masonry Section', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_masonry',
	'type'             	=> 'checkbox',
) );

for ( $i = 1; $i <= 4; $i++ ) :

	// Add dropdown category setting and control.
	$wp_customize->add_setting(  'travel_insight_pro_theme_options[masonry_content_masonry_category_'.$i.']', array(
		'sanitize_callback' => 'absint',
		) ) ;

$wp_customize->add_control( new Travel_Insight_Pro_Dropdown_Taxonomies_Control( $wp_customize,'travel_insight_pro_theme_options[masonry_content_masonry_category_'.$i.']', array(
	'label'             => esc_html__( 'Select Masonry Category ', 'travel-insight-pro' ).$i,
	'section'           => 'travel_insight_pro_masonry',
	'taxonomy'			=> 'product_cat',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'travel_insight_pro_is_masonry_section_enable'
	) ) );

endfor;
