<?php
/**
 * Medical Reason Section options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

$wp_customize->add_section( 'travel_insight_pro_medical_reasons', array(
	'title'             => esc_html__( 'Medical Reason','travel-insight-pro' ),
	'description'       => esc_html__( 'Medical Reason Options.', 'travel-insight-pro' ),
	'panel'             => 'travel_insight_pro_sections_panel',
) );

// Medical Reason Section enable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[medical_reasons_enable]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
	'default'          	=> $options['medical_reasons_enable'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[medical_reasons_enable]', array(
	'label'            	=> esc_html__( 'Enable Medical Reason Section', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_medical_reasons',
	'type'             	=> 'checkbox',
) );

// Add Medical Reason content type setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[medical_reasons_content_type]', array(
	'default'           => $options['medical_reasons_content_type'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_select'
	) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[medical_reasons_content_type]', array(
	'label'           	=> esc_html__( 'Content Type', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_medical_reasons',
	'type'            	=> 'select',
	'active_callback' 	=> 'travel_insight_pro_is_medical_reasons_enable',
	'choices'         	=> array(
		'page'      => esc_html__( 'Page', 'travel-insight-pro' ),
		'post'      => esc_html__( 'Post', 'travel-insight-pro' ),
		'custom'    => esc_html__( 'Custom', 'travel-insight-pro' ),
		)
	) );

// about Section content type post setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[medical_reasons_content_post]', array(
	'validate_callback' => 'travel_insight_pro_validate_post_id',
	'sanitize_callback' => 'travel_insight_pro_sanitize_single_post_id',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[medical_reasons_content_post]', array(
	'active_callback'	=> 'travel_insight_pro_medical_reasons_content_post',
	'label'             => esc_html__( 'Input Post Id', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Please Input Valid Post Id. Simply hover post title on dashboard to see the Post ID.', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_medical_reasons',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'style'	=> 'width:100px',
		),
) );

// Show page drop-down setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[medical_reasons_content_page]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_page'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[medical_reasons_content_page]', array(
	'label'           	=> esc_html__( 'Select Page', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_medical_reasons',
	'active_callback' 	=> 'travel_insight_pro_medical_reasons_content_page',
	'type'				=> 'dropdown-pages'
) );

// Medical Reason Section background setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[medical_reasons_content_image]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_image'
) );

$wp_customize->add_control(
	new WP_Customize_Image_Control( $wp_customize, 'travel_insight_pro_theme_options[medical_reasons_content_image]',
		array(
		'label'       		=> esc_html__( 'Select Image', 'travel-insight-pro' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'travel-insight-pro' ), 380, 457 ),
		'section'     		=> 'travel_insight_pro_medical_reasons',
		'active_callback'	=> 'travel_insight_pro_medical_reasons_content_custom',
) ) );

// Medical Reason title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[medical_reasons_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['medical_reasons_title'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[medical_reasons_title]', array(
	'label'           	=> esc_html__( 'Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_medical_reasons',
	'active_callback' 	=> 'travel_insight_pro_medical_reasons_content_custom',
	'type'				=> 'text'
) );

// Medical Reason description setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[medical_reasons_description]', array(
	'sanitize_callback' => 'wp_kses_post',
	'default'          	=> $options['medical_reasons_description'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[medical_reasons_description]', array(
	'label'           	=> esc_html__( 'Description', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_medical_reasons',
	'active_callback' 	=> 'travel_insight_pro_medical_reasons_content_custom',
	'type'				=> 'textarea'
) );

// reason list
$wp_customize->add_setting( 'travel_insight_pro_theme_options[reason_list]', array(
	'sanitize_callback' => 'sanitize_text_field',
	) );

$wp_customize->add_control( new Travel_Insight_Pro_Multi_Input_Custom_Control( $wp_customize, 'travel_insight_pro_theme_options[reason_list]', array(
	'label'             => esc_html__( 'Reasin List ', 'travel-insight-pro' ),
	'button_text'       => esc_html__( 'Add list.', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_medical_reasons',
	'active_callback' 	=> 'travel_insight_pro_is_medical_reasons_enable',
	'type'				=> 'text',
	) ) );