<?php
/**
 * Packages Section options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

$wp_customize->add_section( 'travel_insight_pro_packages', array(
	'title'             => esc_html__( 'Packages','travel-insight-pro' ),
	'description'       => esc_html__( 'Packages Options.', 'travel-insight-pro' ),
	'panel'             => 'travel_insight_pro_sections_panel',
) );

// Packages Section enable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[packages_enable]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
	'default'          	=> $options['packages_enable'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[packages_enable]', array(
	'label'            	=> esc_html__( 'Enable Packages Section', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_packages',
	'type'             	=> 'checkbox',
) );

// Tour title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[packages_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['packages_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[packages_title]', array(
	'label'           	=> esc_html__( 'Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_packages',
	'active_callback' 	=> 'travel_insight_pro_is_packages_enable',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[packages_title]', array(
		'selector'            => '#trip-packages .wrapper .entry-header .entry-title',
		'settings'            => 'travel_insight_pro_theme_options[packages_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_packages_title',
    ) );
}

// Tour title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[packages_sub_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['packages_sub_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[packages_sub_title]', array(
	'label'           	=> esc_html__( 'Sub Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_packages',
	'active_callback' 	=> 'travel_insight_pro_is_packages_enable',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[packages_sub_title]', array(
		'selector'            => '#trip-packages .wrapper .entry-header .sub-title',
		'settings'            => 'travel_insight_pro_theme_options[packages_sub_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_packages_sub_title',
    ) );
}

// Add packages number setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[no_of_packages]', array(
	'default'           => $options['no_of_packages'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_number_range',
	'validate_callback' => 'travel_insight_pro_validate_packages_count',
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[no_of_packages]', array(
	'label'           	=> esc_html__( 'Number of Packages', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 10. Please input the valid number and save. Then referesh the page to see the change.', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_packages',
	'type'            	=> 'number',
	'active_callback' 	=> 'travel_insight_pro_is_packages_enable',
	'input_attrs'     	=> array(
		'max' 	=> 10,
		'min' 	=> 1,
		'style' => 'width:100px'
	)
) );

// Add packages content type setting and control.
// content type options is similar to articles section
$wp_customize->add_setting( 'travel_insight_pro_theme_options[packages_content_type]', array(
	'default'           => $options['packages_content_type'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_select'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[packages_content_type]', array(
	'label'           	=> esc_html__( 'Content Type', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_packages',
	'type'            	=> 'select',
	'active_callback' 	=> 'travel_insight_pro_is_packages_enable',
	'choices'         	=> travel_insight_pro_packages_content_type(),
) );

// Packages category setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[packages_content_category]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_single_category'
) );

$wp_customize->add_control( new Travel_Insight_Pro_Dropdown_Taxonomies_Control( $wp_customize, 'travel_insight_pro_theme_options[packages_content_category]', array(
	'label'           => esc_html__( 'Select Category', 'travel-insight-pro' ),
	'section'         => 'travel_insight_pro_packages',
	'type'			  => 'dropdown-taxonomies',
	'active_callback' => 'travel_insight_pro_packages_content_category',
) ) );

// about Section content type post setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[packages_content_post]', array(
	'validate_callback' => 'travel_insight_pro_validate_post_id',
	'sanitize_callback' => 'travel_insight_pro_sanitize_single_post_id',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[packages_content_post]', array(
	'active_callback'	=> 'travel_insight_pro_packages_content_category',
	'label'             => esc_html__( 'Highlighted Post', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Please Input Valid Post Id. Simply hover post title on dashboard to see the Post ID.', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_packages',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'style'	=> 'width:100px',
		),
) );

// Packages category setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[packages_content_trip_types]', array(
	'sanitize_callback' => 'absint'
) );

$wp_customize->add_control( new Travel_Insight_Pro_Dropdown_Taxonomies_Control( $wp_customize, 'travel_insight_pro_theme_options[packages_content_trip_types]', array(
	'label'           => esc_html__( 'Select Trip Types', 'travel-insight-pro' ),
	'section'         => 'travel_insight_pro_packages',
	'type'			  => 'dropdown-taxonomies',
	'taxonomy'		  => 'itinerary_types',
	'active_callback' => 'travel_insight_pro_packages_content_trip_types',
) ) );

// Packages category setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[packages_content_destination]', array(
	'sanitize_callback' => 'absint'
) );

$wp_customize->add_control( new Travel_Insight_Pro_Dropdown_Taxonomies_Control( $wp_customize, 'travel_insight_pro_theme_options[packages_content_destination]', array(
	'label'           => esc_html__( 'Select Destination', 'travel-insight-pro' ),
	'section'         => 'travel_insight_pro_packages',
	'type'			  => 'dropdown-taxonomies',
	'taxonomy'		  => 'travel_locations',
	'active_callback' => 'travel_insight_pro_packages_content_destination',
) ) );

// Packages category setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[packages_content_destination]', array(
	'sanitize_callback' => 'absint'
) );

$wp_customize->add_control( new Travel_Insight_Pro_Dropdown_Taxonomies_Control( $wp_customize, 'travel_insight_pro_theme_options[packages_content_destination]', array(
	'label'           => esc_html__( 'Select Destination', 'travel-insight-pro' ),
	'section'         => 'travel_insight_pro_packages',
	'type'			  => 'dropdown-taxonomies',
	'taxonomy'		  => 'travel_locations',
	'active_callback' => 'travel_insight_pro_packages_content_destination',
) ) );

// Packages category setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[packages_content_activity]', array(
	'sanitize_callback' => 'absint'
) );

$wp_customize->add_control( new Travel_Insight_Pro_Dropdown_Taxonomies_Control( $wp_customize, 'travel_insight_pro_theme_options[packages_content_activity]', array(
	'label'           => esc_html__( 'Select Activity', 'travel-insight-pro' ),
	'section'         => 'travel_insight_pro_packages',
	'type'			  => 'dropdown-taxonomies',
	'taxonomy'		  => 'activity',
	'active_callback' => 'travel_insight_pro_packages_content_activity',
) ) );

// about Section content type post setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[packages_content_trip_id]', array(
	'validate_callback' => 'travel_insight_pro_validate_post_id',
	'sanitize_callback' => 'absint',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[packages_content_trip_id]', array(
	'active_callback'	=> 'travel_insight_pro_packages_content_trip_id',
	'label'             => esc_html__( 'Highlighted Trip Package', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Please Input Valid Trip Id. Simply hover post title on dashboard to see the Trip ID.', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_packages',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'style'	=> 'width:100px',
		),
) );