<?php
/**
 * Popular Destination Section options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

$wp_customize->add_section( 'travel_insight_pro_popular_destination', array(
	'title'             => esc_html__( 'Popular Destination','travel-insight-pro' ),
	'description'       => esc_html__( 'Popular Destination Options.', 'travel-insight-pro' ),
	'panel'             => 'travel_insight_pro_sections_panel',
) );

// Popular Destination Section enable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[popular_destination_enable]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
	'default'          	=> $options['popular_destination_enable'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[popular_destination_enable]', array(
	'label'            	=> esc_html__( 'Enable Popular Destination Section', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_popular_destination',
	'type'             	=> 'checkbox',
) );

// Popular Destination title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[popular_destination_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['popular_destination_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[popular_destination_title]', array(
	'label'           	=> esc_html__( 'Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_popular_destination',
	'active_callback' 	=> 'travel_insight_pro_is_popular_destination_enable',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[popular_destination_title]', array(
		'selector'            => '#popular-destinations .wrapper .entry-header h2.entry-title',
		'settings'            => 'travel_insight_pro_theme_options[popular_destination_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_popular_destination_title',
    ) );
}

// Popular Destination title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[popular_destination_sub_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['popular_destination_sub_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[popular_destination_sub_title]', array(
	'label'           	=> esc_html__( 'Sub Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_popular_destination',
	'active_callback' 	=> 'travel_insight_pro_is_popular_destination_enable',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[popular_destination_sub_title]', array(
		'selector'            => '#popular-destinations .wrapper .entry-header h3.sub-title',
		'settings'            => 'travel_insight_pro_theme_options[popular_destination_sub_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_popular_destination_sub_title',
    ) );
}

// Add popular destination content type setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[popular_destination_content_type]', array(
	'default'           => $options['popular_destination_content_type'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_select'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[popular_destination_content_type]', array(
	'label'           	=> esc_html__( 'Content Type', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_popular_destination',
	'type'            	=> 'select',
	'active_callback' 	=> 'travel_insight_pro_is_popular_destination_enable',
	'choices'         	=> travel_insight_pro_popular_destination_content_type()
) );

// Add popular destination number setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[no_of_popular_destination]', array(
	'default'           => $options['no_of_popular_destination'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_number_range',
	'validate_callback' => 'travel_insight_pro_validate_popular_destination_count',
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[no_of_popular_destination]', array(
	'label'           	=> esc_html__( 'Number of Destinations', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 7. Please input the valid number and save. Then referesh the page to see the change.', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_popular_destination',
	'type'            	=> 'number',
	'active_callback' 	=> 'travel_insight_pro_popular_destination_show_count',
	'input_attrs'     	=> array(
		'max' 	=> 7,
		'min' 	=> 1,
		'style' => 'width:100px'
	)
) );

// Popular Destination category setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[popular_destination_content_category]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_single_category'
) );

$wp_customize->add_control( new Travel_Insight_Pro_Dropdown_Taxonomies_Control( $wp_customize, 'travel_insight_pro_theme_options[popular_destination_content_category]', array(
	'label'           => esc_html__( 'Select Category', 'travel-insight-pro' ),
	'description'     => esc_html__( 'Latest posts from selected category will be shown.', 'travel-insight-pro' ),
	'section'         => 'travel_insight_pro_popular_destination',
	'type'			  => 'dropdown-category',
	'active_callback' => 'travel_insight_pro_popular_destination_content_category',
) ) );

// Popular Destination content type post setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[popular_destination_content_post]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_post_ids',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[popular_destination_content_post]', array(
	'active_callback'	=> 'travel_insight_pro_popular_destination_content_post',
	'label'             => esc_html__( 'Input Post Ids', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Simply hover post title on dashboard to see the Post ID. Max no. of posts allowed is 7. ie: 11, 24, 34', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_popular_destination',
	'type'				=> 'text'
) );

// Popular Destination content type trips setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[popular_destination_content_trip]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_post_ids',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[popular_destination_content_trip]', array(
	'active_callback'	=> 'travel_insight_pro_popular_destination_content_trip',
	'label'             => esc_html__( 'Input Trip Ids', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Simply hover trips title on dashboard to see the Trip ID. Max no. of posts allowed is 7. ie: 11, 24, 34', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_popular_destination',
	'type'				=> 'text'
) );

// Popular Destination content type destination setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[popular_destination_content_destination]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_post_ids',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[popular_destination_content_destination]', array(
	'active_callback'	=> 'travel_insight_pro_popular_destination_content_destination',
	'label'             => esc_html__( 'Input Destination Ids', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Simply hover post title on dashboard to see the Post ID. Max no. of posts allowed is 7. ie: 11, 24, 34', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_popular_destination',
	'type'				=> 'text'
) );

// Popular Destination content type package setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[popular_destination_content_package]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_post_ids',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[popular_destination_content_package]', array(
	'active_callback'	=> 'travel_insight_pro_popular_destination_content_package',
	'label'             => esc_html__( 'Input Package Ids', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Simply hover post title on dashboard to see the Post ID. Max no. of posts allowed is 7. ie: 11, 24, 34', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_popular_destination',
	'type'				=> 'text'
) );

// Popular Destination package category setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[popular_destination_content_package_category]', array(
	'sanitize_callback' => 'absint'
) );

$wp_customize->add_control( new Travel_Insight_Pro_Dropdown_Taxonomies_Control( $wp_customize, 'travel_insight_pro_theme_options[popular_destination_content_package_category]', array(
	'label'           => esc_html__( 'Select Package Category', 'travel-insight-pro' ),
	'description'     => esc_html__( 'Latest posts from selected category will be shown.', 'travel-insight-pro' ),
	'section'         => 'travel_insight_pro_popular_destination',
	'taxonomy'		  => 'tp-package-category',
	'type'			  => 'dropdown-category',
	'active_callback' => 'travel_insight_pro_popular_destination_content_package_category',
) ) );

// Popular Destination trip types setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[popular_destination_content_trip_types]', array(
	'sanitize_callback' => 'absint'
) );

$wp_customize->add_control( new Travel_Insight_Pro_Dropdown_Taxonomies_Control( $wp_customize, 'travel_insight_pro_theme_options[popular_destination_content_trip_types]', array(
	'label'           => esc_html__( 'Select Trip Types', 'travel-insight-pro' ),
	'description'     => esc_html__( 'Latest posts from selected category will be shown.', 'travel-insight-pro' ),
	'section'         => 'travel_insight_pro_popular_destination',
	'taxonomy'		  => 'itinerary_types',
	'type'			  => 'dropdown-category',
	'active_callback' => 'travel_insight_pro_popular_destination_content_trip_types',
) ) );

// Popular Destination page setting and control
for ( $i = 1; $i <= $options['no_of_popular_destination']; $i++ ) {
	// Show page drop-down setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[popular_destination_content_page_'.$i.']', array(
		'sanitize_callback' => 'travel_insight_pro_sanitize_page'
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[popular_destination_content_page_'.$i.']', array(
		'label'           	=> sprintf( esc_html__( 'Select Page %d', 'travel-insight-pro' ), $i ),
		'section'        	=> 'travel_insight_pro_popular_destination',
		'active_callback' 	=> 'travel_insight_pro_popular_destination_content_page',
		'type'				=> 'dropdown-pages'
	) );
}