<?php
/**
 * Recent Product Section options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

$wp_customize->add_section( 'travel_insight_pro_recent_product', array(
	'title'             => esc_html__( 'Recent Product','travel-insight-pro' ),
	'description'       => esc_html__( 'Recent Product Section Options.', 'travel-insight-pro' ),
	'panel'             => 'travel_insight_pro_sections_panel',
) );

// Recent Product Section enable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[recent_product_enable]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
	'default'          	=> $options['recent_product_enable'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[recent_product_enable]', array(
	'label'            	=> esc_html__( 'Enable Recent Product Section', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_recent_product',
	'type'             	=> 'checkbox',
) );

// Call to action title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[recent_product_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['recent_product_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[recent_product_title]', array(
	'label'           	=> esc_html__( 'Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_recent_product',
	'active_callback' 	=> 'travel_insight_pro_is_recent_product_enable',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[recent_product_title]', array(
		'selector'            => '#recent-products h2.shop-section-title',
		'settings'            => 'travel_insight_pro_theme_options[recent_product_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_recent_product_title_partial',
    ) );
}

// Call to action title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[recent_product_subtitle]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['recent_product_subtitle'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[recent_product_subtitle]', array(
	'label'           	=> esc_html__( 'Sub Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_recent_product',
	'active_callback' 	=> 'travel_insight_pro_is_recent_product_enable',
	'type'				=> 'textarea'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[recent_product_subtitle]', array(
		'selector'            => '#recent-products p.shop-subtitle',
		'settings'            => 'travel_insight_pro_theme_options[recent_product_subtitle]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_recent_product_subtitle_partial',
    ) );
}

// Add recent_product content type setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[recent_product_content_type]', array(
	'default'           => $options['recent_product_content_type'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_select'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[recent_product_content_type]', array(
	'label'           	=> esc_html__( 'Content Type', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_recent_product',
	'type'            	=> 'select',
	'active_callback' 	=> 'travel_insight_pro_is_recent_product_enable',
	'choices'         	=> travel_insight_pro_recent_product_content_type()
) );

// Add recent_product number setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[no_of_recent_product]', array(
	'default'           => $options['no_of_recent_product'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_number_range',
	'validate_callback' => 'travel_insight_pro_validate_recent_product_count',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[no_of_recent_product]', array(
	'label'           	=> esc_html__( 'Number of Products', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 12. Please input the valid number and save. Then referesh the page to see the change.', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_recent_product',
	'type'            	=> 'number',
	'active_callback' 	=> 'travel_insight_pro_is_recent_product_enable',
	'input_attrs'     	=> array(
		'max' 	=> 12,
		'min' 	=> 1,
		'style' => 'width:100px'
	)
) );

// Recent Product Section content type product setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[recent_product_content_product]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_post_ids',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[recent_product_content_product]', array(
	'label'             => esc_html__( 'Input Product Ids', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Simply hover product title on dashboard to see the Product ID. ie: 11, 24, 34', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_recent_product',
	'active_callback'	=> 'travel_insight_pro_is_recent_product_section_content_product',
	'type'				=> 'text',
) );

// Add dropdown product category setting and control.
$wp_customize->add_setting(  'travel_insight_pro_theme_options[recent_product_content_product_category]', array(
	'sanitize_callback' => 'absint',
) ) ;

$wp_customize->add_control( new Travel_Insight_Pro_Dropdown_Taxonomies_Control( $wp_customize,'travel_insight_pro_theme_options[recent_product_content_product_category]', array(
	'label'             => esc_html__( 'Select Product Category', 'travel-insight-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_recent_product',
	'type'              => 'dropdown-taxonomies',
	'taxonomy'          => 'product_cat',
	'active_callback'	=> 'travel_insight_pro_is_recent_product_section_content_product_category'
) ) );