<?php
/**
 * Service Section options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

$wp_customize->add_section( 'travel_insight_pro_service', array(
	'title'             => esc_html__( 'Service','travel-insight-pro' ),
	'description'       => esc_html__( 'Service Options.', 'travel-insight-pro' ),
	'panel'             => 'travel_insight_pro_sections_panel',
) );

// Service Section enable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[service_enable]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
	'default'          	=> $options['service_enable'],

) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[service_enable]', array(
	'label'            	=> esc_html__( 'Enable Service Section', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_service',
	'type'             	=> 'checkbox',
) );

if( $options['home_layout'] == 'seven-design' || $options['home_layout'] == 'eight-design' ):
// Call to action title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[service_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['service_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[service_title]', array(
	'label'           	=> esc_html__( 'Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_service',
	'active_callback' 	=> 'travel_insight_pro_is_service_enable',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[service_title]', array(
		'selector'            => '#survival h2.entry-title',
		'settings'            => 'travel_insight_pro_theme_options[service_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_service_title_partial',
    ) );
}

// Call to action description setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[service_description]', array(
	'sanitize_callback' => 'wp_kses_post',
	'default'          	=> $options['service_description'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[service_description]', array(
	'label'           	=> esc_html__( 'Description', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_service',
	'active_callback' 	=> 'travel_insight_pro_is_service_enable',
	'type'				=> 'textarea'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[service_description]', array(
		'selector'            => '#survival h3.sub-title',
		'settings'            => 'travel_insight_pro_theme_options[service_description]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_service_description_partial',
    ) );
}

endif;


// Add Service content type setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[service_content_type]', array(
	'default'           => $options['service_content_type'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_select'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[service_content_type]', array(
	'label'           	=> esc_html__( 'Content Type', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_service',
	'type'            	=> 'select',
	'active_callback' 	=> 'travel_insight_pro_is_service_enable',
	'choices'         	=> array(
        'category'  => esc_html__( 'Category', 'travel-insight-pro' ),
        'page'      => esc_html__( 'Page', 'travel-insight-pro' ),
        'post'      => esc_html__( 'Post', 'travel-insight-pro' ),
    ),
) );


// Add service number setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[no_of_service]', array(
	'default'           => $options['no_of_service'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_number_range',
	'validate_callback' => 'travel_insight_pro_validate_service_count'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[no_of_service]', array(
	'label'           	=> esc_html__( 'Number of Articles', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Note: Min 3 & Max 12. Please input the valid number and save. Then referesh the page to see the change.', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_service',
	'type'            	=> 'number',
	'active_callback' 	=> 'travel_insight_pro_is_service_enable',
	'input_attrs'     	=> array(
		'max' 	=> 12,
		'min' 	=> 3,
		'style' => 'width:100px'
	)
) );

// Service Section category setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[service_content_category]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_single_category'
) );

$wp_customize->add_control( new Travel_Insight_Pro_Dropdown_Taxonomies_Control( $wp_customize, 'travel_insight_pro_theme_options[service_content_category]', array(
	'label'           => esc_html__( 'Select Category', 'travel-insight-pro' ),
	'description'     => esc_html__( 'Latest posts from selected category will be shown.', 'travel-insight-pro' ),
	'section'         => 'travel_insight_pro_service',
	'type'			  => 'dropdown-category',
	'active_callback' => 'travel_insight_pro_service_content_category',
) ) );

// service Section content type post setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[service_content_post]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_post_ids',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[service_content_post]', array(
	'label'             => esc_html__( 'Input Post Ids', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Simply hover post title on dashboard to see the Post ID. Max no. of posts allowed is 10. ie: 11, 24, 34', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_service',
	'active_callback'	=> 'travel_insight_pro_service_content_post',
	'type'				=> 'text',
) );

for ( $i = 1; $i <= $options['no_of_service']; $i++ ) {

	$wp_customize->add_setting( 'travel_insight_pro_theme_options[service_content_icon_' . $i . ']', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( new Travel_Insight_Pro_Icon_Picker( $wp_customize, 'travel_insight_pro_theme_options[service_content_icon_' . $i . ']', array(
			'label'             => sprintf( esc_html__( 'Select Icon %d', 'travel-insight-pro' ), $i ),
			'section'           => 'travel_insight_pro_service',
			'active_callback'	=> 'travel_insight_pro_is_service_enable',
		) ) );

    // Show page drop-down setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[service_content_page_'.$i.']', array(
		'sanitize_callback' => 'travel_insight_pro_sanitize_page'
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[service_content_page_'.$i.']', array(
		'label'           	=> sprintf( esc_html__( 'Select Page %d', 'travel-insight-pro' ), $i ),
		'section'        	=> 'travel_insight_pro_service',
		'active_callback' 	=> 'travel_insight_pro_service_content_page',
		'type'				=> 'dropdown-pages'
	) );
}

if( $options['home_layout'] == 'seven-design' || $options['home_layout'] == 'eight-design' ):

// service btn title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[service_btn_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['service_btn_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[service_btn_title]', array(
	'label'           	=> esc_html__( 'Button Label', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_service',
	'active_callback' 	=> 'travel_insight_pro_is_service_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[service_btn_title]', array(
		'selector'            => '#survival div.text-center a.more-link',
		'settings'            => 'travel_insight_pro_theme_options[service_btn_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_service_btn_title_partial',
    ) );
}

// service btn title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[service_btn_url]', array(
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[service_btn_url]', array(
	'label'           	=> esc_html__( 'Button Url', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_service',
	'active_callback' 	=> 'travel_insight_pro_is_service_enable',
	'type'				=> 'url',
) );

endif;