<?php
/**
 * Slider Section options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

$wp_customize->add_section( 'travel_insight_pro_slider', array(
	'title'             => esc_html__( 'Featured Slider','travel-insight-pro' ),
	'description'       => esc_html__( 'Slider Section Options.', 'travel-insight-pro' ),
	'panel'             => 'travel_insight_pro_sections_panel',
) );

// Slider Section enable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[slider_enable]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
	'default'          	=> $options['slider_enable'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[slider_enable]', array(
	'label'            	=> esc_html__( 'Enable Slider Section', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_slider',
	'type'             	=> 'checkbox',
) );

$wp_customize->add_setting( 'travel_insight_pro_theme_options[slider_social_menu_enable]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
	'default'          	=> $options['slider_social_menu_enable'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[slider_social_menu_enable]', array(
	'label'            	=> esc_html__( 'Enable Social Menu', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_slider',
	'type'             	=> 'checkbox',
) );

// Slider caption enable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[slider_caption_enable]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
	'default'          	=> $options['slider_caption_enable'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[slider_caption_enable]', array(
	'label'            	=> esc_html__( 'Enable Slider Caption', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_slider',
	'type'             	=> 'checkbox',
	'active_callback' 	=> 'travel_insight_pro_is_slider_enable',
) );

// Slider Search enable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[slider_search_enable]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
	'default'          	=> $options['slider_search_enable'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[slider_search_enable]', array(
	'label'            	=> esc_html__( 'Enable Search Field', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_slider',
	'type'             	=> 'checkbox',
	'active_callback' 	=> 'travel_insight_pro_is_slider_enable',
) );

// Slider effect setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[slider_effect]', array(
	'default'          	=> $options['slider_effect'],
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_select',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[slider_effect]', array(
	'label'            	=> esc_html__( 'Slider Effect', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_slider',
	'type'             	=> 'select',
	'active_callback'	=> 'travel_insight_pro_is_slider_enable',
	'choices'			=> travel_insight_pro_slider_effect(),
) );

// Add slider transition duration setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[slider_transition_duration]', array(
	'default'           => $options['slider_transition_duration'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_select'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[slider_transition_duration]', array(
	'label'           	=> esc_html__( 'Transition Duration', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_slider',
	'type'            	=> 'select',
	'active_callback' 	=> 'travel_insight_pro_is_slider_enable',
	'choices'         	=> travel_insight_pro_slider_transition_duration(),
) );

// Add enable arrow controls setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[enable_slider_controls]', array(
	'default'           => $options['enable_slider_controls'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_checkbox'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[enable_slider_controls]', array(
	'label'           	=> esc_html__( 'Enable Arrow Controls', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_slider',
	'type'            	=> 'checkbox',
	'active_callback' 	=> 'travel_insight_pro_is_slider_enable',
) );

// Add enable slider dragable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[enable_slider_dragable]', array(
	'default'           => $options['enable_slider_dragable'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_checkbox'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[enable_slider_dragable]', array(
	'label'           	=> esc_html__( 'Slider Draggable', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_slider',
	'type'            	=> 'checkbox',
	'active_callback' 	=> 'travel_insight_pro_is_slider_enable',
) );

// Add enable slider pause on hover setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[slider_pause_on_hover]', array(
	'default'           => $options['slider_pause_on_hover'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_checkbox'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[slider_pause_on_hover]', array(
	'label'           	=> esc_html__( 'Pause On Hover', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_slider',
	'type'            	=> 'checkbox',
	'active_callback' 	=> 'travel_insight_pro_is_slider_enable',
) );

// Add enable slider auto play setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[slider_autoplay]', array(
	'default'           => $options['slider_autoplay'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_checkbox'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[slider_autoplay]', array(
	'label'           	=> esc_html__( 'Auto Play', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_slider',
	'type'            	=> 'checkbox',
	'active_callback' 	=> 'travel_insight_pro_is_slider_enable',
) );

if($options['home_layout'] == 'default-design'){
	// Slider caption enable setting and control.
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[slider_wp_travel_filter_enable]', array(
		'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
		'default'          	=> $options['slider_wp_travel_filter_enable'],
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[slider_wp_travel_filter_enable]', array(
		'label'            	=> esc_html__( 'Enable Wp Travel Search Filter', 'travel-insight-pro' ),
		'section'          	=> 'travel_insight_pro_slider',
		'type'             	=> 'checkbox',
	) );
}

// Slider post hr setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[slider_hr]', array(
	'sanitize_callback' => 'sanitize_text_field'
) );

$wp_customize->add_control( new Travel_Insight_Pro_Customize_Horizontal_Line( $wp_customize, 'travel_insight_pro_theme_options[slider_hr]',
	array(
		'section'         => 'travel_insight_pro_slider',
		'active_callback' => 'travel_insight_pro_is_slider_enable',
		'type'			  => 'hr'
) ) );

// Add slider type setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[slider_layout]', array(
	'default'           => $options['slider_layout'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_select'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[slider_layout]', array(
	'label'           	=> esc_html__( 'Slider Type', 'travel-insight-pro' ),
	'description'     	=> esc_html__( 'Select slider layout', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_slider',
	'type'            	=> 'select',
	'active_callback' 	=> 'travel_insight_pro_is_slider_enable',
	'choices'         	=> travel_insight_pro_slider_layout()
) );

// Slider Section background setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[slider_background]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_image'
) );

$wp_customize->add_control(
	new WP_Customize_Image_Control( $wp_customize, 'travel_insight_pro_theme_options[slider_background]',
		array(
		'label'       		=> esc_html__( 'Select Slider Background', 'travel-insight-pro' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'travel-insight-pro' ), 1700, 750 ),
		'section'     		=> 'travel_insight_pro_slider',
		'active_callback'	=> 'travel_insight_pro_slider_layout_sticky',
) ) );

// Add slider content type setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[slider_content_type]', array(
	'default'           => $options['slider_content_type'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_select'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[slider_content_type]', array(
	'label'           	=> esc_html__( 'Content Type', 'travel-insight-pro' ),
	'description'     	=> esc_html__( 'Recommended slider image size is 1500x844 px', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_slider',
	'type'            	=> 'select',
	'active_callback' 	=> 'travel_insight_pro_is_slider_enable',
	'choices'         	=> travel_insight_pro_slider_content_type()
) );

// Slider Section content type post setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[slider_content_post]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_post_ids',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[slider_content_post]', array(
	'active_callback'	=> 'travel_insight_pro_slider_content_post',
	'label'             => esc_html__( 'Input Post Ids', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Simply hover post title on dashboard to see the Post ID. Max no. of posts allowed is 10. ie: 11, 24, 34', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_slider',
	'type'				=> 'text',
) );

// Add slider number setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[no_of_slider]', array(
	'default'           => $options['no_of_slider'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_number_range',
	'validate_callback' => 'travel_insight_pro_validate_slider_count',
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[no_of_slider]', array(
	'label'           	=> esc_html__( 'Number of Slides', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 10. Please input the valid number and save. Then referesh the page to see the change.', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_slider',
	'type'            	=> 'number',
	'active_callback' 	=> 'travel_insight_pro_slider_count',
	'input_attrs'     	=> array(
		'max' 	=> 10,
		'min' 	=> 1,
		'style' => 'width:100px'
	)
) );

// Slider Section category setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[slider_content_category]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_single_category'
) );

$wp_customize->add_control( new Travel_Insight_Pro_Dropdown_Taxonomies_Control( $wp_customize, 'travel_insight_pro_theme_options[slider_content_category]', array(
	'label'           => esc_html__( 'Select Category', 'travel-insight-pro' ),
	'description'     => esc_html__( 'Latest posts from selected category will be shown.', 'travel-insight-pro' ),
	'section'         => 'travel_insight_pro_slider',
	'type'			  => 'dropdown-category',
	'active_callback' => 'travel_insight_pro_slider_content_category',
) ) );

// Slider Section content type product setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[slider_content_product]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_post_ids',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[slider_content_product]', array(
	'label'             => esc_html__( 'Input Product Ids', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Simply hover product title on dashboard to see the Product ID. ie: 11, 24, 34', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_slider',
	'active_callback'	=> 'travel_insight_pro_is_slider_section_content_product',
	'type'				=> 'text',
) );

// Add dropdown product category setting and control.
$wp_customize->add_setting(  'travel_insight_pro_theme_options[slider_content_product_category]', array(
	'sanitize_callback' => 'absint',
) ) ;

$wp_customize->add_control( new Travel_Insight_Pro_Dropdown_Taxonomies_Control( $wp_customize,'travel_insight_pro_theme_options[slider_content_product_category]', array(
	'label'             => esc_html__( 'Select Product Category', 'travel-insight-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_slider',
	'type'              => 'dropdown-taxonomies',
	'taxonomy'          => 'product_cat',
	'active_callback'	=> 'travel_insight_pro_is_slider_section_content_product_category'
) ) );

// Slider Section page setting and control
for ( $i = 1; $i <= $options['no_of_slider']; $i++ ) {
	// Show page drop-down setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[slider_content_page_'.$i.']', array(
		'sanitize_callback' => 'travel_insight_pro_sanitize_page'
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[slider_content_page_'.$i.']', array(
		'label'           	=> sprintf( esc_html__( 'Select Page %d', 'travel-insight-pro' ), $i ),
		'section'        	=> 'travel_insight_pro_slider',
		'active_callback' 	=> 'travel_insight_pro_slider_content_page',
		'type'				=> 'dropdown-pages'
	) );

	// Slider Section background setting and control.
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[slider_content_image_' . $i . ']', array(
		'sanitize_callback' => 'travel_insight_pro_sanitize_image'
	) );

	$wp_customize->add_control(
		new WP_Customize_Image_Control( $wp_customize, 'travel_insight_pro_theme_options[slider_content_image_' . $i . ']',
			array(
			'label'       		=> sprintf( esc_html__( 'Select Image %d', 'travel-insight-pro' ), $i ),
			'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'travel-insight-pro' ), 1700, 750 ),
			'section'     		=> 'travel_insight_pro_slider',
			'active_callback'	=> 'travel_insight_pro_slider_layout_normal_custom',
	) ) );

	// Slider custom title setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[slider_content_custom_title_'.$i.']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[slider_content_custom_title_'.$i.']', array(
		'label'           	=> sprintf( esc_html__( 'Input Title %d', 'travel-insight-pro' ), $i ),
		'section'        	=> 'travel_insight_pro_slider',
		'active_callback' 	=> 'travel_insight_pro_slider_content_custom',
		'type'				=> 'text'
	) );

	// Slider custom sub title setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[slider_content_custom_sub_title_'.$i.']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[slider_content_custom_sub_title_'.$i.']', array(
		'label'           	=> sprintf( esc_html__( 'Input Sub Title %d', 'travel-insight-pro' ), $i ),
		'section'        	=> 'travel_insight_pro_slider',
		'active_callback' 	=> 'travel_insight_pro_slider_content_custom',
		'type'				=> 'text'
	) );

	// Slider custom sub title setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[slider_content_custom_url_'.$i.']', array(
		'sanitize_callback' => 'esc_url_raw'
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[slider_content_custom_url_'.$i.']', array(
		'label'           	=> sprintf( esc_html__( 'Input Link URL %d', 'travel-insight-pro' ), $i ),
		'section'        	=> 'travel_insight_pro_slider',
		'active_callback' 	=> 'travel_insight_pro_slider_content_custom',
		'type'				=> 'url'
	) );

	// team post hr setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[slider_custom_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Travel_Insight_Pro_Customize_Horizontal_Line( $wp_customize, 'travel_insight_pro_theme_options[slider_custom_hr_'. $i .']',
		array(
			'section'         => 'travel_insight_pro_slider',
			'active_callback' => 'travel_insight_pro_slider_content_custom',
			'type'			  => 'hr'
	) ) );
}

