<?php
/**
 * top_bar Section options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0.0
 */

// Add top_bar section
$wp_customize->add_section( 'travel_insight_pro_top_bar_section', array(
	'title'             =>	esc_html__( 'Top Bar', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Top Bar Section options.', 'travel-insight-pro' ),
	'panel'             => 'travel_insight_pro_sections_panel',
) );
// Slider Section background setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[top_bar_ads_image]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_image',
) );

$wp_customize->add_control(
	new WP_Customize_Image_Control( $wp_customize, 'travel_insight_pro_theme_options[top_bar_ads_image]',
		array(
		'label'       		=> esc_html__( 'Select Ads Image', 'travel-insight-pro' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'travel-insight-pro' ), 1080, 176 ),
		'section'     		=> 'travel_insight_pro_top_bar_section',
) ) );

// Two Column btn link setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[top_bar_ads_url]', array(
	'sanitize_callback' => 'esc_url_raw',
	'default'          	=> '#',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[top_bar_ads_url]', array(
	'label'           	=> esc_html__( 'Ads image URL', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_top_bar_section',
	'type'				=> 'text'
) );