<?php
/**
 * Tours Section options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

$wp_customize->add_section( 'travel_insight_pro_tours', array(
	'title'             => esc_html__( 'Tours','travel-insight-pro' ),
	'description'       => esc_html__( 'Tours Options.', 'travel-insight-pro' ),
	'panel'             => 'travel_insight_pro_sections_panel',
) );

// Tours Section enable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[tours_enable]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
	'default'          	=> $options['tours_enable'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[tours_enable]', array(
	'label'            	=> esc_html__( 'Enable Tours Section', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_tours',
	'type'             	=> 'checkbox',
) );

if ( $options['home_layout'] !== 'third-design' ):

// Tour title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[tours_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['tours_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[tours_title]', array(
	'label'           	=> esc_html__( 'Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_tours',
	'active_callback' 	=> 'travel_insight_pro_is_tours_enable',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[tours_title]', array(
		'selector'            => '#tour .wrapper .tour-details .entry-header h2.entry-title',
		'settings'            => 'travel_insight_pro_theme_options[tours_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_tours_title',
    ) );
}

// Tour title setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[tours_sub_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['tours_sub_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[tours_sub_title]', array(
	'label'           	=> esc_html__( 'Sub Title', 'travel-insight-pro' ),
	'section'        	=> 'travel_insight_pro_tours',
	'active_callback' 	=> 'travel_insight_pro_is_tours_enable',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[tours_sub_title]', array(
		'selector'            => '#tour .wrapper .tour-details .entry-header h3.sub-title',
		'settings'            => 'travel_insight_pro_theme_options[tours_sub_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_tours_sub_title',
    ) );
}

endif;

// Add tours content type setting and control.
// content type options is similar to articles section
$wp_customize->add_setting( 'travel_insight_pro_theme_options[tours_content_type]', array(
	'default'           => $options['tours_content_type'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_select'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[tours_content_type]', array(
	'label'           	=> esc_html__( 'Content Type', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_tours',
	'type'            	=> 'select',
	'active_callback' 	=> 'travel_insight_pro_is_tours_enable',
	'choices'         	=> travel_insight_pro_tours_content_type(),
) );

// Tours category setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[tours_content_category]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_category_list'
) );

$wp_customize->add_control( new Travel_Insight_Pro_Dropdown_Category_Control( $wp_customize, 'travel_insight_pro_theme_options[tours_content_category]', array(
	'label'           => esc_html__( 'Select Multiple Categories', 'travel-insight-pro' ),
	'description'     => esc_html__( 'Note: Press Shift and Click on multiple categories to select. Selected categories will be shown.', 'travel-insight-pro' ),
	'section'         => 'travel_insight_pro_tours',
	'type'			  => 'dropdown-categories',
	'active_callback' => 'travel_insight_pro_tours_content_category',
) ) );

// Tours category setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[tours_content_package_category]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_integers'
) );

$wp_customize->add_control( new Travel_Insight_Pro_Dropdown_Category_Control( $wp_customize, 'travel_insight_pro_theme_options[tours_content_package_category]', array(
	'label'           => esc_html__( 'Select Multiple Package Categories', 'travel-insight-pro' ),
	'description'     => esc_html__( 'Note: Press Ctrl and Click on multiple categories to select. Selected categories will be shown.', 'travel-insight-pro' ),
	'section'         => 'travel_insight_pro_tours',
	'taxonomy'        => 'tp-package-category',
	'type'			  => 'dropdown-categories',
	'active_callback' => 'travel_insight_pro_tours_content_package_category',
) ) );

// Tours category setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[tours_content_destination]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_integers'
) );

$wp_customize->add_control( new Travel_Insight_Pro_Dropdown_Category_Control( $wp_customize, 'travel_insight_pro_theme_options[tours_content_destination]', array(
	'label'           => esc_html__( 'Select Multiple Destinations', 'travel-insight-pro' ),
	'description'     => esc_html__( 'Note: Press Ctrl and Click on multiple categories to select. Selected categories will be shown.', 'travel-insight-pro' ),
	'section'         => 'travel_insight_pro_tours',
	'taxonomy'        => 'travel_locations',
	'type'			  => 'dropdown-categories',
	'active_callback' => 'travel_insight_pro_tours_content_destination',
) ) );

// Tours category setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[tours_content_activity]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_integers'
) );

$wp_customize->add_control( new Travel_Insight_Pro_Dropdown_Category_Control( $wp_customize, 'travel_insight_pro_theme_options[tours_content_activity]', array(
	'label'           => esc_html__( 'Select Multiple Activities', 'travel-insight-pro' ),
	'description'     => esc_html__( 'Note: Press Ctrl and Click on multiple categories to select. Selected categories will be shown.', 'travel-insight-pro' ),
	'section'         => 'travel_insight_pro_tours',
	'taxonomy'        => 'activity',
	'type'			  => 'dropdown-categories',
	'active_callback' => 'travel_insight_pro_tours_content_activity',
) ) );

// Tours category setting and control
$wp_customize->add_setting( 'travel_insight_pro_theme_options[tours_content_trip_types]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_integers'
) );

$wp_customize->add_control( new Travel_Insight_Pro_Dropdown_Category_Control( $wp_customize, 'travel_insight_pro_theme_options[tours_content_trip_types]', array(
	'label'           => esc_html__( 'Select Multiple Trip Types', 'travel-insight-pro' ),
	'description'     => esc_html__( 'Note: Press Ctrl and Click on multiple categories to select. Selected categories will be shown.', 'travel-insight-pro' ),
	'section'         => 'travel_insight_pro_tours',
	'taxonomy'        => 'itinerary_types',
	'type'			  => 'dropdown-categories',
	'active_callback' => 'travel_insight_pro_tours_content_trip_types',
) ) );

// Add tours number setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[no_of_tours]', array(
	'default'           => $options['no_of_tours'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_number_range',
	'validate_callback' => 'travel_insight_pro_validate_tours_count',
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[no_of_tours]', array(
	'label'           	=> esc_html__( 'Number of Tours', 'travel-insight-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 10. Please input the valid number and save. Then referesh the page to see the change.', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_tours',
	'type'            	=> 'number',
	'active_callback' 	=> 'travel_insight_pro_tours_content_custom',
	'input_attrs'     	=> array(
		'max' 	=> 10,
		'min' 	=> 1,
		'style' => 'width:100px'
	)
) );

// content type options is similar to articles section
$wp_customize->add_setting( 'travel_insight_pro_theme_options[tours_custom_icon_image]', array(
	'default'           => $options['tours_custom_icon_image'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_select'
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[tours_custom_icon_image]', array(
	'label'           	=> esc_html__( 'Select Icon Type', 'travel-insight-pro' ),
	'section'         	=> 'travel_insight_pro_tours',
	'type'            	=> 'radio',
	'active_callback' 	=> 'travel_insight_pro_tours_content_custom',
	'choices'         	=> travel_insight_pro_tours_icon_type(),
) );

for ( $i = 1; $i <= $options['no_of_tours']; $i++ ) {

	// Tour hr setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[tours_custom_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Travel_Insight_Pro_Customize_Horizontal_Line( $wp_customize, 'travel_insight_pro_theme_options[tours_custom_hr_'. $i .']',
		array(
			'section'         => 'travel_insight_pro_tours',
			'active_callback' => 'travel_insight_pro_tours_content_custom',
			'type'			  => 'hr'
	) ) );

	// Tour label setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[tours_label_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'			=> $options['tours_label'],
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[tours_label_'. $i .']', array(
		'label'           	=> sprintf( esc_html__( 'Tour Label %d', 'travel-insight-pro' ), $i ),
		'section'        	=> 'travel_insight_pro_tours',
		'active_callback' 	=> 'travel_insight_pro_tours_content_custom',
		'type'				=> 'text'
	) );

	// Tour url setting and control
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[tours_link_'. $i .']', array(
		'sanitize_callback' => 'esc_url_raw',
		'default'			=> $options['tours_link'],
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[tours_link_'. $i .']', array(
		'label'           	=> sprintf( esc_html__( 'Tour link %d', 'travel-insight-pro' ), $i ),
		'section'        	=> 'travel_insight_pro_tours',
		'active_callback' 	=> 'travel_insight_pro_tours_content_custom',
		'type'				=> 'url'
	) );

	// Add tours content type setting and control.
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[tours_icon_' . $i . ']', array(
		'sanitize_callback' => 'travel_insight_pro_sanitize_select',
		'default'			=> $options['tours_icon'],
	) );

	$wp_customize->add_control( 'travel_insight_pro_theme_options[tours_icon_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Tour icon %d', 'travel-insight-pro' ), $i ),
		'section'         	=> 'travel_insight_pro_tours',
		'type'            	=> 'select',
		'active_callback' 	=> 'travel_insight_pro_tours_custom_icon',
		'choices'         	=> travel_insight_pro_icons_options(),
	) );

	// tours Section background setting and control.
	$wp_customize->add_setting( 'travel_insight_pro_theme_options[tours_icon_image_' . $i . ']', array(
		'sanitize_callback' => 'travel_insight_pro_sanitize_image',
	) );

	$wp_customize->add_control(
		new WP_Customize_Image_Control( $wp_customize, 'travel_insight_pro_theme_options[tours_icon_image_' . $i . ']',
			array(
			'label'       		=> sprintf( esc_html__( 'Select Tour icon %d', 'travel-insight-pro' ), $i ),
			'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'travel-insight-pro' ), 150, 150 ),
			'section'     		=> 'travel_insight_pro_tours',
			'active_callback'	=> 'travel_insight_pro_tours_custom_image',
	) ) );
}