<?php
/**
 * 404 options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

// 404 Section
$wp_customize->add_section( 'travel_insight_pro_404',
	array(
		'title'      			=> esc_html__( '404 Options', 'travel-insight-pro' ),
		'priority'   			=> 900,
		'panel'      			=> 'travel_insight_pro_theme_options_panel',
	)
);

// Slider Section background setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[404_image]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_image'
) );

$wp_customize->add_control(
	new WP_Customize_Image_Control( $wp_customize, 'travel_insight_pro_theme_options[404_image]',
		array(
		'label'       		=> esc_html__( 'Select 404 Image', 'travel-insight-pro' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx in png format.', 'travel-insight-pro' ), 482, 212 ),
		'section'     		=> 'travel_insight_pro_404',
) ) );
