<?php
/**
 * Breadcrumb options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

$wp_customize->add_section( 'travel_insight_pro_breadcrumb', array(
	'title'             => esc_html__( 'Breadcrumb','travel-insight-pro' ),
	'description'       => esc_html__( 'Breadcrumb section options.', 'travel-insight-pro' ),
	'panel'             => 'travel_insight_pro_theme_options_panel',
) );

// Breadcrumb enable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[breadcrumb_enable]', array(
	'sanitize_callback'	=> 'travel_insight_pro_sanitize_checkbox',
	'default'          	=> $options['breadcrumb_enable'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[breadcrumb_enable]', array(
	'label'            	=> esc_html__( 'Enable Breadcrumb', 'travel-insight-pro' ),
	'section'          	=> 'travel_insight_pro_breadcrumb',
	'type'             	=> 'checkbox',
) );
