<?php
/**
 * Excerpt options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

// Add excerpt section
$wp_customize->add_section( 'travel_insight_pro_excerpt_section', array(
	'title'             => esc_html__( 'Excerpt','travel-insight-pro' ),
	'description'       => esc_html__( 'Excerpt section options.', 'travel-insight-pro' ),
	'panel'             => 'travel_insight_pro_theme_options_panel',
) );


// long Excerpt length setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[long_excerpt_length]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_number_range',
	'validate_callback' => 'travel_insight_pro_validate_long_excerpt',
	'default'			=> $options['long_excerpt_length'],
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[long_excerpt_length]', array(
	'label'       => esc_html__( 'Blog Page Excerpt Length', 'travel-insight-pro' ),
	'description' => esc_html__( 'Total words to be displayed in archive page/search page.', 'travel-insight-pro' ),
	'section'     => 'travel_insight_pro_excerpt_section',
	'type'        => 'number',
	'input_attrs' => array(
		'style'       => 'width: 80px;',
		'max'         => 100,
		'min'         => 5,
	),
) );
